/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.ActivitiesRestService;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class ActivitiesRestServiceTest
extends AbstractResourceTest {
    private static PortalContainer container;
    private static ActivityManager activityManager;
    private IdentityManager identityManager;
    private Identity demoIdentity;
    private Identity johnIdentity;
    private String ACTIVITIES_RESOURCE_URL;
    private final String JSON_FORMAT = ".json";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        container = this.getContainer();
        activityManager = (ActivityManager)container.getComponentInstanceOfType(ActivityManager.class);
        this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        ActivitiesRestServiceTest.assertNotNull((Object)activityManager);
        ActivitiesRestServiceTest.assertNotNull((Object)this.identityManager);
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo", false);
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john", false);
        this.ACTIVITIES_RESOURCE_URL = "/" + container.getName() + "/social/activities/";
        this.addResource(ActivitiesRestService.class, null);
        this.populateData();
    }

    @Override
    public void tearDown() throws Exception {
        this.removeResource(ActivitiesRestService.class);
        super.tearDown();
    }

    public void testDestroyActivity() throws Exception {
        ContainerResponse response = this.service("POST", "/portal/social/activities/destroy/123.json", "", null, null);
        ActivitiesRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("POST", "/portal/social/activities/destroy/123.xml", "", null, null);
        ActivitiesRestServiceTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testShowLikes() throws Exception {
    }

    public void testUpdateLike() throws Exception {
    }

    public void testDestroyLike() throws Exception {
        ExoSocialActivity activity = ((ExoSocialActivity[])activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        String activityId = activity.getId();
        activityManager.saveLike(activity, this.demoIdentity);
        activityManager.saveLike(activity, this.johnIdentity);
        int initialLikeCount = activity.getLikeIdentityIds().length;
        ActivitiesRestServiceTest.assertEquals((int)2, (int)initialLikeCount);
        String destroyLikeURL = this.ACTIVITIES_RESOURCE_URL + activity.getId() + "/likes/destroy/" + this.johnIdentity.getId() + ".json";
        ContainerResponse response = this.service("POST", destroyLikeURL, "", null, null);
        ActivitiesRestServiceTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        activity = activityManager.getActivity(activityId);
        Object[] likeIdentities = activity.getLikeIdentityIds();
        ActivitiesRestServiceTest.assertEquals((int)(initialLikeCount - 1), (int)likeIdentities.length);
        ActivitiesRestServiceTest.assertFalse((boolean)ArrayUtils.contains((Object[])likeIdentities, (Object)this.johnIdentity.getId()));
    }

    public void testShowComments() throws Exception {
    }

    public void testUpdateComment() throws Exception {
    }

    public void testDestroyComment() throws Exception {
    }

    private void populateData() throws Exception {
        this.populateActivitiesData(1, this.demoIdentity);
    }

    private void populateActivitiesData(int activitiesCount, Identity ownerIdentity) {
        for (int i = 0; i < activitiesCount; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity" + i);
            activity.setType("exosocial:core");
            activity.setPriority(Float.valueOf(1.0f));
            activity.setTitleId("");
            activity.setTemplateParams(new HashMap());
            activity.setUserId(ownerIdentity.getId());
            activityManager.saveActivityNoReturn(ownerIdentity, (ExoSocialActivity)activity);
        }
    }
}

