/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.Util;

@Path(value="{portalName}/social/identity/{username}/id")
public class IdentityRestService
implements ResourceContainer {
    private IdentityManager _identityManager;
    private static final Log LOG = ExoLogger.getLogger(IdentityRestService.class);

    @GET
    @Path(value="show.json")
    @Produces(value={"application/json"})
    public Response getId(@Context UriInfo uriInfo, @PathParam(value="username") String username, @PathParam(value="portalName") String portalName) throws Exception {
        this._identityManager = this.getIdentityManager(portalName);
        MediaType mediaType = Util.getMediaType("json");
        String id = null;
        String viewerId = Util.getViewerId();
        if (viewerId != null) {
            if (this.getIdentityManager(portalName).getOrCreateIdentity("organization", username, true) == null) {
                LOG.error((Object)"No id is found for this username. You should enter a valid and a correct value for the username parameter.");
                return Util.getResponse("No id is found for this username. You should enter a valid and a correct value for the username parameter.", uriInfo, mediaType, Response.Status.OK);
            }
            try {
                id = this._identityManager.getOrCreateIdentity("organization", username).getId();
            }
            catch (Exception ex) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            Identity identity = this.getIdentityManager(portalName).getOrCreateIdentity("organization", viewerId, true);
            if (identity == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        }
        try {
            id = this._identityManager.getOrCreateIdentity("organization", username).getId();
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        UserId userId = new UserId(id);
        return Util.getResponse(userId, uriInfo, mediaType, Response.Status.OK);
    }

    private IdentityManager getIdentityManager(String portalName) {
        if (this._identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)portalName);
            this._identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    public class UserId {
        private String _id;

        public UserId() {
        }

        public UserId(String id) {
            this._id = id;
        }

        public void setId(String id) {
            this._id = id;
        }

        public String getId() {
            return this._id;
        }

        public String toString() {
            return this._id;
        }
    }
}

