/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.api.IdentityResources;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class IdentityResourcesTest
extends AbstractResourceTest {
    private final String RESOURCE_URL = "/api/social/v1-alpha3/portal/";
    private IdentityManager identityManager;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        this.maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary");
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo");
        this.addResource(IdentityResources.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        this.removeResource(IdentityResources.class);
        super.tearDown();
    }

    public void testGetIdentityById() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap entityHashMap = (HashMap)response.getEntity();
        HashMap profileHashMap = (HashMap)entityHashMap.get("profile");
        IdentityResourcesTest.assertEquals((Object)this.demoIdentity.getId(), entityHashMap.get("id"));
        IdentityResourcesTest.assertEquals((Object)this.demoIdentity.getProviderId(), entityHashMap.get("providerId"));
        IdentityResourcesTest.assertEquals((Object)this.demoIdentity.getRemoteId(), entityHashMap.get("remoteId"));
        IdentityResourcesTest.assertEquals((Object)this.demoIdentity.getProfile().getFullName(), profileHashMap.get("fullName"));
        IdentityResourcesTest.assertNotNull(profileHashMap.get("avatarUrl"));
        IdentityResourcesTest.assertTrue((boolean)profileHashMap.get("avatarUrl").toString().endsWith(this.demoIdentity.getProfile().getAvatarUrl()));
        IdentityResourcesTest.assertNotNull(profileHashMap.get("bannerUrl"));
        IdentityResourcesTest.assertTrue((boolean)profileHashMap.get("bannerUrl").toString().endsWith(this.demoIdentity.getProfile().getBannerUrl()));
    }

    public void testGetIdentityByIdWithAnonymous() throws Exception {
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/" + this.demoIdentity.getId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getId() + ".xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/notExistIdentity.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
    }

    public void testGetIdentityByIdWithWrongPortalContainerName() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/" + this.demoIdentity.getId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/" + this.demoIdentity.getId() + ".xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/notExistIdentity.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
    }

    public void testGetIdentityByIdWithWrongSupportedFormat() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getId() + ".xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/notExistIdentity.xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), (int)response.getStatus());
    }

    public void testGetIdentityByIdWithWrongIdentityId() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/notExistIdentityId.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatus());
    }

    public void testGetIdentityProviderIdAndRemoteId() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getProviderId() + "/" + this.demoIdentity.getRemoteId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap entityHashMap = (HashMap)response.getEntity();
        HashMap profileHashMap = (HashMap)entityHashMap.get("profile");
        IdentityResourcesTest.assertEquals((Object)this.demoIdentity.getId(), entityHashMap.get("id"));
        IdentityResourcesTest.assertEquals((Object)this.demoIdentity.getProviderId(), entityHashMap.get("providerId"));
        IdentityResourcesTest.assertEquals((Object)this.demoIdentity.getRemoteId(), entityHashMap.get("remoteId"));
        IdentityResourcesTest.assertEquals((Object)this.demoIdentity.getProfile().getFullName(), profileHashMap.get("fullName"));
        IdentityResourcesTest.assertNotNull(profileHashMap.get("avatarUrl"));
        IdentityResourcesTest.assertTrue((boolean)profileHashMap.get("avatarUrl").toString().endsWith(this.demoIdentity.getProfile().getAvatarUrl()));
        IdentityResourcesTest.assertNotNull(profileHashMap.get("bannerUrl"));
        IdentityResourcesTest.assertTrue((boolean)profileHashMap.get("bannerUrl").toString().endsWith(this.demoIdentity.getProfile().getBannerUrl()));
    }

    public void testGetIdentityByProviderIdAndRemoteIdWithAnonymous() throws Exception {
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getProviderId() + "/" + this.demoIdentity.getRemoteId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/" + this.demoIdentity.getProviderId() + "/" + this.demoIdentity.getRemoteId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getProviderId() + "/" + this.demoIdentity.getRemoteId() + ".xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/notExistProvider/notExistRemoteId.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getProviderId() + "/notExistRemoteId.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
    }

    public void testGetIdentityByProviderIdAndRemoteIdWithWrongPortalContainerName() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/" + this.demoIdentity.getProviderId() + "/" + this.demoIdentity.getRemoteId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/" + this.demoIdentity.getProviderId() + "/" + this.demoIdentity.getRemoteId() + ".xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/notExistProviderId/demo.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/notExistPortalContainer/identity/" + this.demoIdentity.getProviderId() + "/notExistRemoteId.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
    }

    public void testGetIdentityByProviderIdAndRemoteIdWithWrongSupportedFormat() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getProviderId() + "/" + this.demoIdentity.getRemoteId() + ".xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/notExistProviderId/" + this.demoIdentity.getRemoteId() + ".xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getProviderId() + "/notExistRemoteId.xml", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), (int)response.getStatus());
    }

    public void testGetIdentityByProviderIdAndRemoteIdWithWrongProviderId() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/notExistProvider/" + this.demoIdentity.getRemoteId() + ".json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatus());
        response = this.service("GET", "/api/social/v1-alpha3/portal/identity/notExistProvider/notExistRemoteId.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatus());
    }

    public void testGetIdentityByProviderIdAndRemoteIdWithWrongRemoteId() throws Exception {
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/identity/" + this.demoIdentity.getProviderId() + "/notExistRemoteId.json", "", null, null);
        IdentityResourcesTest.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatus());
    }
}

