/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.provider.JsonEntityProvider;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingOperationReport;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ExperienceEntity;
import org.exoplatform.social.rest.entity.GroupNodeEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingOperationReportEntity;
import org.exoplatform.social.rest.entity.IMEntity;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.social.rest.entity.LinkEntity;
import org.exoplatform.social.rest.entity.PhoneEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.entity.SpaceMembershipEntity;
import org.exoplatform.social.rest.entity.URLEntity;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class EntityBuilder {
    private static final Log LOG = ExoLogger.getLogger(EntityBuilder.class);
    public static final String GROUP_SPACE_BINDING_REPORT_OPERATIONS_TYPE = "groupSpaceBindingReportOperations";
    public static final String USERS_TYPE = "users";
    public static final String USERS_RELATIONSHIP_TYPE = "usersRelationships";
    public static final String USER_ACTIVITY_TYPE = "user";
    public static final String IDENTITIES_TYPE = "identities";
    public static final String SPACES_TYPE = "spaces";
    public static final String SPACES_MEMBERSHIP_TYPE = "spacesMemberships";
    public static final String SPACE_ACTIVITY_TYPE = "space";
    public static final String ACTIVITIES_TYPE = "activities";
    public static final String COMMENTS_TYPE = "comments";
    public static final String LIKES_TYPE = "likes";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private static final String NEXT_ACTION = "next";
    private static final String PREV_ACTION = "prev";
    private static final String FIRST_ACTION = "first";
    private static final String LAST_ACTION = "last";
    private static final String LINK = "Link";
    public static final String GROUP_SPACE_BINDING_TYPE = "groupSpaceBindings";
    public static final String ORGANIZATION_GROUP_TYPE = "childGroups";
    public static final String REDACTOR_MEMBERSHIP = "redactor";
    private static final JsonEntityProvider JSON_ENTITY_PROVIDER = new JsonEntityProvider();
    private static SpaceService spaceService;
    private static OrganizationService organizationService;
    private static RelationshipManager relationshipManager;
    private static IdentityManager identityManager;

    public static IdentityEntity buildEntityIdentity(Identity identity, String restPath, String expand) {
        IdentityEntity identityEntity = new IdentityEntity(identity.getId());
        identityEntity.setHref(RestUtils.getRestUrl(IDENTITIES_TYPE, identity.getId(), restPath));
        identityEntity.setProviderId(identity.getProviderId());
        identityEntity.setGlobalId(identity.getGlobalId());
        identityEntity.setRemoteId(identity.getRemoteId());
        identityEntity.setDeleted(identity.isDeleted());
        if ("organization".equals(identity.getProviderId())) {
            identityEntity.setProfile(EntityBuilder.buildEntityProfile(identity.getProfile(), restPath, ""));
        } else if (SPACE_ACTIVITY_TYPE.equals(identity.getProviderId())) {
            Space space = EntityBuilder.getSpaceService().getSpaceByPrettyName(identity.getRemoteId());
            identityEntity.setSpace(EntityBuilder.buildEntityFromSpace(space, "", restPath, ""));
        }
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(identity.getId()));
        return identityEntity;
    }

    public static IdentityEntity buildEntityIdentity(String userName, String restPath, String expand) {
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName);
        return EntityBuilder.buildEntityIdentity(userIdentity, restPath, expand);
    }

    public static ProfileEntity buildEntityProfile(Space space, Profile profile, String path, String expand) {
        List<Object> expandAttributes;
        ProfileEntity entity = EntityBuilder.buildEntityProfile(profile, path, expand);
        String userId = profile.getIdentity().getRemoteId();
        entity.setIsSpacesManager(spaceService.isSuperManager(userId));
        entity.setIsManager(spaceService.isManager(space, userId));
        entity.setIsSpaceRedactor(SpaceUtils.isUserHasMembershipTypesInGroup((String)userId, (String)space.getGroupId(), (String)REDACTOR_MEMBERSHIP));
        entity.setIsMember(spaceService.isMember(space, userId));
        entity.setIsInvited(spaceService.isInvitedUser(space, userId));
        entity.setIsPending(spaceService.isPendingUser(space, userId));
        String[] expandArray = StringUtils.split((String)expand, (String)",");
        List<Object> list = expandAttributes = expandArray == null ? Collections.emptyList() : Arrays.asList(expandArray);
        if (expandAttributes.contains("binding") || expandAttributes.contains("all")) {
            GroupSpaceBindingService spaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
            entity.setIsGroupBound(spaceBindingService.countUserBindings(space.getId(), userId) > 0L);
        }
        return entity;
    }

    public static ProfileEntity buildEntityProfile(Profile profile, String restPath, String expand) {
        Identity currentUserIdentity;
        String currentUser;
        ConversationState conversationState;
        List<Object> expandAttributes;
        ProfileEntity userEntity = new ProfileEntity(profile.getId());
        userEntity.setHref(RestUtils.getRestUrl(USERS_TYPE, profile.getIdentity().getRemoteId(), restPath));
        userEntity.setIdentity(RestUtils.getRestUrl(IDENTITIES_TYPE, profile.getIdentity().getId(), restPath));
        userEntity.setUsername(profile.getIdentity().getRemoteId());
        userEntity.setFirstname((String)profile.getProperty("firstName"));
        userEntity.setLastname((String)profile.getProperty("lastName"));
        userEntity.setFullname(profile.getFullName());
        userEntity.setGender(profile.getGender());
        userEntity.setPosition(profile.getPosition());
        userEntity.setEmail(profile.getEmail());
        userEntity.setAboutMe((String)profile.getProperty("aboutMe"));
        userEntity.setAvatar(profile.getAvatarUrl());
        userEntity.setBanner(profile.getBannerUrl());
        try {
            OrganizationService organizationService = EntityBuilder.getOrganizationService();
            User user = organizationService.getUserHandler().findUserByName(userEntity.getUsername());
            if (user != null) {
                userEntity.setIsInternal(user.isInternalStore());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while checking internal store user", (Throwable)e);
        }
        EntityBuilder.buildPhoneEntities(profile, userEntity);
        EntityBuilder.buildImEntities(profile, userEntity);
        EntityBuilder.buildUrlEntities(profile, userEntity);
        EntityBuilder.buildExperienceEntities(profile, userEntity);
        userEntity.setDeleted(profile.getIdentity().isDeleted());
        userEntity.setEnabled(profile.getIdentity().isEnable());
        if (profile.getProperty("external") != null) {
            userEntity.setIsExternal((String)profile.getProperty("external"));
        }
        userEntity.setCompany((String)profile.getProperty("company"));
        userEntity.setLocation((String)profile.getProperty("location"));
        userEntity.setDepartment((String)profile.getProperty("department"));
        userEntity.setTeam((String)profile.getProperty("team"));
        userEntity.setProfession((String)profile.getProperty("profession"));
        userEntity.setCountry((String)profile.getProperty("country"));
        userEntity.setCity((String)profile.getProperty("city"));
        String[] expandArray = StringUtils.split((String)expand, (String)",");
        List<Object> list = expandAttributes = expandArray == null ? Collections.emptyList() : Arrays.asList(expandArray);
        if (expandAttributes.contains("connectionsCount")) {
            ListAccess connections = EntityBuilder.getRelationshipManager().getConnections(profile.getIdentity());
            try {
                userEntity.setConnectionsCount(String.valueOf(connections.getSize()));
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting connections count of user", (Throwable)e);
            }
        }
        if (expandAttributes.contains("spacesCount")) {
            ListAccess spaces = EntityBuilder.getSpaceService().getMemberSpaces(profile.getIdentity().getRemoteId());
            try {
                userEntity.setSpacesCount(String.valueOf(spaces.getSize()));
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
            }
        }
        if (expandAttributes.contains("connectionsInCommonCount") && (conversationState = ConversationState.getCurrent()) != null) {
            currentUser = conversationState.getIdentity().getUserId();
            if (!StringUtils.equals((CharSequence)profile.getIdentity().getRemoteId(), (CharSequence)currentUser)) {
                currentUserIdentity = EntityBuilder.getIdentityManager().getOrCreateIdentity("organization", currentUser);
                try {
                    userEntity.setConnectionsInCommonCount(String.valueOf(EntityBuilder.getRelationshipManager().getConnectionsInCommonCount(currentUserIdentity, profile.getIdentity())));
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
                }
            }
        }
        if (expandAttributes.contains("relationshipStatus") && (conversationState = ConversationState.getCurrent()) != null) {
            currentUser = conversationState.getIdentity().getUserId();
            currentUserIdentity = EntityBuilder.getIdentityManager().getOrCreateIdentity("organization", currentUser);
            try {
                Relationship relationship = EntityBuilder.getRelationshipManager().get(currentUserIdentity, profile.getIdentity());
                if (relationship != null) {
                    Relationship.Type status = relationship.getStatus();
                    if (status == Relationship.Type.PENDING) {
                        Relationship.Type relationshipStatus = StringUtils.equals((CharSequence)relationship.getSender().getRemoteId(), (CharSequence)currentUser) ? Relationship.Type.OUTGOING : Relationship.Type.INCOMING;
                        userEntity.setRelationshipStatus(relationshipStatus.name());
                    } else {
                        userEntity.setRelationshipStatus(relationship.getStatus().name());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while getting spaces count of user", (Throwable)e);
            }
        }
        return userEntity;
    }

    public static void buildPhoneEntities(Profile profile, ProfileEntity userEntity) {
        List phones = profile.getPhones();
        if (phones != null && !phones.isEmpty()) {
            ArrayList<PhoneEntity> phoneEntities = new ArrayList<PhoneEntity>();
            for (Map phone : phones) {
                phoneEntities.add(new PhoneEntity((String)phone.get(KEY), (String)phone.get(VALUE)));
            }
            userEntity.setPhones(phoneEntities);
        }
    }

    public static void buildImEntities(Profile profile, ProfileEntity userEntity) {
        List ims = (List)profile.getProperty("ims");
        if (ims != null && !ims.isEmpty()) {
            ArrayList<IMEntity> imEntities = new ArrayList<IMEntity>();
            for (Map im : ims) {
                imEntities.add(new IMEntity((String)im.get(KEY), (String)im.get(VALUE)));
            }
            userEntity.setIms(imEntities);
        }
    }

    public static void buildUrlEntities(Profile profile, ProfileEntity userEntity) {
        List urls = (List)profile.getProperty("urls");
        if (urls != null && !urls.isEmpty()) {
            ArrayList<URLEntity> urlEntities = new ArrayList<URLEntity>();
            for (Map url : urls) {
                urlEntities.add(new URLEntity((String)url.get(VALUE)));
            }
            userEntity.setUrls(urlEntities);
        }
    }

    public static void buildExperienceEntities(Profile profile, ProfileEntity userEntity) {
        List experiences = (List)profile.getProperty("experiences");
        if (experiences != null && !experiences.isEmpty()) {
            ArrayList<ExperienceEntity> experienceEntities = new ArrayList<ExperienceEntity>();
            for (Map experience : experiences) {
                String id = (String)experience.get("id");
                String company = (String)experience.get("company");
                String description = (String)experience.get("description");
                String position = (String)experience.get("position");
                String skills = (String)experience.get("skills");
                Boolean isCurrent = (Boolean)experience.get("isCurrent");
                String startDate = (String)experience.get("startDate");
                String endDate = (String)experience.get("endDate");
                if (!isCurrent.booleanValue() && StringUtils.isBlank((CharSequence)endDate)) {
                    isCurrent = true;
                }
                experienceEntities.add(new ExperienceEntity(id, company, description, position, skills, isCurrent, startDate, endDate));
            }
            userEntity.setExperiences(experienceEntities);
        }
    }

    public static ProfileEntity buildEntityProfile(String userName, String restPath, String expand) {
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName);
        return EntityBuilder.buildEntityProfile(userIdentity.getProfile(), restPath, expand);
    }

    public static List<DataEntity> buildEntityProfiles(String[] userNames, String restPath, String expand) {
        if (userNames == null || userNames.length == 0) {
            return new ArrayList<DataEntity>();
        }
        ArrayList<DataEntity> userEntities = new ArrayList<DataEntity>();
        for (int i = 0; i < userNames.length; ++i) {
            userEntities.add(EntityBuilder.buildEntityProfile(userNames[i], restPath, expand).getDataEntity());
        }
        return userEntities;
    }

    public static SpaceEntity buildEntityFromSpace(Space space, String userId, String restPath, String expand) {
        SpaceEntity spaceEntity = new SpaceEntity(space.getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            IdentityManager identityManager = EntityBuilder.getIdentityManager();
            SpaceService spaceService = EntityBuilder.getSpaceService();
            GroupSpaceBindingService groupSpaceBindingService = (GroupSpaceBindingService)CommonsUtils.getService(GroupSpaceBindingService.class);
            if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) || spaceService.isSuperManager(userId)) {
                spaceEntity.setHref(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
                Identity spaceIdentity = identityManager.getOrCreateIdentity(SPACE_ACTIVITY_TYPE, space.getPrettyName(), true);
                List<Object> expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
                LinkEntity identity = expandFields.contains("identity") ? new LinkEntity(EntityBuilder.buildEntityIdentity(spaceIdentity, restPath, null)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, spaceIdentity.getId(), restPath));
                spaceEntity.setIdentity(identity);
                spaceEntity.setHasBindings(space.hasBindings());
                spaceEntity.setTotalBoundUsers(groupSpaceBindingService.countBoundUsers(space.getId()));
                spaceEntity.setApplications(EntityBuilder.getSpaceApplications(space));
                LinkEntity managers = expandFields.contains("managers") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getManagers(), restPath, expand)) : new LinkEntity(EntityBuilder.getMembersSpaceRestUrl(space.getId(), true, restPath));
                spaceEntity.setManagers(managers);
                LinkEntity members = expandFields.contains("members") ? new LinkEntity(EntityBuilder.buildEntityProfiles(space.getMembers(), restPath, expand)) : new LinkEntity(EntityBuilder.getMembersSpaceRestUrl(space.getId(), false, restPath));
                spaceEntity.setMembers(members);
                if (expandFields.contains("membersCount")) {
                    spaceEntity.setMembersCount(space.getMembers().length);
                }
                if (expandFields.contains("pending")) {
                    LinkEntity pending = new LinkEntity(EntityBuilder.buildEntityProfiles(space.getPendingUsers(), restPath, expand));
                    spaceEntity.setPending(pending);
                }
            }
            boolean isManager = spaceService.isManager(space, userId);
            spaceEntity.setIsPending(spaceService.isPendingUser(space, userId));
            spaceEntity.setIsInvited(spaceService.isInvitedUser(space, userId));
            spaceEntity.setIsMember(spaceService.isMember(space, userId));
            spaceEntity.setCanEdit(spaceService.isSuperManager(userId) || isManager);
            spaceEntity.setIsManager(isManager);
        }
        spaceEntity.setDisplayName(space.getDisplayName());
        spaceEntity.setLastUpdatedTime(space.getLastUpdatedTime());
        spaceEntity.setTemplate(space.getTemplate());
        spaceEntity.setPrettyName(space.getPrettyName());
        spaceEntity.setGroupId(space.getGroupId());
        spaceEntity.setDescription(StringEscapeUtils.unescapeHtml((String)space.getDescription()));
        spaceEntity.setUrl(LinkProvider.getSpaceUri((String)space.getPrettyName()));
        spaceEntity.setAvatarUrl(space.getAvatarUrl());
        spaceEntity.setBannerUrl(space.getBannerUrl());
        spaceEntity.setVisibility(space.getVisibility());
        spaceEntity.setSubscription(space.getRegistration());
        spaceEntity.setMembersCount(space.getMembers().length);
        spaceEntity.setManagersCount(space.getManagers().length);
        return spaceEntity;
    }

    public static SpaceMembershipEntity buildEntityFromSpaceMembership(Space space, String userId, String type, String restPath, String expand) {
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(type));
        String id = space.getPrettyName() + ":" + userId + ":" + type;
        SpaceMembershipEntity spaceMembership = new SpaceMembershipEntity(id);
        spaceMembership.setHref(RestUtils.getRestUrl(SPACES_MEMBERSHIP_TYPE, id, restPath));
        LinkEntity userEntity = USERS_TYPE.equals(expand) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, "")) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, userId, restPath));
        spaceMembership.setDataUser(userEntity);
        LinkEntity spaceEntity = SPACES_TYPE.equals(expand) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, "")) : new LinkEntity(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
        spaceMembership.setDataSpace(spaceEntity);
        spaceMembership.setRole(type);
        switch (type) {
            case "invited": {
                spaceMembership.setStatus("invited");
                break;
            }
            case "pending": {
                spaceMembership.setStatus("pending");
                break;
            }
            case "ignored": {
                spaceMembership.setStatus("ignored");
                break;
            }
            default: {
                spaceMembership.setStatus("approved");
            }
        }
        return spaceMembership;
    }

    public static ActivityEntity buildEntityFromActivity(ExoSocialActivity activity, String restPath, String expand) {
        LinkEntity commentLink;
        Identity poster = EntityBuilder.getIdentityManager().getIdentity(activity.getPosterId(), true);
        ActivityEntity activityEntity = new ActivityEntity(activity);
        activityEntity.setHref(RestUtils.getRestUrl(ACTIVITIES_TYPE, activity.getId(), restPath));
        LinkEntity identityLink = expand != null && "identity".equals(expand) ? new LinkEntity(EntityBuilder.buildEntityIdentity(poster, restPath, null)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, activity.getPosterId(), restPath));
        activityEntity.setDatIdentity(identityLink);
        activityEntity.setOwner(EntityBuilder.getActivityOwner(poster, restPath));
        activityEntity.setMentions(EntityBuilder.getActivityMentions(activity, restPath));
        activityEntity.setAttachments(new ArrayList<DataEntity>());
        if (expand != null && COMMENTS_TYPE.equals(expand)) {
            List<DataEntity> commentsEntity = EntityBuilder.buildEntityFromComment(activity, restPath, "", 0, 0);
            commentLink = new LinkEntity(commentsEntity);
        } else {
            commentLink = new LinkEntity(EntityBuilder.getCommentsActivityRestUrl(activity.getId(), restPath));
        }
        activityEntity.setComments(commentLink);
        activityEntity.setLikes(new LinkEntity(RestUtils.getBaseRestUrl() + "/" + "v1" + "/social/activities/" + activity.getId() + "/likes"));
        activityEntity.setCreateDate(RestUtils.formatISO8601(new Date(activity.getPostedTime())));
        activityEntity.setUpdateDate(RestUtils.formatISO8601(activity.getUpdated()));
        EntityBuilder.updateCachedLastModifiedValue(activity.getUpdated());
        return activityEntity;
    }

    public static boolean expandSubComments(String expand) {
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            List<String> expandFields = Arrays.asList(expand.split(","));
            return expandFields.contains("subComments");
        }
        return false;
    }

    public static CommentEntity buildEntityFromComment(ExoSocialActivity comment, String restPath, String expand, boolean isBuildList) {
        Identity poster = EntityBuilder.getIdentityManager().getIdentity(comment.getPosterId(), true);
        CommentEntity commentEntity = new CommentEntity(comment.getId());
        commentEntity.setHref(RestUtils.getRestUrl(ACTIVITIES_TYPE, comment.getId(), restPath));
        List<Object> expandFields = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            expandFields = Arrays.asList(expand.split(","));
        }
        LinkEntity identityLink = expandFields.contains("identity") ? new LinkEntity(EntityBuilder.buildEntityIdentity(poster, restPath, null)) : new LinkEntity(RestUtils.getRestUrl(IDENTITIES_TYPE, comment.getPosterId(), restPath));
        commentEntity.setDataIdentity(identityLink);
        commentEntity.setPoster(poster.getRemoteId());
        commentEntity.setTitle(comment.getTitle());
        commentEntity.setBody(comment.getBody() == null ? comment.getTitle() : comment.getBody());
        commentEntity.setParentCommentId(comment.getParentCommentId());
        commentEntity.setMentions(EntityBuilder.getActivityMentions(comment, restPath));
        if (expandFields.contains(LIKES_TYPE)) {
            commentEntity.setLikes(new LinkEntity(EntityBuilder.buildEntityFromLike(comment, restPath, null, 0, 0)));
        } else {
            commentEntity.setLikes(new LinkEntity(RestUtils.getBaseRestUrl() + "/" + "v1" + "/social/comments/" + comment.getId() + "/likes"));
        }
        commentEntity.setCreateDate(RestUtils.formatISO8601(new Date(comment.getPostedTime())));
        commentEntity.setUpdateDate(RestUtils.formatISO8601(comment.getUpdated()));
        commentEntity.setActivity(RestUtils.getRestUrl(ACTIVITIES_TYPE, comment.getParentId(), restPath));
        if (!isBuildList) {
            EntityBuilder.updateCachedLastModifiedValue(comment.getUpdated());
        }
        return commentEntity;
    }

    public static List<DataEntity> buildEntityFromComment(ExoSocialActivity activity, String restPath, String expand, int offset, int limit) {
        ArrayList<DataEntity> commentsEntity = new ArrayList<DataEntity>();
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        RealtimeListAccess listAccess = activityManager.getCommentsWithListAccess(activity, EntityBuilder.expandSubComments(expand));
        List comments = listAccess.loadAsList(offset, limit);
        for (ExoSocialActivity comment : comments) {
            CommentEntity commentInfo = EntityBuilder.buildEntityFromComment(comment, restPath, expand, true);
            commentsEntity.add(commentInfo.getDataEntity());
        }
        return commentsEntity;
    }

    public static List<DataEntity> buildEntityFromLike(ExoSocialActivity activity, String restPath, String expand, int offset, int limit) {
        ArrayList<DataEntity> likesEntity = new ArrayList<DataEntity>();
        List<String> likerIds = Arrays.asList(activity.getLikeIdentityIds());
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        for (String likerId : likerIds) {
            ProfileEntity likerInfo = EntityBuilder.buildEntityProfile(identityManager.getIdentity(likerId, false).getRemoteId(), restPath, expand);
            likesEntity.add(likerInfo.getDataEntity());
        }
        return likesEntity;
    }

    public static RelationshipEntity buildEntityRelationship(Relationship relationship, String restPath, String expand, boolean isSymetric) {
        if (relationship == null) {
            return new RelationshipEntity();
        }
        RelationshipEntity relationshipEntity = new RelationshipEntity(relationship.getId());
        relationshipEntity.setHref(RestUtils.getRestUrl(USERS_RELATIONSHIP_TYPE, relationship.getId(), restPath));
        List<Object> expandFields = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            expandFields = Arrays.asList(expand.split(","));
        }
        LinkEntity sender = expandFields.contains("sender") ? new LinkEntity(EntityBuilder.buildEntityProfile(relationship.getSender().getProfile(), restPath, null)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, relationship.getSender().getRemoteId(), restPath));
        relationshipEntity.setDataSender(sender);
        LinkEntity receiver = expandFields.contains("receiver") ? new LinkEntity(EntityBuilder.buildEntityProfile(relationship.getReceiver().getProfile(), restPath, null)) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, relationship.getReceiver().getRemoteId(), restPath));
        relationshipEntity.setDataReceiver(receiver);
        relationshipEntity.setStatus(relationship.getStatus().name());
        if (isSymetric) {
            relationshipEntity.setSymetric(relationship.isSymetric());
        }
        EntityBuilder.updateCachedEtagValue(EntityBuilder.getEtagValue(relationship.getId()));
        return relationshipEntity;
    }

    public static List<DataEntity> buildRelationshipEntities(List<Relationship> relationships, UriInfo uriInfo) {
        ArrayList<DataEntity> infos = new ArrayList<DataEntity>();
        for (Relationship relationship : relationships) {
            infos.add(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), RestUtils.getQueryParam(uriInfo, "expand"), true).getDataEntity());
        }
        return infos;
    }

    public static SpaceMembershipEntity createSpaceMembershipForIgnoredStatus(Space space, String userId, String type, String restPath, String expand) {
        String id = space.getPrettyName() + ":" + userId + ":" + type;
        SpaceMembershipEntity spaceMembership = new SpaceMembershipEntity(id);
        spaceMembership.setHref(RestUtils.getRestUrl(SPACES_MEMBERSHIP_TYPE, id, restPath));
        LinkEntity userEntity = USERS_TYPE.equals(expand) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, "")) : new LinkEntity(RestUtils.getRestUrl(USERS_TYPE, userId, restPath));
        spaceMembership.setDataUser(userEntity);
        LinkEntity spaceEntity = SPACES_TYPE.equals(expand) ? new LinkEntity(EntityBuilder.buildEntityProfile(userId, restPath, "")) : new LinkEntity(RestUtils.getRestUrl(SPACES_TYPE, space.getId(), restPath));
        spaceMembership.setDataSpace(spaceEntity);
        spaceMembership.setRole(type);
        spaceMembership.setStatus("ignored");
        return spaceMembership;
    }

    private static DataEntity getActivityOwner(Identity owner, String restPath) {
        BaseEntity mentionEntity = new BaseEntity(owner.getId());
        mentionEntity.setHref(RestUtils.getRestUrl(EntityBuilder.getIdentityType(owner), EntityBuilder.getIdentityId(owner), restPath));
        return mentionEntity.getDataEntity();
    }

    private static String getIdentityType(Identity owner) {
        return "organization".equals(owner.getProviderId()) ? USERS_TYPE : SPACES_TYPE;
    }

    private static String getIdentityId(Identity identity) {
        if ("organization".equals(identity.getProviderId())) {
            return identity.getRemoteId();
        }
        String spacePrettyName = identity.getRemoteId();
        SpaceService spaceService = EntityBuilder.getSpaceService();
        Space space = spaceService.getSpaceByPrettyName(spacePrettyName);
        return space.getId();
    }

    private static List<DataEntity> getActivityMentions(ExoSocialActivity activity, String restPath) {
        ArrayList<DataEntity> mentions = new ArrayList<DataEntity>();
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        for (String mentionner : activity.getMentionedIds()) {
            String mentionnerId = mentionner.split("@")[0];
            mentions.add(EntityBuilder.getActivityOwner(identityManager.getIdentity(mentionnerId, false), restPath));
        }
        return mentions;
    }

    public static DataEntity getActivityStream(ExoSocialActivity activity, Identity authentiatedUsed) {
        DataEntity as = new DataEntity();
        IdentityManager identityManager = EntityBuilder.getIdentityManager();
        Identity owner = identityManager.getOrCreateIdentity("organization", activity.getStreamOwner(), true);
        SpaceService spaceService = EntityBuilder.getSpaceService();
        if (owner != null) {
            Relationship relationship = EntityBuilder.getRelationshipManager().get(authentiatedUsed, owner);
            if (!(authentiatedUsed.getId().equals(activity.getPosterId()) || authentiatedUsed.getRemoteId().equals(activity.getStreamOwner()) || relationship != null && relationship.getStatus().equals((Object)Relationship.Type.CONFIRMED) || RestUtils.isMemberOfAdminGroup())) {
                return null;
            }
            as.put("type", USER_ACTIVITY_TYPE);
        } else {
            owner = identityManager.getOrCreateIdentity(SPACE_ACTIVITY_TYPE, activity.getStreamOwner(), true);
            Space space = spaceService.getSpaceByPrettyName(owner.getRemoteId());
            if (space == null || !spaceService.isSuperManager(authentiatedUsed.getRemoteId()) && !spaceService.isMember(space, authentiatedUsed.getRemoteId())) {
                return null;
            }
            as.put("type", SPACE_ACTIVITY_TYPE);
        }
        as.put("id", owner.getRemoteId());
        return as;
    }

    private static List<DataEntity> getSpaceApplications(Space space) {
        ArrayList<DataEntity> spaceApplications = new ArrayList<DataEntity>();
        String installedApps = space.getApp();
        if (installedApps != null) {
            String[] appStatuses;
            for (String appStatus : appStatuses = installedApps.split(",")) {
                String[] apps = appStatus.split(":");
                BaseEntity app = new BaseEntity(apps[0]);
                app.setProperty("displayName", apps.length > 1 ? apps[1] : "");
                spaceApplications.add(app.getDataEntity());
            }
        }
        return spaceApplications;
    }

    private static void updateCachedEtagValue(int etagValue) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        ac.setProperty("ETag", String.valueOf(etagValue));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static void updateCachedLastModifiedValue(Date lastModifiedDate) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        ac.setProperty("updateDate", String.valueOf(lastModifiedDate.getTime()));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static int getEtagValue(String ... properties) {
        int prime = 31;
        int result = 0;
        for (String prop : properties) {
            if (prop == null) continue;
            result = 31 * result + prop.hashCode();
        }
        return result;
    }

    public static String getMembersSpaceRestUrl(String id, boolean returnManager, String restPath) {
        StringBuffer spaceMembersRestUrl = new StringBuffer(RestUtils.getRestUrl(SPACES_TYPE, id, restPath)).append("/").append(USERS_TYPE);
        if (returnManager) {
            return spaceMembersRestUrl.append("?role=manager").toString();
        }
        return spaceMembersRestUrl.toString();
    }

    public static String getCommentsActivityRestUrl(String activityId, String restPath) {
        return new StringBuffer(RestUtils.getRestUrl(ACTIVITIES_TYPE, activityId, restPath)).append("/").append(COMMENTS_TYPE).toString();
    }

    public static Response.ResponseBuilder getResponseBuilder(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        if (entity instanceof BaseEntity) {
            entity = ((BaseEntity)entity).getDataEntity();
        }
        Response.ResponseBuilder responseBuilder = Response.created((URI)uriInfo.getAbsolutePath()).entity(entity).type(mediaType.toString() + "; charset=utf-8").status(status);
        if (EntityBuilder.hasPaging(entity)) {
            responseBuilder.header(LINK, EntityBuilder.buildLinkForHeader(entity, uriInfo.getAbsolutePath().toString()));
        }
        return responseBuilder;
    }

    public static Response getResponse(Object entity, UriInfo uriInfo, MediaType mediaType, Response.Status status) {
        Response.ResponseBuilder responseBuilder = EntityBuilder.getResponseBuilder(entity, uriInfo, mediaType, status);
        return responseBuilder.build();
    }

    private static boolean hasPaging(Object entity) {
        if (!(entity instanceof CollectionEntity)) {
            return false;
        }
        CollectionEntity rc = (CollectionEntity)entity;
        int size = rc.getSize();
        int offset = rc.getOffset();
        int limit = rc.getLimit();
        return size > 0 && limit != 0 && offset <= size && size > limit;
    }

    public static Object buildLinkForHeader(Object entity, String requestPath) {
        CollectionEntity rc = (CollectionEntity)entity;
        int size = rc.getSize();
        int offset = rc.getOffset();
        int limit = rc.getLimit();
        StringBuilder linkHeader = new StringBuilder();
        if (EntityBuilder.hasNext(size, offset, limit)) {
            int nextOS = offset + limit;
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, nextOS, limit, NEXT_ACTION));
        }
        if (EntityBuilder.hasPrevious(size, offset, limit)) {
            int preOS = offset - limit;
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, preOS, limit, PREV_ACTION));
        }
        if (EntityBuilder.hasFirst(size, offset, limit)) {
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, 0, limit, FIRST_ACTION));
        }
        if (EntityBuilder.hasLast(size, offset, limit)) {
            int pages = (int)Math.ceil((double)size / (double)limit);
            int lastOS = (pages - 1) * limit;
            EntityBuilder.appendCommaIfNecessary(linkHeader);
            linkHeader.append(EntityBuilder.createLinkHeader(requestPath, lastOS, limit, LAST_ACTION));
        }
        return linkHeader.toString();
    }

    private static boolean hasNext(int size, int offset, int limit) {
        return size > offset + limit;
    }

    private static boolean hasPrevious(int size, int offset, int limit) {
        if (offset == 0) {
            return false;
        }
        return offset >= limit;
    }

    private static boolean hasFirst(int size, int offset, int limit) {
        return EntityBuilder.hasPrevious(size, offset, limit);
    }

    private static boolean hasLast(int size, int offset, int limit) {
        if (offset + limit == size) {
            return false;
        }
        return EntityBuilder.hasNext(size, offset, limit);
    }

    private static void appendCommaIfNecessary(StringBuilder linkHeader) {
        if (linkHeader.length() > 0) {
            linkHeader.append(", ");
        }
    }

    private static String createLinkHeader(String uri, int offset, int limit, String rel) {
        return "<" + uri + "?offset=" + offset + "&limit=" + limit + ">; rel=\"" + rel + "\"";
    }

    public static GroupSpaceBindingEntity buildEntityFromGroupSpaceBinding(GroupSpaceBinding binding) {
        GroupSpaceBindingEntity groupSpaceBindingEntity = new GroupSpaceBindingEntity();
        groupSpaceBindingEntity.setId(Long.toString(binding.getId()));
        groupSpaceBindingEntity.setSpaceId(binding.getSpaceId());
        groupSpaceBindingEntity.setGroup(binding.getGroup());
        return groupSpaceBindingEntity;
    }

    public static GroupNodeEntity buildEntityFromGroup(Group group) {
        GroupNodeEntity groupNodeEntity = new GroupNodeEntity();
        groupNodeEntity.setId(group.getId());
        String groupName = group.getLabel() != null ? group.getLabel() : group.getGroupName();
        groupNodeEntity.setGroupName(groupName);
        String parentId = group.getParentId() == null ? "root" : group.getParentId();
        groupNodeEntity.setParentId(parentId);
        groupNodeEntity.setBound(false);
        groupNodeEntity.setChildGroupNodesEntities(new ArrayList<DataEntity>());
        return groupNodeEntity;
    }

    public static GroupNodeEntity buildEntityFromGroupId(String group) {
        GroupNodeEntity groupNodeEntity = new GroupNodeEntity();
        groupNodeEntity.setId(group);
        groupNodeEntity.setGroupName(group);
        groupNodeEntity.setParentId("");
        groupNodeEntity.setChildGroupNodesEntities(new ArrayList<DataEntity>());
        return groupNodeEntity;
    }

    public static GroupSpaceBindingOperationReportEntity buildEntityFromGroupSpaceBindingOperationReport(GroupSpaceBindingOperationReport bindingOperationReport) {
        GroupSpaceBindingOperationReportEntity operationReportEntity = new GroupSpaceBindingOperationReportEntity();
        operationReportEntity.setOperationType(bindingOperationReport.getAction());
        operationReportEntity.setBindingId(Long.toString(bindingOperationReport.getGroupSpaceBindingId()));
        operationReportEntity.setAddedUsersCount(Long.toString(bindingOperationReport.getAddedUsers()));
        operationReportEntity.setRemovedUsersCount(Long.toString(bindingOperationReport.getRemovedUsers()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/YYYY HH:mm:ss");
        Date startDate = bindingOperationReport.getStartDate();
        Date endDate = bindingOperationReport.getEndDate();
        operationReportEntity.setStartDate(startDate != null ? dateFormat.format(startDate) : "null");
        operationReportEntity.setEndDate(endDate != null ? dateFormat.format(endDate) : "null");
        return operationReportEntity;
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
            new JsonParserImpl().parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
            return (T)ObjectBuilder.createObject(resultClass, (JsonValue)jsonDefaultHandler.getJsonObject());
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error creating object from string : " + value, e);
        }
    }

    public static String toJsonString(Object object) {
        if (object == null) {
            return "{}";
        }
        try {
            ByteArrayOutputStream entityStream = new ByteArrayOutputStream();
            JSON_ENTITY_PROVIDER.writeTo(object, object.getClass(), object.getClass(), null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)entityStream);
            return entityStream.toString(Charset.defaultCharset().name());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to transform object " + object, e);
        }
    }

    public static IdentityManager getIdentityManager() {
        if (identityManager == null) {
            identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        }
        return identityManager;
    }

    public static SpaceService getSpaceService() {
        if (spaceService == null) {
            spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return spaceService;
    }

    public static OrganizationService getOrganizationService() {
        if (organizationService == null) {
            organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        }
        return organizationService;
    }

    public static RelationshipManager getRelationshipManager() {
        if (relationshipManager == null) {
            relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        }
        return relationshipManager;
    }
}

