/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.impl.binding.GroupSpaceBindingRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.junit.Test;

public class GroupSpaceBindingRestServiceTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private GroupSpaceBindingRestResourcesV1 groupSpaceBindingRestResourcesV1;
    private SpaceService spaceService;
    private UserACL userACL;
    private GroupSpaceBindingService groupSpaceBindingService;
    private String spaceId1;
    private String spaceId2;
    private List<GroupSpaceBinding> tearDownbindingList = new ArrayList<GroupSpaceBinding>();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.deleteAllSpaces();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        GroupSpaceBindingRestServiceTest.assertNotNull((Object)this.identityManager);
        this.identityManager.getOrCreateIdentity("organization", "root", true);
        this.identityManager.getOrCreateIdentity("organization", "john", true);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.userACL = (UserACL)this.getContainer().getComponentInstanceOfType(UserACL.class);
        this.groupSpaceBindingService = (GroupSpaceBindingService)this.getContainer().getComponentInstanceOfType(GroupSpaceBindingService.class);
        this.groupSpaceBindingRestResourcesV1 = new GroupSpaceBindingRestResourcesV1(this.spaceService, this.groupSpaceBindingService, this.userACL);
        this.registry(this.groupSpaceBindingRestResourcesV1);
    }

    @Override
    public void tearDown() throws Exception {
        this.deleteAllBindings();
        super.tearDown();
        this.removeResource(this.groupSpaceBindingRestResourcesV1.getClass());
    }

    protected void deleteAllBindings() {
        if (this.spaceId1 != null) {
            for (GroupSpaceBinding binding : this.groupSpaceBindingService.findGroupSpaceBindingsBySpace(this.spaceId1)) {
                this.groupSpaceBindingService.deleteGroupSpaceBinding(binding);
            }
        }
    }

    @Test
    public void testGroupSpaceBindings() throws Exception {
        this.startSessionAs("root");
        this.spaceId1 = this.createSpace("space1", "").getId();
        LinkedList<GroupSpaceBinding> groupSpaceBindings = new LinkedList<GroupSpaceBinding>();
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId(this.spaceId1);
        groupSpaceBindings.add(binding1);
        this.tearDownbindingList.add(binding1);
        GroupSpaceBinding binding2 = new GroupSpaceBinding();
        binding2.setGroup("/platform/web-contributors");
        binding2.setSpaceId(this.spaceId1);
        groupSpaceBindings.add(binding2);
        this.tearDownbindingList.add(binding2);
        GroupSpaceBinding binding3 = new GroupSpaceBinding();
        binding3.setGroup("/platform/web-contributors");
        binding3.setSpaceId(this.spaceId1);
        groupSpaceBindings.add(binding3);
        this.tearDownbindingList.add(binding3);
        groupSpaceBindings.stream().forEach(groupSpaceBinding -> this.groupSpaceBindingService.saveGroupSpaceBinding(groupSpaceBinding));
        ContainerResponse response = this.service("GET", this.getURLResource("spaceGroupBindings/" + this.spaceId1), "", null, null);
        GroupSpaceBindingRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        this.endSession();
    }

    @Test
    public void testGetBindingReportOperations() throws Exception {
        this.startSessionAs("root");
        this.spaceId1 = this.createSpace("space1", "").getId();
        LinkedList<GroupSpaceBinding> groupSpaceBindings = new LinkedList<GroupSpaceBinding>();
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId(this.spaceId1);
        groupSpaceBindings.add(binding1);
        this.tearDownbindingList.add(binding1);
        GroupSpaceBinding binding2 = new GroupSpaceBinding();
        binding2.setGroup("/platform/web-contributors");
        binding2.setSpaceId(this.spaceId1);
        groupSpaceBindings.add(binding2);
        this.tearDownbindingList.add(binding2);
        GroupSpaceBinding binding3 = new GroupSpaceBinding();
        binding3.setGroup("/platform/web-contributors");
        binding3.setSpaceId(this.spaceId1);
        groupSpaceBindings.add(binding3);
        this.tearDownbindingList.add(binding3);
        groupSpaceBindings.stream().forEach(groupSpaceBinding -> this.groupSpaceBindingService.saveGroupSpaceBinding(groupSpaceBinding));
        ContainerResponse response = this.service("GET", this.getURLResource("spaceGroupBindings/getBindingReportOperations"), "", null, null);
        GroupSpaceBindingRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        this.endSession();
    }

    @Test
    public void testDeleteSpaceBinding() throws Exception {
        this.startSessionAs("root");
        this.spaceId2 = this.createSpace("space2", "").getId();
        LinkedList<GroupSpaceBinding> groupSpaceBindings = new LinkedList<GroupSpaceBinding>();
        GroupSpaceBinding binding1 = new GroupSpaceBinding();
        binding1.setGroup("/platform/administrators");
        binding1.setSpaceId(this.spaceId2);
        groupSpaceBindings.add(binding1);
        this.tearDownbindingList.add(binding1);
        GroupSpaceBinding binding = this.groupSpaceBindingService.saveGroupSpaceBinding(binding1);
        ContainerResponse response = this.service("DELETE", this.getURLResource("spaceGroupBindings/removeGroupSpaceBinding/" + String.valueOf(binding.getId())), "", null, null);
        GroupSpaceBindingRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        this.endSession();
    }

    private Space createSpace(String name, String apps) throws Exception {
        Space space = new Space();
        space.setDisplayName(name);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + name);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/" + name);
        space.setApp(apps);
        String[] managers = new String[]{"john", "mary"};
        String[] members = new String[]{"john", "mary", "demo"};
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        space.setAvatarUrl("/profile/my_avatar_" + name);
        this.spaceService.createSpace(space, "john");
        return space;
    }
}

