/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.userrelationship;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.impl.userrelationship.UsersRelationshipsRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class UsersRelationshipsRestResourcesTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private UsersRelationshipsRestResourcesV1 usersRelationshipsRestService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityManager.saveIdentity(this.rootIdentity);
        this.identityManager.saveIdentity(this.johnIdentity);
        this.identityManager.saveIdentity(this.maryIdentity);
        this.identityManager.saveIdentity(this.demoIdentity);
        this.usersRelationshipsRestService = new UsersRelationshipsRestResourcesV1(this.relationshipManager);
        this.registry(this.usersRelationshipsRestService);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(this.usersRelationshipsRestService.getClass());
    }

    public void testGetUserRelationships() throws Exception {
        Relationship relationship1 = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship1);
        Relationship relationship2 = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        this.relationshipManager.update(relationship2);
        Relationship relationship3 = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship3);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("usersRelationships"), "", null, null);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)response);
        UsersRelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        List relationships = collections.getEntities();
        UsersRelationshipsRestResourcesTest.assertEquals((int)3, (int)relationships.size());
        List relationshipsIds = relationships.stream().map(relationship -> relationship.get((Object)"id")).collect(Collectors.toList());
        UsersRelationshipsRestResourcesTest.assertTrue((boolean)relationshipsIds.contains(relationship1.getId()));
        UsersRelationshipsRestResourcesTest.assertTrue((boolean)relationshipsIds.contains(relationship2.getId()));
        UsersRelationshipsRestResourcesTest.assertTrue((boolean)relationshipsIds.contains(relationship3.getId()));
    }

    public void testCreateUserRelationship() throws Exception {
        this.startSessionAs("root");
        String input = "{\"sender\":root, \"receiver\":demo, \"status\":CONFIRMED}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("usersRelationships/"), input);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)response);
        UsersRelationshipsRestResourcesTest.assertEquals((String)"no user is authorized to created automatically a confirmed relationship", (int)401, (int)response.getStatus());
        input = "{\"sender\":root, \"receiver\":demo, \"status\":IGNORED}";
        response = this.getResponse("POST", this.getURLResource("usersRelationships/"), input);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)response);
        UsersRelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        Relationship rootDemo = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)rootDemo);
        UsersRelationshipsRestResourcesTest.assertEquals((String)"root", (String)rootDemo.getSender().getRemoteId());
        UsersRelationshipsRestResourcesTest.assertEquals((String)"demo", (String)rootDemo.getReceiver().getRemoteId());
        UsersRelationshipsRestResourcesTest.assertEquals((String)"IGNORED", (String)rootDemo.getStatus().name());
        input = "{\"sender\":root, \"receiver\":demo, \"status\":PENDING}";
        response = this.getResponse("POST", this.getURLResource("usersRelationships/"), input);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)response);
        UsersRelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        rootDemo = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)rootDemo);
        UsersRelationshipsRestResourcesTest.assertEquals((String)"root", (String)rootDemo.getSender().getRemoteId());
        UsersRelationshipsRestResourcesTest.assertEquals((String)"demo", (String)rootDemo.getReceiver().getRemoteId());
        UsersRelationshipsRestResourcesTest.assertEquals((String)"PENDING", (String)rootDemo.getStatus().name());
        rootDemo = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)rootDemo);
        UsersRelationshipsRestResourcesTest.assertEquals((String)"root", (String)rootDemo.getSender().getRemoteId());
        UsersRelationshipsRestResourcesTest.assertEquals((String)"demo", (String)rootDemo.getReceiver().getRemoteId());
        UsersRelationshipsRestResourcesTest.assertEquals((String)"PENDING", (String)rootDemo.getStatus().name());
        input = "{\"sender\":root, \"receiver\":john, \"status\":PENDING}";
        response = this.getResponse("POST", this.getURLResource("usersRelationships/"), input);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)response);
        UsersRelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        Relationship rootJohn = this.relationshipManager.get(this.rootIdentity, this.johnIdentity);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)rootJohn);
        UsersRelationshipsRestResourcesTest.assertEquals((String)"root", (String)rootJohn.getSender().getRemoteId());
        UsersRelationshipsRestResourcesTest.assertEquals((String)"john", (String)rootJohn.getReceiver().getRemoteId());
        UsersRelationshipsRestResourcesTest.assertEquals((String)"PENDING", (String)rootJohn.getStatus().name());
    }

    public void testGetUpdateDeleteUserRelationship() throws Exception {
        Relationship relationship = new Relationship(this.demoIdentity, this.rootIdentity, Relationship.Type.PENDING);
        this.relationshipManager.update(relationship);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("usersRelationships/" + relationship.getId()), "", null, null);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)response);
        UsersRelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        String input = "{\"status\":PENDING}";
        response = this.getResponse("PUT", this.getURLResource("usersRelationships/" + relationship.getId()), input);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)response);
        UsersRelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        UsersRelationshipsRestResourcesTest.assertEquals((String)"When both users sent connection requests, automatically the relationship must be CONFIRMED", (String)"CONFIRMED", (String)relationship.getStatus().name());
        response = this.service("DELETE", this.getURLResource("usersRelationships/" + relationship.getId()), "", null, null);
        UsersRelationshipsRestResourcesTest.assertNotNull((Object)response);
        UsersRelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        UsersRelationshipsRestResourcesTest.assertNull((Object)relationship);
    }
}

