/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.LegacySpaceRestServiceImpl;
import org.exoplatform.social.service.rest.BaseRestServicesTestCase;

public class LegacySpaceRestServiceTest
extends BaseRestServicesTestCase {
    @Override
    protected Class<?> getComponentClass() {
        return LegacySpaceRestServiceImpl.class;
    }

    public void testSearchSpace() throws Exception {
        String path = "/space/user/searchSpace/?fields=id,url,displayName,avatarUrl&keyword=";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        envctx.put(SecurityContext.class, (Object)new BaseRestServicesTestCase.MockSecurityContext("foo"));
        HashMap<String, Object> ssResults = new HashMap<String, Object>();
        Space space1 = new Space();
        space1.setPrettyName("space1");
        space1.setId("space1");
        space1.setGroupId("/spaces/space1");
        space1.setVisibility("hidden");
        space1.setMembers(new String[]{"foo"});
        Space space2 = new Space();
        space2.setPrettyName("space2");
        space2.setId("space2");
        space2.setGroupId("/spaces/space2");
        space2.setVisibility("public");
        space2.setRegistration("close");
        space2.setMembers(new String[]{"foo"});
        Space space3 = new Space();
        space3.setPrettyName("space3");
        space3.setId("space3");
        space3.setGroupId("/spaces/space3");
        space3.setVisibility("public");
        space3.setRegistration("open");
        space3.setMembers(new String[]{"foo"});
        Space space4 = new Space();
        space4.setPrettyName("space4");
        space4.setId("space4");
        space4.setGroupId("/spaces/space4");
        space4.setVisibility("public");
        space4.setRegistration("open");
        space4.setMembers(new String[]{"foo"});
        Space space5 = new Space();
        space5.setPrettyName("space5");
        space5.setId("space5");
        space5.setGroupId("/spaces/space5");
        space5.setVisibility("public");
        space5.setRegistration("open");
        space5.setMembers(new String[]{"foo"});
        Space space6 = new Space();
        space6.setPrettyName("space6");
        space6.setId("space6");
        space6.setGroupId("/spaces/space6");
        space6.setVisibility("public");
        space6.setRegistration("open");
        space6.setMembers(new String[]{"foo"});
        final List<Space> allSpaces = Arrays.asList(space1, space2, space3, space4, space5, space6);
        ssResults.put("getMemberSpacesByFilter", new BaseRestServicesTestCase.Invoker(){

            @Override
            public Object invoke(Object[] args) {
                String searchKeyword;
                SpaceFilter spaceFilter = (SpaceFilter)args[1];
                String string = searchKeyword = spaceFilter == null ? null : spaceFilter.getSpaceNameSearchCondition();
                if (StringUtils.isBlank((CharSequence)searchKeyword)) {
                    return new BaseRestServicesTestCase.MockListAccess<Space>(allSpaces.toArray(new Space[0]));
                }
                return new BaseRestServicesTestCase.MockListAccess<Space>(allSpaces.stream().filter(space -> space.getPrettyName().contains(searchKeyword)).collect(Collectors.toList()).toArray(new Space[0]));
            }
        });
        ssResults.put("getLastAccessedSpace", new BaseRestServicesTestCase.MockListAccess<Space>(new Space[]{space1}));
        SpaceService ss = this.createProxy(SpaceService.class, ssResults);
        this.getContainer().registerComponentInstance((Object)"SpaceService", (Object)ss);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        LegacySpaceRestServiceTest.assertEquals((int)200, (int)resp.getStatus());
        LegacySpaceRestServiceTest.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space1"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space2"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space3"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space4"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space5"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space6"));
        resp = this.launcher.service("GET", path + "space", "", null, null, envctx);
        LegacySpaceRestServiceTest.assertEquals((int)200, (int)resp.getStatus());
        LegacySpaceRestServiceTest.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space1"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space2"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space3"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space4"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space5"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space6"));
        resp = this.launcher.service("GET", path + "1", "", null, null, envctx);
        LegacySpaceRestServiceTest.assertEquals((int)200, (int)resp.getStatus());
        LegacySpaceRestServiceTest.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space1"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space2"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space3"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space4"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space5"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space6"));
        resp = this.launcher.service("GET", path + "2", "", null, null, envctx);
        LegacySpaceRestServiceTest.assertEquals((int)200, (int)resp.getStatus());
        LegacySpaceRestServiceTest.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space1"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space2"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space3"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space4"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space5"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space6"));
        resp = this.launcher.service("GET", path + "6", "", null, null, envctx);
        LegacySpaceRestServiceTest.assertEquals((int)200, (int)resp.getStatus());
        LegacySpaceRestServiceTest.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space1"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space2"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space3"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space4"));
        LegacySpaceRestServiceTest.assertFalse((boolean)resp.getEntity().toString().contains("space5"));
        LegacySpaceRestServiceTest.assertTrue((boolean)resp.getEntity().toString().contains("space6"));
        this.getContainer().unregisterComponent((Object)"SpaceService");
    }
}

