/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.component.test.KernelBootstrap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.service-dependencies-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.service-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.service-configuration.xml")})
public abstract class AbstractServiceTest
extends BaseExoTestCase {
    protected static Log log = ExoLogger.getLogger((String)AbstractServiceTest.class.getName());
    protected ProviderBinder providerBinder;
    protected ResourceBinder resourceBinder;
    protected RequestHandlerImpl requestHandler;
    public static KernelBootstrap socialBootstrap = null;

    protected void setUp() throws Exception {
        this.resourceBinder = (ResourceBinder)this.getContainer().getComponentInstanceOfType(ResourceBinder.class);
        this.requestHandler = (RequestHandlerImpl)this.getContainer().getComponentInstanceOfType(RequestHandlerImpl.class);
        ProviderBinder.setInstance((ProviderBinder)new ProviderBinder());
        this.providerBinder = ProviderBinder.getInstance();
        ApplicationContextImpl.setCurrent((ApplicationContext)new ApplicationContextImpl(null, null, this.providerBinder));
        this.resourceBinder.clear();
        this.configures();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.begin();
        this.deleteAllRelationships();
        this.deleteAllSpaces();
        this.deleteAllIdentitiesWithActivities();
    }

    private void configures() {
        UserACL acl = (UserACL)this.getContainer().getComponentInstanceOfType(UserACL.class);
        acl.setAdminMSType("manager");
    }

    protected void tearDown() throws Exception {
        this.restartTransaction();
        this.endSession();
        this.end();
    }

    public boolean registry(Object resource) throws Exception {
        return this.resourceBinder.bind(resource);
    }

    public boolean registry(Class<?> resourceClass) throws Exception {
        return this.resourceBinder.bind(resourceClass);
    }

    @Deprecated
    public boolean unregistry(Object resource) {
        return this.resourceBinder.unbind(resource.getClass());
    }

    @Deprecated
    public boolean unregistry(Class<?> resourceClass) {
        return this.resourceBinder.unbind(resourceClass);
    }

    public void addResource(Class<?> resourceClass, MultivaluedMap<String, String> properties) {
        this.resourceBinder.addResource(resourceClass, properties);
    }

    public void addResource(Object resource, MultivaluedMap<String, String> properties) {
        this.resourceBinder.addResource(resource, properties);
    }

    public void removeResource(Class clazz) {
        this.resourceBinder.removeResource(clazz);
    }

    protected void startSessionAs(String user) {
        this.startSessionAs(user, new HashSet<MembershipEntry>());
    }

    protected void startSessionAs(String user, boolean isAdmin) {
        if (isAdmin) {
            this.startSessionAs(user, new HashSet<MembershipEntry>(Arrays.asList(new MembershipEntry("/platform/administrators", "*"))));
        } else {
            this.startSessionAs(user, new HashSet<MembershipEntry>());
        }
    }

    protected void startSessionAs(String user, Collection<MembershipEntry> memberships) {
        Identity identity = new Identity(user, memberships);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }

    protected void endSession() {
        ConversationState.setCurrent(null);
    }

    protected void deleteAllIdentitiesWithActivities() throws Exception {
        IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        ActivityManager activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        ListAccess organizationIdentities = identityManager.getIdentitiesByProfileFilter("organization", new ProfileFilter(), true);
        Arrays.stream((org.exoplatform.social.core.identity.model.Identity[])organizationIdentities.load(0, organizationIdentities.getSize())).forEach(identity -> {
            RealtimeListAccess identityActivities = activityManager.getActivitiesWithListAccess(identity);
            Arrays.stream((ExoSocialActivity[])identityActivities.load(0, identityActivities.getSize())).forEach(activity -> activityManager.deleteActivity(activity));
            identityManager.deleteIdentity(identity);
        });
        ListAccess spaceIdentities = identityManager.getIdentitiesByProfileFilter("space", new ProfileFilter(), true);
        Arrays.stream((org.exoplatform.social.core.identity.model.Identity[])spaceIdentities.load(0, spaceIdentities.getSize())).forEach(identity -> {
            RealtimeListAccess identityActivities = activityManager.getActivitiesOfSpaceWithListAccess(identity);
            Arrays.stream((ExoSocialActivity[])identityActivities.load(0, identityActivities.getSize())).forEach(activity -> activityManager.deleteActivity(activity));
            identityManager.deleteIdentity(identity);
        });
    }

    protected void deleteAllSpaces() throws Exception {
        SpaceService spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        ListAccess spaces = spaceService.getAllSpacesWithListAccess();
        Arrays.stream((Space[])spaces.load(0, spaces.getSize())).forEach(space -> spaceService.deleteSpace(space));
    }

    protected void deleteAllRelationships() throws Exception {
        RelationshipManager relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        ListAccess identities = identityManager.getIdentitiesByProfileFilter("organization", new ProfileFilter(), true);
        for (org.exoplatform.social.core.identity.model.Identity identity : (org.exoplatform.social.core.identity.model.Identity[])identities.load(0, identities.getSize())) {
            ListAccess relationships = relationshipManager.getAllWithListAccess(identity);
            Arrays.stream((org.exoplatform.social.core.identity.model.Identity[])relationships.load(0, relationships.getSize())).forEach(relationship -> relationshipManager.deny(identity, relationship));
        }
    }
}

