/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.malwareDetection.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.service.malwareDetection.MalwareDetectionService;

@Path(value="/malware/detection")
@Api(tags={"/malware"}, value="/malware", description="Malware detection")
public class MalwareDetectionRestService
implements ResourceContainer {
    private static final String MALWARE_DETECTION_PASSPHRASE_PROPERTY = "exo.malwareDetection.passphrase";
    private MalwareDetectionService malwareDetectionService;
    private String malwareDetectionPassphrase;

    public MalwareDetectionRestService(MalwareDetectionService malwareDetectionService) {
        this.malwareDetectionService = malwareDetectionService;
        this.malwareDetectionPassphrase = System.getProperty(MALWARE_DETECTION_PASSPHRASE_PROPERTY);
    }

    @POST
    @Produces(value={"application/json"})
    @ApiOperation(value="Process infected items", httpMethod="POST", response=Response.class, notes="This processes infected items")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized to process infected items")})
    public Response processInfectedItems(List<String> infectedItemsPaths, @QueryParam(value="token") String token) throws Exception {
        if (token == null || this.malwareDetectionPassphrase == null || !this.malwareDetectionPassphrase.equals(token)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        for (String infectedItemPath : infectedItemsPaths) {
            this.malwareDetectionService.processInfectedItem(infectedItemPath);
        }
        return Response.ok().entity((Object)("{\"result\":\"" + infectedItemsPaths + "\"}")).build();
    }
}

