/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.processor;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.processor.EmbedProcessor;
import org.exoplatform.social.service.rest.LinkShare;

public class EmbedProcessorTest
extends AbstractCoreTest {
    private EmbedProcessor processor;

    public void setUp() throws Exception {
        super.setUp();
        this.processor = (EmbedProcessor)PortalContainer.getInstance().getComponentInstanceOfType(EmbedProcessor.class);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testProcessActivityWith0embedTagAndVideoLink() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        StringBuilder testTitle = new StringBuilder();
        testTitle.append("<p>test</p><oembed><a href=").append("https://youtu.be/jx1nBuBdtWo").append("target=").append("_blank").append(">https://youtu.be/jx1nBuBdtWo</a></oembed>");
        String embedMedia = LinkShare.getInstance((String)"https://youtu.be/jx1nBuBdtWo").getMediaObject().getHtml();
        String body = "test test test";
        activity.setTitle(testTitle.toString());
        activity.setBody(body);
        this.processor.processActivity((ExoSocialActivity)activity);
        EmbedProcessorTest.assertEquals((String)activity.getTitle(), (String)(testTitle + embedMedia + "<p></p>"));
    }

    public void testProcessActivityWithOutOembedTag() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String title = "<p>test Title</p>";
        String body = "test test test";
        activity.setTitle(title);
        activity.setBody(body);
        this.processor.processActivity((ExoSocialActivity)activity);
        EmbedProcessorTest.assertEquals((String)activity.getTitle(), (String)title);
    }

    public void testProcessActivityWith0embedTagAndArticleLink() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        StringBuilder testTitle = new StringBuilder();
        testTitle.append("<p>test</p><oembed><a href=").append("https://www.exoplatform.com/").append("target=").append("_blank").append(">https://www.exoplatform.com/</a></oembed>");
        String image = (String)LinkShare.getInstance((String)"https://www.exoplatform.com/").getImages().get(0);
        String description = LinkShare.getInstance((String)"https://www.exoplatform.com/").getDescription();
        String title = LinkShare.getInstance((String)"https://www.exoplatform.com/").getTitle();
        String body = "test test test";
        activity.setTitle(testTitle.toString());
        activity.setBody(body);
        this.processor.processActivity((ExoSocialActivity)activity);
        EmbedProcessorTest.assertEquals((String)((String)activity.getTemplateParams().get("image")), (String)image);
        EmbedProcessorTest.assertEquals((String)((String)activity.getTemplateParams().get("description")), (String)description);
        EmbedProcessorTest.assertEquals((String)((String)activity.getTemplateParams().get("title")), (String)title);
    }
}

