/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.test.AbstractServiceTest;
import org.exoplatform.social.service.test.SocialMockHttpServletRequest;

public class UtilTest
extends AbstractServiceTest {
    public void testGetMediaType() {
        try {
            Util.getMediaType((String)"xml", (String[])new String[]{"json"});
            UtilTest.fail((String)"Expecting WebApplicationException: 415 status");
        }
        catch (WebApplicationException wae) {
            UtilTest.assertEquals((int)415, (int)wae.getResponse().getStatus());
        }
        MediaType jsonMediaType = Util.getMediaType((String)"json", (String[])new String[]{"json"});
        UtilTest.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)jsonMediaType);
        MediaType xmlMediaType = Util.getMediaType((String)"xml", (String[])new String[]{"json", "xml", "atom", "rss"});
        UtilTest.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)xmlMediaType);
        try {
            Util.getMediaType((String)"rss", (String[])new String[]{"json", "xml", "rss"});
            UtilTest.fail((String)"Expecting WebApplicationException: 406 status");
        }
        catch (WebApplicationException wae) {
            UtilTest.assertEquals((int)406, (int)wae.getResponse().getStatus());
        }
    }

    public void testGetIdentityManager() {
        IdentityManager identityManager = Util.getIdentityManager();
        UtilTest.assertNotNull((String)"identityManager must not be null", (Object)identityManager);
    }

    public void testGetIdentityManagerByPortalContainerName() {
        IdentityManager identityManager = Util.getIdentityManager((String)"portal");
        UtilTest.assertNotNull((String)"identityManager must not be null", (Object)identityManager);
    }

    public void testGetSpaceService() {
        SpaceService spaceService = Util.getSpaceService();
        UtilTest.assertNotNull((String)"spaceService must not be null", (Object)spaceService);
    }

    public void testGetSpaceServiceByPortalContainerName() {
        SpaceService spaceService = Util.getSpaceService((String)"portal");
        UtilTest.assertNotNull((String)"spaceService must not be null", (Object)spaceService);
    }

    public void testGetActivityManager() {
        ActivityManager activityManager = Util.getActivityManager();
        UtilTest.assertNotNull((String)"activityManager must not be null", (Object)activityManager);
    }

    public void testGetActivityManagerByPortalContainerName() {
        ActivityManager activityManager = Util.getActivityManager((String)"portal");
        UtilTest.assertNotNull((String)"activityManager must not be null", (Object)activityManager);
    }

    public void testGetRelationshipManager() {
        RelationshipManager relationshipManager = Util.getRelationshipManager();
        UtilTest.assertNotNull((String)"relationshipManager must not be null", (Object)relationshipManager);
    }

    public void testGetRelationshipManagerByPortalContainerName() {
        RelationshipManager relationshipManager = Util.getRelationshipManager((String)"portal");
        UtilTest.assertNotNull((String)"relationshipManager must not be null", (Object)relationshipManager);
    }

    public void testGetPortalContainerByName() {
        PortalContainer portalContainer1 = Util.getPortalContainerByName((String)"wrong");
        UtilTest.assertNull((String)"portalContainer1 must be null", (Object)portalContainer1);
        PortalContainer portalContainer2 = Util.getPortalContainerByName((String)"portal");
        UtilTest.assertNotNull((String)"portalContainer2 must not be null", (Object)portalContainer2);
    }

    public void testConvertTimestampToTimeString() {
        long timestamp = 1308643759381L;
        if ("GTM +07:00".equals(TimeZone.getDefault().getID())) {
            String expected = "Tue Jun 21 15:09:19 +0700 2011";
            UtilTest.assertEquals((String)expected, (String)Util.convertTimestampToTimeString((long)timestamp));
        }
    }

    public void testGetBaseUrl() {
        String baseUrl1 = "http://localhost:8080";
        String urlRequest1 = baseUrl1 + "/social/rest/v1/identity/123456.json?fields=fullName,avatarUrl";
        this.setFakeCurrentEnvironmentContext(urlRequest1);
        String gotBaseUrl1 = Util.getBaseUrl();
        UtilTest.assertEquals((String)("gotBaseUrl1 must be: " + baseUrl1), (String)baseUrl1, (String)gotBaseUrl1);
        String urlRequest2 = baseUrl1 + "/social/rest/v1/identity/123456.json#id?fields=fullName,avatarUrl&limit=20";
        this.setFakeCurrentEnvironmentContext(urlRequest2);
        String gotBaseUrl2 = Util.getBaseUrl();
        UtilTest.assertEquals((String)("gotBaseUrl2 must be: " + baseUrl1), (String)baseUrl1, (String)gotBaseUrl2);
        String baseUrl2 = "http://www.social.demo.exoplatform.org:8000";
        String urlRequest3 = baseUrl2 + "/social/rest/v1/identity/123456.json?fields=fullName,avatarUrl";
        this.setFakeCurrentEnvironmentContext(urlRequest3);
        String gotBaseUrl3 = Util.getBaseUrl();
        UtilTest.assertEquals((String)("gotBaseUrl3 must be: " + baseUrl2), (String)baseUrl2, (String)gotBaseUrl3);
        String urlRequest4 = baseUrl2 + "/social/rest/v1/identity/123456.json#id?fields=fullName,avatarUrl&limit=20";
        this.setFakeCurrentEnvironmentContext(urlRequest4);
        String gotBaseUrl4 = Util.getBaseUrl();
        UtilTest.assertEquals((String)("gotBaseUrl4 must be: " + baseUrl2), (String)baseUrl2, (String)gotBaseUrl4);
        String baseUrl3 = "http://social.demo.exoplatform.org:80";
        String urlRequest5 = baseUrl3 + "/social/rest/v1/identity/123456#id?fields=fullName,avatarUrl&limit=20";
        this.setFakeCurrentEnvironmentContext(urlRequest5);
        String gotBaseUrl5 = Util.getBaseUrl();
        UtilTest.assertEquals((String)("gotBaseUrl5 must return: " + baseUrl3), (String)baseUrl3, (String)gotBaseUrl5);
    }

    private void setFakeCurrentEnvironmentContext(String urlRequest) {
        EnvironmentContext envctx = new EnvironmentContext();
        SocialMockHttpServletRequest httpRequest = new SocialMockHttpServletRequest(urlRequest, null, 0, "GET", null, null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        EnvironmentContext.setCurrent((EnvironmentContext)envctx);
    }
}

