/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.suggest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserACLMetaData;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.suggest.PeopleRestServices;
import org.exoplatform.social.service.rest.BaseRestServicesTestCase;
import org.json.JSONObject;

public class TestPeopleRestServices
extends BaseRestServicesTestCase {
    @Override
    protected Class<?> getComponentClass() {
        return PeopleRestServices.class;
    }

    public void testSuggestions() throws Exception {
        String path = "/homepage/intranet/people/contacts/suggestions";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        TestPeopleRestServices.assertEquals((int)500, (int)resp.getStatus());
        Identity idRoot = new Identity("organization", "root");
        idRoot.setId("root");
        Identity idFoo = new Identity("organization", "foo");
        idFoo.setId("foo");
        Identity idBar = new Identity("organization", "bar");
        idBar.setId("bar");
        Identity idBaz = new Identity("organization", "baz");
        idBaz.setId("baz");
        Identity idQux = new Identity("organization", "qux");
        idBaz.setId("qux");
        envctx.put(SecurityContext.class, (Object)new BaseRestServicesTestCase.MockSecurityContext(idFoo.getRemoteId()));
        HashMap<String, Object> imResults = new HashMap<String, Object>();
        imResults.put("getOrCreateIdentity", idFoo);
        imResults.put("getLastIdentities", Arrays.asList(idRoot, idFoo));
        IdentityManager im = this.createProxy(IdentityManager.class, imResults);
        this.getContainer().registerComponentInstance((Object)"IdentityManager", (Object)im);
        HashMap<String, Object> rmResults = new HashMap<String, Object>();
        rmResults.put("getConnections", new BaseRestServicesTestCase.MockListAccess<Identity>(new Identity[0]));
        RelationshipManager rm = this.createProxy(RelationshipManager.class, rmResults);
        this.getContainer().registerComponentInstance((Object)"RelationshipManager", (Object)rm);
        UserACLMetaData md = new UserACLMetaData();
        md.setSuperUser(idRoot.getRemoteId());
        UserACL uACL = new UserACL(md);
        this.getContainer().registerComponentInstance((Object)"UserACL", (Object)uACL);
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        TestPeopleRestServices.assertEquals((int)200, (int)resp.getStatus());
        TestPeopleRestServices.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        JSONObject json = new JSONObject(resp.getEntity().toString());
        TestPeopleRestServices.assertTrue((boolean)json.has("items"));
        TestPeopleRestServices.assertTrue((json.getJSONArray("items").length() == 0 ? 1 : 0) != 0);
        imResults.put("getLastIdentities", Arrays.asList(idBar, idFoo));
        rmResults.put("get", new Relationship("x"));
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        TestPeopleRestServices.assertEquals((int)200, (int)resp.getStatus());
        TestPeopleRestServices.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        json = new JSONObject(resp.getEntity().toString());
        TestPeopleRestServices.assertTrue((boolean)json.has("items"));
        TestPeopleRestServices.assertTrue((json.getJSONArray("items").length() == 0 ? 1 : 0) != 0);
        rmResults.put("getConnections", new BaseRestServicesTestCase.MockListAccess<Identity>(new Identity[]{idBar}));
        rmResults.put("getSuggestions", Collections.singletonMap(idRoot, 1));
        rmResults.remove("get");
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        TestPeopleRestServices.assertEquals((int)200, (int)resp.getStatus());
        TestPeopleRestServices.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        json = new JSONObject(resp.getEntity().toString());
        TestPeopleRestServices.assertTrue((boolean)json.has("items"));
        TestPeopleRestServices.assertEquals((int)1, (int)json.getJSONArray("items").length());
        TestPeopleRestServices.assertEquals((String)json.getJSONArray("items").getJSONObject(0).getString("username"), (String)idBar.getRemoteId());
        HashMap<Identity, Integer> suggestions = new HashMap<Identity, Integer>();
        suggestions.put(idRoot, 1);
        suggestions.put(idBar, 2);
        imResults.put("getLastIdentities", Arrays.asList(idRoot, idFoo, idBaz));
        rmResults.put("getConnections", new BaseRestServicesTestCase.MockListAccess<Identity>(new Identity[]{idQux}));
        rmResults.put("getSuggestions", suggestions);
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        TestPeopleRestServices.assertEquals((int)200, (int)resp.getStatus());
        TestPeopleRestServices.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        json = new JSONObject(resp.getEntity().toString());
        TestPeopleRestServices.assertTrue((boolean)json.has("items"));
        TestPeopleRestServices.assertEquals((int)2, (int)json.getJSONArray("items").length());
        this.getContainer().unregisterComponent((Object)"UserACL");
        this.getContainer().unregisterComponent((Object)"RelationshipManager");
        this.getContainer().unregisterComponent((Object)"IdentityManager");
    }
}

