/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.favorite;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.impl.favorite.FavoriteEntity;

@Path(value="v1/social/favorites")
@Api(tags={"v1/social/favorites"}, value="v1/social/favorites", description="Managing favorites for any type of data")
public class FavoriteRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(FavoriteRest.class);
    private FavoriteService favoriteService;

    public FavoriteRest(FavoriteService favoriteService) {
        this.favoriteService = favoriteService;
    }

    @POST
    @Path(value="{objectType}/{objectId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates a favorite object", httpMethod="POST", response=Response.class, produces="application/json", notes="Returns newly created favorite")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=409, message="Conflict")})
    public Response createFavorite(@ApiParam(value="Object type: activity, comment, notes ...", required=true) @PathParam(value="objectType") String objectType, @ApiParam(value="Object identifier: technical id to identify object as favorite", required=true) @PathParam(value="objectId") String objectId, @ApiParam(value="Object parent identifier: technical id to identify the parent of an object like the activity Id for a comment entity", required=false) @QueryParam(value="parentObjectId") String parentObjectId, @ApiParam(value="Space technical identitifier of the bookmarked object", required=false) @QueryParam(value="spaceId") long spaceId, @ApiParam(value="Whether ignore favorite when already exists or return a HTTP 409 code", required=false, defaultValue="false") @QueryParam(value="ignoreWhenExisting") boolean ignoreWhenExisting) {
        if (StringUtils.isBlank((CharSequence)objectType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FavoriteObjectTypeRequired").build();
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FavoriteObjectIdRequired").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            Favorite favorite = new Favorite(objectType, objectId, parentObjectId, userIdentityId, spaceId);
            this.favoriteService.createFavorite(favorite);
            return Response.noContent().build();
        }
        catch (ObjectAlreadyExistsException e) {
            if (ignoreWhenExisting) {
                return Response.noContent().build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating a favorite", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves all favorites object of the current user", httpMethod="GET", response=Response.class, produces="application/json", notes="Return list of favorites")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getFavoritesList(@ApiParam(value="Query Offset", required=true) @QueryParam(value="offset") int offset, @ApiParam(value="Query results limit", required=true) @QueryParam(value="limit") int limit, @ApiParam(value="Fovorites total size", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            FavoriteEntity favoriteEntity = new FavoriteEntity();
            List myFavorites = this.favoriteService.getFavoriteItemsByCreator(userIdentityId, (long)offset, (long)limit);
            favoriteEntity.setFavoritesItem(myFavorites);
            favoriteEntity.setLimit(limit);
            favoriteEntity.setOffset(offset);
            if (returnSize) {
                favoriteEntity.setSize(this.favoriteService.getFavoriteItemsSize(userIdentityId));
            }
            return Response.ok((Object)favoriteEntity).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting favorites list", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{objectType}/{objectId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a metadata item identified by its id", httpMethod="DELETE", response=Response.class, consumes="application/json", produces="application/json", notes="Returns deleted Metadata item")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized")})
    public Response deleteFavorite(@ApiParam(value="Object type: activity, comment, notes ...", required=true) @PathParam(value="objectType") String objectType, @ApiParam(value="Object identifier: technical id to identify object as favorite", required=true) @PathParam(value="objectId") String objectId, @ApiParam(value="Whether ignore when not existing Metadata item or not.If true, it will return a HTTP code 204 when not existing else a 404.", required=false, defaultValue="false") @QueryParam(value="ignoreNotExisting") boolean ignoreNotExisting) {
        if (StringUtils.isBlank((CharSequence)objectType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FavoriteObjectTypeRequired").build();
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"FavoriteObjectIdRequired").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            Favorite favorite = new Favorite(objectType, objectId, null, userIdentityId, 0L);
            this.favoriteService.deleteFavorite(favorite);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            if (ignoreNotExisting) {
                return Response.noContent().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error deleting a favorite", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

