/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.comment;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1$AjcClosure1;
import org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1$AjcClosure11;
import org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1$AjcClosure3;
import org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1$AjcClosure5;
import org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1$AjcClosure7;
import org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1$AjcClosure9;

@Path(value="v1/social/comments")
@Api(tags={"v1/social/comments"}, value="v1/social/comments", description="Operations on a comment")
@Deprecated
public class CommentRestResourcesV1
implements ResourceContainer {
    private ActivityRestResourcesV1 activityRestResourcesV1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public CommentRestResourcesV1(ActivityRestResourcesV1 activityRestResourcesV1) {
        this.activityRestResourcesV1 = activityRestResourcesV1;
    }

    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific comment by id", httpMethod="GET", response=Response.class, notes="This returns the comment if the authenticated user has permissions to see the related activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @DeprecatedAPI(value="Use ActivityRestResourcesV1.getActivityById insteadk", insist=true)
    public Response getCommentById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        UriInfo uriInfo2 = uriInfo;
        Request request2 = request;
        String string = id;
        String string2 = expand;
        Object[] objectArray = new Object[]{uriInfo2, request2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, request2, string, string2, joinPoint};
        CommentRestResourcesV1$AjcClosure1 commentRestResourcesV1$AjcClosure1 = new CommentRestResourcesV1$AjcClosure1(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(commentRestResourcesV1$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific comment by id", httpMethod="PUT", response=Response.class, notes="This updates the comment in the following cases: <br/><ul><li>the authenticated user is the owner of the comment</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @DeprecatedAPI(value="Use ActivityRestResourcesV1.updateComment instead", insist=true)
    public Response updateCommentById(@Context UriInfo uriInfo, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Comment object to be updated, in which the title of comment is required.", required=true) CommentEntity model) {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        String string2 = expand;
        CommentEntity commentEntity = model;
        Object[] objectArray = new Object[]{uriInfo2, string, string2, commentEntity};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, commentEntity, joinPoint};
        CommentRestResourcesV1$AjcClosure3 commentRestResourcesV1$AjcClosure3 = new CommentRestResourcesV1$AjcClosure3(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(commentRestResourcesV1$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific comment by id", httpMethod="DELETE", response=Response.class, notes="This deletes the comment in the following cases: <br/><ul><li>the authenticated user is the owner of the comment</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @DeprecatedAPI(value="Use ActivityRestResourcesV1.updateComment instead", insist=true)
    public Response deleteCommentById(@Context UriInfo uriInfo, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        String string2 = expand;
        Object[] objectArray = new Object[]{uriInfo2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, joinPoint};
        CommentRestResourcesV1$AjcClosure5 commentRestResourcesV1$AjcClosure5 = new CommentRestResourcesV1$AjcClosure5(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(commentRestResourcesV1$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Path(value="{id}/likes")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets likes of a specific comment", httpMethod="GET", response=Response.class, notes="This returns a list of likes if the authenticated user has permissions to see the comment.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @DeprecatedAPI(value="Use ActivityRestResourcesV1.getLikesOfActivity instead", insist=true)
    public Response getLikesOfComment(@Context UriInfo uriInfo, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        int n = offset;
        int n2 = limit;
        String string2 = expand;
        Object[] objectArray = new Object[]{uriInfo2, string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2, joinPoint};
        CommentRestResourcesV1$AjcClosure7 commentRestResourcesV1$AjcClosure7 = new CommentRestResourcesV1$AjcClosure7(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(commentRestResourcesV1$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @POST
    @Path(value="{id}/likes")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Adds a like to a specific comment", httpMethod="POST", response=Response.class, notes="This adds the like if the authenticated user has permissions to see the comment.")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @DeprecatedAPI(value="Use ActivityRestResourcesV1.addLike instead", insist=true)
    public Response addLikeOnComment(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a subresource if any", required=false) @QueryParam(value="expand") String expand) {
        UriInfo uriInfo2 = uriInfo;
        Request request2 = request;
        String string = id;
        String string2 = expand;
        Object[] objectArray = new Object[]{uriInfo2, request2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, request2, string, string2, joinPoint};
        CommentRestResourcesV1$AjcClosure9 commentRestResourcesV1$AjcClosure9 = new CommentRestResourcesV1$AjcClosure9(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(commentRestResourcesV1$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @DELETE
    @Path(value="{id}/likes/{username}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a like of a specific user for a given comment", httpMethod="DELETE", response=Response.class, notes="This deletes the like if the authenticated user is the given user or the super user.")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @DeprecatedAPI(value="Use ActivityRestResourcesV1.deleteLike instead", insist=true)
    public Response deleteLikeOnComment(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Comment id", required=true) @PathParam(value="id") String id, @ApiParam(value="User name", required=true) @PathParam(value="username") String username, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        UriInfo uriInfo2 = uriInfo;
        Request request2 = request;
        String string = id;
        String string2 = username;
        String string3 = expand;
        Object[] objectArray = new Object[]{uriInfo2, request2, string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, request2, string, string2, string3, joinPoint};
        CommentRestResourcesV1$AjcClosure11 commentRestResourcesV1$AjcClosure11 = new CommentRestResourcesV1$AjcClosure11(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(commentRestResourcesV1$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    static {
        CommentRestResourcesV1.ajc$preClinit();
    }

    static /* synthetic */ Response getCommentById_aroundBody0(CommentRestResourcesV1 ajc$this, UriInfo uriInfo, Request request, String id, String expand, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.getActivityById(uriInfo, request, id, expand);
    }

    static /* synthetic */ Response updateCommentById_aroundBody2(CommentRestResourcesV1 ajc$this, UriInfo uriInfo, String id, String expand, CommentEntity model, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.updateComment(uriInfo, id, expand, model);
    }

    static /* synthetic */ Response deleteCommentById_aroundBody4(CommentRestResourcesV1 ajc$this, UriInfo uriInfo, String id, String expand, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.deleteActivityById(uriInfo, id, false, expand);
    }

    static /* synthetic */ Response getLikesOfComment_aroundBody6(CommentRestResourcesV1 ajc$this, UriInfo uriInfo, String id, int offset, int limit, String expand, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.getLikesOfActivity(uriInfo, id, offset, limit, expand);
    }

    static /* synthetic */ Response addLikeOnComment_aroundBody8(CommentRestResourcesV1 ajc$this, UriInfo uriInfo, Request request, String id, String expand, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.addLike(uriInfo, request, id);
    }

    static /* synthetic */ Response deleteLikeOnComment_aroundBody10(CommentRestResourcesV1 ajc$this, UriInfo uriInfo, Request request, String id, String username, String expand, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.deleteLike(uriInfo, request, id);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CommentRestResourcesV1.java", CommentRestResourcesV1.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCommentById", "org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1", "javax.ws.rs.core.UriInfo:javax.ws.rs.core.Request:java.lang.String:java.lang.String", "uriInfo:request:id:expand", "", "javax.ws.rs.core.Response"), 76);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCommentById", "org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String:org.exoplatform.social.rest.entity.CommentEntity", "uriInfo:id:expand:model", "", "javax.ws.rs.core.Response"), 113);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteCommentById", "org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String", "uriInfo:id:expand", "", "javax.ws.rs.core.Response"), 144);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLikesOfComment", "org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1", "javax.ws.rs.core.UriInfo:java.lang.String:int:int:java.lang.String", "uriInfo:id:offset:limit:expand", "", "javax.ws.rs.core.Response"), 181);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addLikeOnComment", "org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1", "javax.ws.rs.core.UriInfo:javax.ws.rs.core.Request:java.lang.String:java.lang.String", "uriInfo:request:id:expand", "", "javax.ws.rs.core.Response"), 212);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteLikeOnComment", "org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1", "javax.ws.rs.core.UriInfo:javax.ws.rs.core.Request:java.lang.String:java.lang.String:java.lang.String", "uriInfo:request:id:username:expand", "", "javax.ws.rs.core.Response"), 248);
    }
}

