/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.userrelationship;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.UsersRelationshipsRestResources;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;

@Path(value="v1/social/usersRelationships")
@Tag(name="v1/social/usersRelationships", description="Managing relationships of users")
public class UsersRelationshipsRestResourcesV1
implements UsersRelationshipsRestResources {
    private RelationshipManager relationshipManager;

    public UsersRelationshipsRestResourcesV1(RelationshipManager relationshipManager) {
        this.relationshipManager = relationshipManager;
    }

    @Override
    @RolesAllowed(value={"users"})
    @GET
    @Operation(summary="Gets all user relationships", method="GET", description="This returns a list of relationships in the following cases: <br/><ul><li>if the query param \"user\" is not defined: returns the relationships of the authenticated user</li><li>if the \"user\" is defined and the authenticated user is not an administrator: returns the relationships of the authenticated user</li><li>if the \"user\" is defined and the authenticated user is an administrator: returns the relationships of the defined user</li><li>if the \"others\" is defined: returns the relationships between the user and the users defined in \"others\" only</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getUsersRelationships(@Context UriInfo uriInfo, @Parameter(description="Specific status of relationships: pending, confirmed or all") @Schema(defaultValue="all") @QueryParam(value="status") String status, @Parameter(description="User name to get relationships") @QueryParam(value="user") String user, @Parameter(description="Usernames of the others users to get relationships with the given user") @QueryParam(value="others") String others, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of relationships or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource, ex: sender or receiver") @QueryParam(value="expand") String expand) throws Exception {
        List relationships;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Relationship.Type type = StringUtils.isBlank((CharSequence)status) ? Relationship.Type.ALL : Relationship.Type.valueOf((String)status.toUpperCase());
        String username = user;
        if (username == null || !RestUtils.isMemberOfAdminGroup()) {
            username = RestUtils.getCurrentUser();
        }
        Identity givenUser = RestUtils.getUserIdentity(username);
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            String[] othersUsernames = others.split(",");
            relationships = Arrays.stream(othersUsernames).map(other -> RestUtils.getUserIdentity(other)).map(otherIdentity -> this.relationshipManager.get(givenUser, otherIdentity)).filter(Objects::nonNull).filter(relationship -> type.equals((Object)Relationship.Type.ALL) || type.equals((Object)relationship.getStatus())).collect(Collectors.toList());
        } else {
            relationships = this.relationshipManager.getRelationshipsByStatus(givenUser, type, offset, limit);
        }
        int size = returnSize ? this.relationshipManager.getRelationshipsCountByStatus(givenUser, type) : -1;
        List<DataEntity> relationshipEntities = EntityBuilder.buildRelationshipEntities(relationships, uriInfo);
        CollectionEntity collectionRelationship = new CollectionEntity(relationshipEntities, "usersRelationships", offset, limit);
        if (returnSize) {
            collectionRelationship.setSize(size);
        }
        return EntityBuilder.getResponse(collectionRelationship, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a relationship between two specific users", method="POST", description="This creates the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response createUsersRelationships(@Context UriInfo uriInfo, @Parameter(description="Asking for a full representation of a specific subresource, ex: sender or receiver") @QueryParam(value="expand") String expand, @RequestBody(description="Relationship object to be created, required fields: <br/>sender - user name of the sender,<br/>receiver - user name of the receiver,<br/>status - pending or confirmed", required=true) RelationshipEntity model) throws Exception {
        if (model == null || model.getReceiver() == null || model.getSender() == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Relationship.Type status = null;
        if (model.getStatus() != null) {
            try {
                status = Relationship.Type.valueOf((String)model.getStatus().toUpperCase());
            }
            catch (Exception e) {
                throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
            }
        }
        if (Relationship.Type.CONFIRMED.equals(status)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = RestUtils.getCurrentUser();
        if (!model.getSender().equals(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity sender = RestUtils.getCurrentUserIdentity();
        Identity receiver = RestUtils.getUserIdentity(model.getReceiver());
        if (sender == null || receiver == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Relationship existingRelationship = this.relationshipManager.get(sender, receiver);
        if (existingRelationship != null && !Relationship.Type.IGNORED.equals((Object)existingRelationship.getStatus())) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        Relationship relationship = this.saveRelationship(sender, receiver, null, status);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @RolesAllowed(value={"users"})
    @Path(value="{id}")
    @Operation(summary="Gets a specific relationship of user by id", method="GET", description="This returns the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated
    public Response getUsersRelationshipsById(@Context UriInfo uriInfo, @Parameter(description="Relationship id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource, ex: sender or receiver") @QueryParam(value="expand") String expand) throws Exception {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Relationship relationship = this.relationshipManager.get(id);
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String receiver = relationship.getReceiver().getRemoteId();
        String sender = relationship.getSender().getRemoteId();
        return this.getUsersRelationship(uriInfo, sender, receiver, expand);
    }

    @Override
    @PUT
    @RolesAllowed(value={"users"})
    @Path(value="{id}")
    @Operation(summary="Updates a specific relationship of user by id", method="PUT", description="This updates the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated
    public Response updateUsersRelationshipsById(@Context UriInfo uriInfo, @Parameter(description="Relationship id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource, ex: sender or receiver") @QueryParam(value="expand") String expand, @RequestBody(description="Relationship object to be updated", required=true) RelationshipEntity model) throws Exception {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Relationship relationship = this.relationshipManager.get(id);
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        model.setReceiver(relationship.getReceiver().getRemoteId());
        model.setSender(relationship.getSender().getRemoteId());
        return this.updateUsersRelationship(uriInfo, model, expand);
    }

    @Override
    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="{id}")
    @Operation(summary="Deletes a specific relationship of user by id", method="DELETE", description="This deletes the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    @Deprecated
    public Response deleteUsersRelationshipsById(@Context UriInfo uriInfo, @Parameter(description="Relationship id", required=true) @PathParam(value="id") String id, @Parameter(description="Asking for a full representation of a specific subresource if any") @QueryParam(value="expand") String expand) throws Exception {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Relationship relationship = this.relationshipManager.get(id);
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return this.deleteUsersRelationship(uriInfo, relationship.getSender().getRemoteId(), relationship.getReceiver().getRemoteId(), expand);
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="{sender}/{receiver}")
    @Operation(summary="Gets a specific relationship of user with another user", method="GET", description="This returns the relationship in the following cases: <br/><ul><li>the sender or the receiver of the user relationship is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getUsersRelationship(@Context UriInfo uriInfo, @Parameter(description="Relationship id", required=true) @PathParam(value="sender") String sender, @Parameter(description="Relationship id", required=true) @PathParam(value="receiver") String receiver, @Parameter(description="Asking for a full representation of a specific subresource, ex: sender or receiver") @QueryParam(value="expand") String expand) {
        this.checkCurrentUserIsPartOfRelationship(sender, receiver);
        Identity senderIdentity = RestUtils.getUserIdentity(sender);
        Identity receiverIdentity = RestUtils.getUserIdentity(receiver);
        Relationship relationship = this.relationshipManager.get(receiverIdentity, senderIdentity);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific relationship of two users. One of them must be the current user.", method="PUT", description="Return updated relationship")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateUsersRelationship(@Context UriInfo uriInfo, @RequestBody(description="Relationship object to be updated", required=true) RelationshipEntity model, @Parameter(description="Asking for a full representation of a specific subresource, ex: sender or receiver") @QueryParam(value="expand") String expand) {
        if (model == null || StringUtils.isBlank((CharSequence)model.getStatus()) || StringUtils.isBlank((CharSequence)model.getSender()) || StringUtils.isBlank((CharSequence)model.getReceiver())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String currentUser = RestUtils.getCurrentUser();
        String receiver = model.getReceiver();
        String sender = model.getSender();
        this.checkCurrentUserIsPartOfRelationship(sender, receiver);
        Relationship.Type status = Relationship.Type.valueOf((String)model.getStatus().toUpperCase());
        Identity currentUserIdentity = RestUtils.getCurrentUserIdentity();
        String otherUser = StringUtils.equals((CharSequence)sender, (CharSequence)currentUser) ? receiver : sender;
        Identity otherUserIdentity = RestUtils.getUserIdentity(otherUser);
        Relationship relationship = this.relationshipManager.get(currentUserIdentity, otherUserIdentity);
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        receiver = relationship.getReceiver().getRemoteId();
        sender = relationship.getSender().getRemoteId();
        if (StringUtils.equals((CharSequence)sender, (CharSequence)currentUser) && status != Relationship.Type.IGNORED) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (StringUtils.equals((CharSequence)receiver, (CharSequence)currentUser) && status == Relationship.Type.PENDING) {
            status = Relationship.Type.CONFIRMED;
        }
        relationship = this.saveRelationship(currentUserIdentity, otherUserIdentity, relationship, status);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @DELETE
    @Path(value="{sender}/{receiver}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a specific relationship of two users.One of them must be currrent user", method="DELETE", description="Return the deleted relationship")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteUsersRelationship(@Context UriInfo uriInfo, @Parameter(description="Relationship sender", required=true) @PathParam(value="sender") String sender, @Parameter(description="Relationship receiver", required=true) @PathParam(value="receiver") String receiver, @Parameter(description="Asking for a full representation of a specific subresource, ex: sender or receiver") @QueryParam(value="expand") String expand) {
        this.checkCurrentUserIsPartOfRelationship(sender, receiver);
        Identity senderIdentity = RestUtils.getUserIdentity(sender);
        Identity receiverIdentity = RestUtils.getUserIdentity(receiver);
        Relationship relationship = this.relationshipManager.get(receiverIdentity, senderIdentity);
        if (relationship == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.relationshipManager.delete(relationship);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    private Relationship saveRelationship(Identity currentUserIdentity, Identity otherUserIdentity, Relationship existingRelationship, Relationship.Type newStatus) {
        Relationship.Type oldStatus = existingRelationship == null ? null : existingRelationship.getStatus();
        switch (newStatus) {
            case PENDING: {
                if (oldStatus != null && oldStatus != Relationship.Type.IGNORED) break;
                return this.relationshipManager.inviteToConnect(currentUserIdentity, otherUserIdentity);
            }
            case IGNORED: {
                if (existingRelationship != null) {
                    this.relationshipManager.delete(existingRelationship);
                    break;
                }
                this.relationshipManager.ignore(currentUserIdentity, otherUserIdentity);
                break;
            }
            case CONFIRMED: {
                if (existingRelationship == null || oldStatus != Relationship.Type.PENDING || !currentUserIdentity.getRemoteId().equals(existingRelationship.getReceiver().getRemoteId())) break;
                this.relationshipManager.confirm(currentUserIdentity, otherUserIdentity);
            }
        }
        return this.relationshipManager.get(currentUserIdentity, otherUserIdentity);
    }

    private void checkCurrentUserIsPartOfRelationship(String sender, String receiver) {
        String currentUser = RestUtils.getCurrentUser();
        if (!StringUtils.equals((CharSequence)receiver, (CharSequence)currentUser) && !StringUtils.equals((CharSequence)sender, (CharSequence)currentUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }
}

