/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.users;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.search.UserSearchService;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.thumbnail.ImageThumbnailService;
import org.exoplatform.social.mock.MockUploadService;
import org.exoplatform.social.rest.api.ErrorResource;
import org.exoplatform.social.rest.api.UserImportResultEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.ProfilePropertySettingEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.rest.impl.user.UserRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class UserRestResourcesTest
extends AbstractResourceTest {
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private ProfilePropertyService profilePropertyService;
    private UserACL userACL;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;
    private OrganizationService organizationService;
    private EXoContinuationBayeux eXoContinuationBayeux;
    private UserStateService userStateService;
    private MockUploadService uploadService;
    private UserSearchService userSearchService;
    private ImageThumbnailService imageThumbnailService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private List<ProfilePropertySetting> tearDownProfilePropertyList = new ArrayList<ProfilePropertySetting>();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.profilePropertyService = (ProfilePropertyService)this.getContainer().getComponentInstanceOfType(ProfilePropertyService.class);
        this.userACL = (UserACL)this.getContainer().getComponentInstanceOfType(UserACL.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.eXoContinuationBayeux = (EXoContinuationBayeux)Mockito.mock(EXoContinuationBayeux.class);
        this.userStateService = new UserStateService(this.eXoContinuationBayeux, (CacheService)this.getContainer().getComponentInstanceOfType(CacheService.class));
        this.uploadService = (MockUploadService)((Object)this.getContainer().getComponentInstanceOfType(UploadService.class));
        this.organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.userSearchService = (UserSearchService)this.getContainer().getComponentInstanceOfType(UserSearchService.class);
        this.imageThumbnailService = (ImageThumbnailService)this.getContainer().getComponentInstanceOfType(ImageThumbnailService.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityManager.saveIdentity(this.rootIdentity);
        this.identityManager.saveIdentity(this.johnIdentity);
        this.identityManager.saveIdentity(this.maryIdentity);
        this.identityManager.saveIdentity(this.demoIdentity);
        UserRestResourcesV1 userRestResourcesV1 = new UserRestResourcesV1(new ActivityRestResourcesV1(this.activityManager, this.identityManager, this.spaceService, null), this.userACL, this.organizationService, this.identityManager, this.relationshipManager, this.userStateService, this.spaceService, (UploadService)this.uploadService, this.userSearchService, this.imageThumbnailService, this.profilePropertyService);
        this.registry(userRestResourcesV1);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        for (ProfilePropertySetting propertySetting : this.tearDownProfilePropertyList) {
            this.profilePropertyService.deleteProfilePropertySetting(propertySetting.getId());
        }
        this.removeResource(UserRestResourcesV1.class);
    }

    public void testGetAllUsers() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)4, (int)collections.getEntities().size());
    }

    public void testSearchUsers() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users?q=mar&isDisabled=true&limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        this.organizationService.getUserHandler().setEnabled("mary", false, false);
        response = this.service("GET", this.getURLResource("users?q=mar&isDisabled=true&limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.organizationService.getUserHandler().setEnabled("mary", true, false);
        response = this.service("GET", this.getURLResource("users?q=mar&isDisabled=true&limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        this.removeResource(UserRestResourcesV1.class);
        this.identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        ListAccess<Identity> identityListAccess = new ListAccess<Identity>(){

            public Identity[] load(int index, int length) {
                ArrayList<Identity> identities = new ArrayList<Identity>();
                identities.add(UserRestResourcesTest.this.maryIdentity);
                Identity[] result = new Identity[identities.size()];
                return identities.toArray(result);
            }

            public int getSize() {
                return 1;
            }
        };
        Mockito.when((Object)this.identityManager.getIdentitiesByProfileFilter(ArgumentMatchers.anyString(), (ProfileFilter)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)identityListAccess);
        UserRestResourcesV1 userRestResources = new UserRestResourcesV1(new ActivityRestResourcesV1(this.activityManager, this.identityManager, this.spaceService, null), this.userACL, this.organizationService, this.identityManager, this.relationshipManager, this.userStateService, this.spaceService, (UploadService)this.uploadService, this.userSearchService, this.imageThumbnailService, this.profilePropertyService);
        this.registry(userRestResources);
        response = this.service("GET", this.getURLResource("users?q=mar&limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("users?q=mar&isDisabled=false&limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }

    public void testGetDisabledUsers() throws Exception {
        this.startSessionAs("root");
        this.maryIdentity.setEnable(false);
        this.johnIdentity.setEnable(false);
        this.identityManager.saveIdentity(this.maryIdentity);
        this.identityManager.saveIdentity(this.johnIdentity);
        ContainerResponse response = this.service("GET", this.getURLResource("users?limit=5&offset=0&isDisabled=true"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        this.maryIdentity.setEnable(true);
        this.johnIdentity.setEnable(true);
        this.identityManager.saveIdentity(this.maryIdentity);
        this.identityManager.saveIdentity(this.johnIdentity);
        response = this.service("GET", this.getURLResource("users?limit=5&offset=0&isDisabled=true"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
    }

    public void testGetUsersByUserType() throws Exception {
        this.startSessionAs("root");
        Profile profile = this.maryIdentity.getProfile();
        profile.setProperty("external", (Object)"true");
        this.identityManager.saveProfile(profile);
        ContainerResponse response = this.service("GET", this.getURLResource("users?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("users?limit=5&offset=0&userType=internal"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("users?limit=5&offset=0&userType=external"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }

    public void testGetAllUsersWithExtraFields() throws Exception {
        Space spaceTest = this.getSpaceInstance(700, "root");
        spaceTest.getId();
        spaceTest.setMembers(new String[]{"mary", "john", "demo"});
        this.spaceService.updateSpace(spaceTest);
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.maryIdentity);
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.demoIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users?limit=5&offset=0&expand=all,connectionsCount,spacesCount,connectionsInCommonCount,relationshipStatus"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)4, (int)collections.getEntities().size());
        List entities = collections.getEntities();
        for (DataEntity dataEntity : entities) {
            String username = dataEntity.get((Object)"username").toString();
            if (StringUtils.equals((CharSequence)username, (CharSequence)"root")) continue;
            String connectionsCount = dataEntity.get((Object)"connectionsCount").toString();
            String spacesCount = dataEntity.get((Object)"spacesCount").toString();
            String connectionsInCommonCount = dataEntity.get((Object)"connectionsInCommonCount").toString();
            String relationshipStatus = dataEntity.get((Object)"relationshipStatus").toString();
            if (StringUtils.equals((CharSequence)username, (CharSequence)"john")) {
                UserRestResourcesTest.assertEquals((String)"3", (String)connectionsCount);
            } else {
                UserRestResourcesTest.assertEquals((String)"1", (String)connectionsCount);
            }
            UserRestResourcesTest.assertEquals((String)"1", (String)spacesCount);
            if (StringUtils.equals((CharSequence)username, (CharSequence)"john")) {
                UserRestResourcesTest.assertEquals((String)"CONFIRMED", (String)relationshipStatus);
            } else if (StringUtils.equals((CharSequence)username, (CharSequence)"mary")) {
                UserRestResourcesTest.assertEquals((String)"OUTGOING", (String)relationshipStatus);
            } else if (StringUtils.equals((CharSequence)username, (CharSequence)"demo")) {
                UserRestResourcesTest.assertEquals((String)"INCOMING", (String)relationshipStatus);
            }
            if (StringUtils.equals((CharSequence)username, (CharSequence)"john")) {
                UserRestResourcesTest.assertEquals((String)"0", (String)connectionsInCommonCount);
                continue;
            }
            UserRestResourcesTest.assertEquals((String)"1", (String)connectionsInCommonCount);
        }
    }

    public void testGetOnlineUsers() throws Exception {
        this.startSessionAs("root");
        Mockito.when((Object)this.eXoContinuationBayeux.getConnectedUserIds()).thenReturn(new LinkedHashSet<String>(Arrays.asList("john", "mary")));
        ContainerResponse response = this.service("GET", this.getURLResource("users?status=online&limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
    }

    public void testGetOnlineUsersOfSpace() throws Exception {
        this.startSessionAs("root");
        Space spaceTest = this.getSpaceInstance(0, "root");
        String spaceId = spaceTest.getId();
        spaceTest.setMembers(new String[]{"john"});
        this.spaceService.updateSpace(spaceTest);
        Mockito.when((Object)this.eXoContinuationBayeux.isPresent("john")).thenReturn((Object)true);
        Mockito.when((Object)this.eXoContinuationBayeux.isPresent("mary")).thenReturn((Object)true);
        ContainerResponse response = this.service("GET", this.getURLResource("users?status=online&spaceId=" + spaceId), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("users?status=online&spaceId=600"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        ErrorResource errorResource = (ErrorResource)response.getEntity();
        UserRestResourcesTest.assertEquals((String)"space not found", (String)errorResource.getDeveloperMessage());
        UserRestResourcesTest.assertEquals((String)"space 600 does not exist", (String)errorResource.getMessage());
    }

    public void testGetUserById() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/john?expand=settings"), "", null, null);
        String etag = ((List)response.getHttpHeaders().get((Object)"etag")).toString();
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ProfileEntity userEntity = this.getBaseEntity(response.getEntity(), ProfileEntity.class);
        UserRestResourcesTest.assertEquals((String)"john", (String)userEntity.getUsername());
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setPropertyName("firstName");
        this.profilePropertyService.createPropertySetting(profilePropertySetting);
        ContainerResponse response1 = this.service("GET", this.getURLResource("users/john?expand=settings"), "", null, null);
        String etag1 = ((List)response1.getHttpHeaders().get((Object)"etag")).toString();
        UserRestResourcesTest.assertNotNull((Object)response1);
        Assert.assertNotEquals((Object)etag, (Object)etag1);
        ContainerResponse response2 = this.service("GET", this.getURLResource("users/john?expand=settings"), "", null, null);
        String etag2 = ((List)response2.getHttpHeaders().get((Object)"etag")).toString();
        UserRestResourcesTest.assertNotNull((Object)response2);
        UserRestResourcesTest.assertEquals((String)etag1, (String)etag2);
    }

    public void testGetUserProfilePropertiesById() throws Exception {
        this.startSessionAs("root");
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setPropertyName("firstName");
        this.tearDownProfilePropertyList.add(this.profilePropertyService.createPropertySetting(profilePropertySetting));
        profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setPropertyName("lastName");
        this.tearDownProfilePropertyList.add(this.profilePropertyService.createPropertySetting(profilePropertySetting));
        profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setPropertyName("email");
        this.tearDownProfilePropertyList.add(this.profilePropertyService.createPropertySetting(profilePropertySetting));
        ContainerResponse response = this.service("GET", this.getURLResource("users/john?expand=settings"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        DataEntity dataEntity = (DataEntity)response.getEntity();
        ArrayList collections = (ArrayList)dataEntity.get((Object)"properties");
        UserRestResourcesTest.assertEquals((int)3, (int)collections.size());
    }

    public void testGetUserAvatarForAnonymous() throws Exception {
        String user = "john";
        this.uploadUserAvatar(user);
        Identity identity = this.identityManager.getOrCreateIdentity("organization", user);
        String avatarUrl = identity.getProfile().getAvatarUrl().replace("/portal/rest", "");
        ContainerResponse response = this.service("GET", avatarUrl, "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("users/" + user + "/avatar"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("users/default-image/avatar"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetUserAvatarForAuthentiticatedUser() throws Exception {
        String user = "john";
        this.uploadUserAvatar(user);
        this.startSessionAs("mary");
        Identity identity = this.identityManager.getOrCreateIdentity("organization", user);
        String avatarUrl = identity.getProfile().getAvatarUrl().replace("/portal/rest", "");
        ContainerResponse response = this.service("GET", avatarUrl, "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("users/" + user + "/avatar"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("users/default-image/avatar"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetUserAvatarWithDefaultSize() throws Exception {
        String user = "john";
        this.uploadUserAvatar(user, "user.png");
        this.startSessionAs("mary");
        Identity identity = this.identityManager.getOrCreateIdentity("organization", user);
        String avatarUrl = identity.getProfile().getAvatarUrl().replace("/portal/rest", "");
        ContainerResponse response = this.service("GET", avatarUrl, "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        BufferedImage receivedImage = ImageIO.read(new ByteArrayInputStream((byte[])response.getEntity()));
        UserRestResourcesTest.assertEquals((int)45, (int)receivedImage.getWidth());
        UserRestResourcesTest.assertEquals((int)45, (int)receivedImage.getHeight());
    }

    public void testGetUserAvatarWithOriginalSize() throws Exception {
        String user = "john";
        this.uploadUserAvatar(user, "user.png");
        this.startSessionAs("mary");
        Identity identity = this.identityManager.getOrCreateIdentity("organization", user);
        Object avatarUrl = identity.getProfile().getAvatarUrl().replace("/portal/rest", "");
        avatarUrl = (String)avatarUrl + "&size=0x0";
        ContainerResponse response = this.service("GET", (String)avatarUrl, "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        BufferedImage receivedImage = ImageIO.read(new ByteArrayInputStream((byte[])response.getEntity()));
        UserRestResourcesTest.assertEquals((int)512, (int)receivedImage.getWidth());
        UserRestResourcesTest.assertEquals((int)512, (int)receivedImage.getHeight());
    }

    public void testGetUserBannerForAnonymous() throws Exception {
        String user = "john";
        this.uploadUserBanner(user);
        Identity identity = this.identityManager.getOrCreateIdentity("organization", user);
        String bannerUrl = identity.getProfile().getBannerUrl().replace("/portal/rest", "");
        ContainerResponse response = this.service("GET", bannerUrl, "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("users/" + user + "/banner"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("users/default-image/banner"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetUserBannerForAuthentiticatedUser() throws Exception {
        String user = "john";
        this.uploadUserBanner(user);
        this.startSessionAs("mary");
        Identity identity = this.identityManager.getOrCreateIdentity("organization", user);
        String bannerUrl = identity.getProfile().getBannerUrl().replace("/portal/rest", "");
        ContainerResponse response = this.service("GET", bannerUrl, "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("users/" + user + "/banner"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("users/default-image/banner"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetConnectionsOfUser() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ContainerResponse response = this.service("GET", this.getURLResource("users/root/connections?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ProfileEntity userEntity = this.getBaseEntity(collections.getEntities().get(0), ProfileEntity.class);
        UserRestResourcesTest.assertEquals((String)"demo", (String)userEntity.getUsername());
    }

    public void testGetInvitationsOfUser() throws Exception {
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/connections/invitations?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ProfileEntity userEntity = this.getBaseEntity(collections.getEntities().get(0), ProfileEntity.class);
        UserRestResourcesTest.assertEquals((String)"demo", (String)userEntity.getUsername());
    }

    public void testGetPendingOfUser() throws Exception {
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/connections/pending?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ProfileEntity userEntity = this.getBaseEntity(collections.getEntities().get(0), ProfileEntity.class);
        UserRestResourcesTest.assertEquals((String)"demo", (String)userEntity.getUsername());
    }

    public void testGetSpacesOfUser() throws Exception {
        this.getSpaceInstance(0, "root");
        this.getSpaceInstance(1, "john");
        this.getSpaceInstance(2, "demo");
        this.getSpaceInstance(3, "demo");
        this.getSpaceInstance(4, "mary");
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/root/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.startSessionAs("john");
        this.relationshipManager.inviteToConnect(this.johnIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        response = this.service("GET", this.getURLResource("users/john/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.startSessionAs("demo");
        response = this.service("GET", this.getURLResource("users/demo/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        this.startSessionAs("john");
        response = this.service("GET", this.getURLResource("users/demo/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        this.startSessionAs("john");
        response = this.service("GET", this.getURLResource("users/mary/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)403, (int)response.getStatus());
        this.startSessionAs("root");
        response = this.service("GET", this.getURLResource("users/demo/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
    }

    public void testGetCommonSpaces() throws Exception {
        Space spaceTest = this.getSpaceInstance(0, "root");
        Space spaceTest1 = this.getSpaceInstance(1, "demo");
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/root/spaces/john?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        spaceTest.setMembers(new String[]{"john"});
        this.spaceService.updateSpace(spaceTest);
        response = this.service("GET", this.getURLResource("users/root/spaces/john?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.startSessionAs("john");
        response = this.service("GET", this.getURLResource("users/john/spaces/root?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        spaceTest1.setMembers(new String[]{"john", "root"});
        this.spaceService.updateSpace(spaceTest1);
        response = this.service("GET", this.getURLResource("users/john/spaces/root?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        this.startSessionAs("demo");
        response = this.service("GET", this.getURLResource("users/john/spaces/root?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)403, (int)response.getStatus());
    }

    public void testUpdateProfileAttribute() throws Exception {
        this.startSessionAs("root");
        String email = "root@test.com";
        byte[] formData = ("name=email&value=" + email).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", "root");
        UserRestResourcesTest.assertNotNull((Object)identity);
        UserRestResourcesTest.assertEquals((String)email, (String)identity.getProfile().getEmail());
        response = this.service("PATCH", this.getURLResource("users/john/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)"User root shouldn't be able to modify john attributes", (int)401, (int)response.getStatus());
    }

    public void testUpdateProfileAvatar() throws Exception {
        this.startSessionAs("root");
        String uploadId = "testtest";
        byte[] formData = ("name=avatar&value=" + uploadId).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)500, (int)response.getStatus());
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("blank.gif");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "avatar.png", "image/png");
        response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", "root");
        UserRestResourcesTest.assertNotNull((Object)identity);
        UserRestResourcesTest.assertNotNull((Object)identity.getProfile().getAvatarLastUpdated());
        InputStream avatarInputStream = this.identityManager.getAvatarInputStream(identity);
        String storedContent = IOUtil.getStreamContentAsString((InputStream)avatarInputStream);
        String content = IOUtil.getStreamContentAsString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("blank.gif"));
        UserRestResourcesTest.assertEquals((String)content, (String)storedContent);
    }

    public void testUpdateProfileBanner() throws Exception {
        this.startSessionAs("root");
        String uploadId = "testtest";
        byte[] formData = ("name=banner&value=" + uploadId).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)500, (int)response.getStatus());
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("blank.gif");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "banner.png", "image/png");
        response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", "root");
        UserRestResourcesTest.assertNotNull((Object)identity);
        UserRestResourcesTest.assertNotNull((Object)identity.getProfile().getBannerLastUpdated());
        InputStream bannerInputStream = this.identityManager.getBannerInputStream(identity);
        String storedContent = IOUtil.getStreamContentAsString((InputStream)bannerInputStream);
        String content = IOUtil.getStreamContentAsString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("blank.gif"));
        UserRestResourcesTest.assertEquals((String)content, (String)storedContent);
        byte[] formDataDefaultBanner = "name=banner&value=DEFAULT_BANNER".getBytes();
        ContainerResponse responseDefaultBanner = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formDataDefaultBanner);
        identity = this.identityManager.getOrCreateIdentity("organization", "root");
        UserRestResourcesTest.assertNull((Object)identity.getProfile().getProperty("banner"));
        UserRestResourcesTest.assertNotNull((Object)responseDefaultBanner);
        UserRestResourcesTest.assertEquals((String)String.valueOf(responseDefaultBanner.getEntity()), (int)204, (int)responseDefaultBanner.getStatus());
    }

    public void testImportUsers() throws Exception {
        this.startSessionAs("root");
        String uploadId = "users-empty.csv";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ContainerResponse response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-empty.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-empty.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        uploadId = "users.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        uploadId = "users-update.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-update.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-update.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        uploadId = "users-enabled.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-enabled.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-enabled.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        uploadId = "users.csv";
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&progress=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        UserImportResultEntity importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)4L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertEquals((long)importResultEntity.getCount(), (long)importResultEntity.getProcessedCount());
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        BufferedReader reader = new BufferedReader(new FileReader(uploadResource.getStoreLocation()));
        reader.readLine();
        String User2 = reader.readLine();
        ArrayList<String> userNames = new ArrayList<String>();
        ArrayList<String> passWords = new ArrayList<String>();
        while (User2 != null) {
            List<String> userProperties = Arrays.asList(User2.split(","));
            userNames.add(userProperties.get(0));
            passWords.add(userProperties.get(3));
            User2 = reader.readLine();
        }
        UserRestResourcesTest.assertNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getWarnMessages());
        uploadId = "users-update.csv";
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&progress=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)4L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertEquals((long)importResultEntity.getCount(), (long)importResultEntity.getProcessedCount());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getWarnMessages());
        for (int i = 0; i < userNames.size(); ++i) {
            String userEnabled = this.organizationService.getUserHandler().findUserByName((String)userNames.get(i), UserStatus.ANY).getUserName();
            boolean result = this.organizationService.getUserHandler().authenticate(userEnabled, (String)passWords.get(i));
            UserRestResourcesTest.assertTrue((boolean)result);
        }
        uploadId = "users-enabled.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-enabled.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-enabled.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&progress=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)2L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertEquals((long)importResultEntity.getCount(), (long)importResultEntity.getProcessedCount());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getWarnMessages());
        String userEnabled = this.organizationService.getUserHandler().findUserByName("usera", UserStatus.ANY).getUserName();
        boolean result = this.organizationService.getUserHandler().authenticate(userEnabled, "successuser11");
        UserRestResourcesTest.assertTrue((boolean)result);
        String userDisabled = this.organizationService.getUserHandler().findUserByName("userb", UserStatus.DISABLED).getUserName();
        try {
            this.organizationService.getUserHandler().authenticate(userDisabled, "successuser22");
            UserRestResourcesTest.fail((String)"disabled user");
        }
        catch (Exception exception) {
            // empty catch block
        }
        uploadId = "users-update-status.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-update-status.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-update-status.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        uploadId = "users-update-status.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-update-status.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-update-status.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&progress=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)2L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertEquals((long)importResultEntity.getCount(), (long)importResultEntity.getProcessedCount());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getWarnMessages());
        boolean userStatusUpdated1 = this.organizationService.getUserHandler().findUserByName("usera", UserStatus.DISABLED).isEnabled();
        boolean userStatusUpdated2 = this.organizationService.getUserHandler().findUserByName("userb", UserStatus.ENABLED).isEnabled();
        UserRestResourcesTest.assertFalse((boolean)userStatusUpdated1);
        UserRestResourcesTest.assertTrue((boolean)userStatusUpdated2);
        this.organizationService.getUserHandler().setEnabled("usera", true, true);
        uploadId = "users.csv";
        uploadResource = this.uploadService.getUploadResource(uploadId);
        UserRestResourcesTest.assertNotNull((Object)uploadResource);
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&clean=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)4L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getWarnMessages());
        uploadResource = this.uploadService.getUploadResource(uploadId);
        UserRestResourcesTest.assertNull((Object)uploadResource);
        uploadId = "users-errors.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-errors.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-errors.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&progress=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)6L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertEquals((long)importResultEntity.getCount(), (long)importResultEntity.getProcessedCount());
        UserRestResourcesTest.assertNotNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertEquals((int)2, (int)importResultEntity.getErrorMessages().size());
        UserRestResourcesTest.assertNotNull((Object)importResultEntity.getWarnMessages());
        UserRestResourcesTest.assertEquals((int)1, (int)importResultEntity.getWarnMessages().size());
    }

    public void testUpdateProfileAtributes() throws Exception {
        String firstName = "Johnny";
        String lastName = "Bravo";
        String fullName = "Johnny Bravo";
        String aboutMe = "AboutMe";
        String imType = "Skype";
        String imId = "johnnyB";
        String phoneType = "work";
        String phoneNumber = "123456";
        String url = "fakeURL";
        String email = "johnny@localhost.com";
        StringBuilder input = new StringBuilder("{");
        input.append("\"");
        input.append("firstname");
        input.append("\":\"");
        input.append(firstName);
        input.append("\",");
        input.append("\"");
        input.append("lastname");
        input.append("\":\"");
        input.append(lastName);
        input.append("\",");
        input.append("\"");
        input.append("fullname");
        input.append("\":\"");
        input.append(fullName);
        input.append("\",");
        input.append("\"");
        input.append("email");
        input.append("\":\"");
        input.append(email);
        input.append("\",");
        input.append("\"");
        input.append("aboutMe");
        input.append("\":\"");
        input.append(aboutMe);
        input.append("\",");
        input.append("\"");
        input.append("phones");
        input.append("\": [{\"phoneType\":\"");
        input.append(phoneType);
        input.append("\",\"phoneNumber\":\"");
        input.append(phoneNumber);
        input.append("\"}],");
        input.append("\"");
        input.append("ims");
        input.append("\": [{\"imType\":\"");
        input.append(imType);
        input.append("\", \"imId\":\"");
        input.append(imId);
        input.append("\"}],");
        input.append("\"");
        input.append("urls");
        input.append("\":[{\"url\":\"");
        input.append(url);
        input.append("\"}]");
        input.append("}");
        this.startSessionAs("john");
        ContainerResponse response = this.getResponse("PATCH", this.getURLResource("users/john/profile"), input.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", "john");
        UserRestResourcesTest.assertNotNull((Object)identity);
        UserRestResourcesTest.assertEquals((Object)firstName, (Object)identity.getProfile().getProperty("firstName"));
        UserRestResourcesTest.assertEquals((Object)lastName, (Object)identity.getProfile().getProperty("lastName"));
        UserRestResourcesTest.assertEquals((Object)fullName, (Object)identity.getProfile().getProperty("fullName"));
        List phones = identity.getProfile().getPhones();
        UserRestResourcesTest.assertNotNull((Object)phones);
        UserRestResourcesTest.assertEquals((int)1, (int)phones.size());
        UserRestResourcesTest.assertNotNull((String)phoneType, ((Map)phones.get(0)).get("key"));
        UserRestResourcesTest.assertNotNull((String)phoneNumber, ((Map)phones.get(0)).get("value"));
        List ims = (List)identity.getProfile().getProperty("ims");
        UserRestResourcesTest.assertNotNull((Object)ims);
        UserRestResourcesTest.assertEquals((int)1, (int)ims.size());
        UserRestResourcesTest.assertNotNull((String)imType, ((Map)ims.get(0)).get("key"));
        UserRestResourcesTest.assertNotNull((String)imId, ((Map)ims.get(0)).get("value"));
        List urls = (List)identity.getProfile().getProperty("urls");
        UserRestResourcesTest.assertNotNull((Object)urls);
        UserRestResourcesTest.assertEquals((int)1, (int)urls.size());
        UserRestResourcesTest.assertNotNull((String)url, ((Map)urls.get(0)).get("value"));
    }

    public void testUpdateUserFieldsWithValidators() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        String johnEmail = "john@platform.com";
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setPropertyName("email");
        this.tearDownProfilePropertyList.add(this.profilePropertyService.createPropertySetting(profilePropertySetting));
        this.startSessionAs("john");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/john"), "", (MultivaluedMap<String, String>)headers, ("name=email&value=" + johnEmail).getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        String user = "demo";
        this.startSessionAs(user);
        response = this.service("PATCH", this.getURLResource("users/john"), "", (MultivaluedMap<String, String>)headers, "name=firstname&value=t".getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("demo shouldn't be allowed to update john fields. Response content: " + response.getEntity()), (int)401, (int)response.getStatus());
        response = this.service("PATCH", this.getURLResource("users/" + user), "", (MultivaluedMap<String, String>)headers, "name=email&value=WRONG_FROMAT".getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("Email format validation should return HTTP 400 code. Response content: " + response.getEntity()), (int)400, (int)response.getStatus());
        response = this.service("PATCH", this.getURLResource("users/" + user), "", (MultivaluedMap<String, String>)headers, ("name=email&value=" + johnEmail).getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("Email already exists return HTTP 401 code. Response content: " + response.getEntity()), (int)401, (int)response.getStatus());
        response = this.service("PATCH", this.getURLResource("users/" + user), "", (MultivaluedMap<String, String>)headers, "name=firstname&value=D".getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("FIRST name format validation should return HTTP 400 code. Response content: " + response.getEntity()), (int)400, (int)response.getStatus());
        response = this.service("PATCH", this.getURLResource("users/" + user), "", (MultivaluedMap<String, String>)headers, "name=lastname&value=T".getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("LAST name format validation should return HTTP 400 code. Response content: " + response.getEntity()), (int)400, (int)response.getStatus());
    }

    public void testUpdateUserFieldWithValidators() throws Exception {
        String johnEmail = "john@platform.com";
        this.startSessionAs("john");
        JSONObject johnData = new JSONObject();
        johnData.put("email", (Object)johnEmail);
        ContainerResponse response = this.getResponse("PATCH", "/v1/social/users/john/profile", johnData.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        JSONObject data = new JSONObject();
        data.put("username", (Object)"demo");
        data.put("firstname", (Object)"Demo");
        data.put("lastname", (Object)"Test");
        data.put("email", (Object)"demo@test.com");
        String user = "demo";
        this.startSessionAs(user);
        response = this.getResponse("PATCH", "/v1/social/users/john/profile", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("demo shouldn't be allowed to update john fields. Response content: " + response.getEntity()), (int)401, (int)response.getStatus());
        data.put("username", (Object)user);
        data.put("email", (Object)"WRONG_FORMAT");
        response = this.getResponse("PATCH", "/v1/social/users/" + user + "/profile", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("Email format validation should return HTTP 400 code. Response content: " + response.getEntity()), (int)400, (int)response.getStatus());
        this.startSessionAs(user);
        data.put("email", (Object)johnEmail);
        response = this.getResponse("PATCH", "/v1/social/users/" + user + "/profile", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("Email already exists return HTTP 401 code. Response content: " + response.getEntity()), (int)401, (int)response.getStatus());
        data.put("email", (Object)"demo@test.com");
        data.put("firstname", (Object)"d");
        response = this.getResponse("PATCH", "/v1/social/users/" + user + "/profile", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("FIRST name format validation should return HTTP 400 code. Response content: " + response.getEntity()), (int)400, (int)response.getStatus());
        data.put("firstname", (Object)"Demo");
        data.put("lastname", (Object)"t");
        response = this.getResponse("PATCH", "/v1/social/users/" + user + "/profile", data.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)("LAST name format validation should return HTTP 400 code. Response content: " + response.getEntity()), (int)400, (int)response.getStatus());
        data.put("lastname", (Object)"Test");
    }

    public void testUpdateUserNewMultiProperties() throws Exception {
        this.startSessionAs("root");
        ProfilePropertySettingEntity profilePropertySettingEntity = new ProfilePropertySettingEntity();
        profilePropertySettingEntity.setPropertyName("new ArrayField");
        profilePropertySettingEntity.setMultiValued(false);
        ProfilePropertySettingEntity profilePropertySettingEntityChild = new ProfilePropertySettingEntity();
        profilePropertySettingEntityChild.setPropertyName("subField");
        profilePropertySettingEntityChild.setValue("subfield value");
        profilePropertySettingEntity.setChildren(Collections.singletonList(profilePropertySettingEntityChild));
        ArrayList<ProfilePropertySettingEntity> profilePropertySettingEntityList = new ArrayList<ProfilePropertySettingEntity>();
        profilePropertySettingEntityList.add(profilePropertySettingEntity);
        ContainerResponse response = this.getResponse("PATCH", "/v1/social/users/root/profile/properties", new JSONArray(profilePropertySettingEntityList).toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    private Space getSpaceInstance(int number, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{creator};
        String[] members = new String[]{creator};
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        this.spaceService.createSpace(space, creator);
        return space;
    }

    private void uploadUserBanner(String user) throws Exception {
        this.startSessionAs(user);
        String uploadId = "testtest";
        byte[] formData = ("name=banner&value=" + uploadId).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("blank.gif");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "banner.png", "image/png");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/" + user), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        this.endSession();
    }

    private void uploadUserAvatar(String user) throws Exception {
        this.uploadUserAvatar(user, "blank.gif");
    }

    private void uploadUserAvatar(String user, String resourceName) throws Exception {
        this.startSessionAs(user);
        String uploadId = resourceName;
        byte[] formData = ("name=avatar&value=" + uploadId).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        this.uploadService.createUploadResource(uploadId, resource.getFile(), resourceName, "image/png");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/" + user), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        this.endSession();
    }
}

