/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.comment;

import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.rest.impl.comment.CommentRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class CommentRestResourcesTest
extends AbstractResourceTest {
    private CommentRestResourcesV1 commentRestResourcesV1;
    private IdentityStorage identityStorage;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private SpaceService spaceService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity testSpaceIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        ActivityRestResourcesV1 activityRestResourcesV1 = new ActivityRestResourcesV1(this.activityManager, this.identityManager, this.spaceService, null);
        this.commentRestResourcesV1 = new CommentRestResourcesV1(activityRestResourcesV1);
        this.registry(this.commentRestResourcesV1);
        this.restartTransaction();
        this.begin();
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        super.tearDown();
        this.removeResource(this.commentRestResourcesV1.getClass());
    }

    public void testShouldReturnCommentWhenEntityIsFound() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
        testSpaceActivity.setTitle("activity title");
        testSpaceActivity.setPosterId(this.rootIdentity.getId());
        testSpaceActivity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
        ExoSocialActivityImpl testComment = new ExoSocialActivityImpl();
        testComment.setPosterId(this.rootIdentity.getId());
        testComment.setUserId(this.rootIdentity.getId());
        testComment.setTitle("Test Comment");
        ContainerResponse response = null;
        this.activityManager.saveComment((ExoSocialActivity)testSpaceActivity, (ExoSocialActivity)testComment);
        response = this.service("GET", "/v1/social/comments/" + testComment.getId(), "", null, null);
        CommentRestResourcesTest.assertNotNull((Object)response);
        CommentRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CommentEntity commentEntity = this.getBaseEntity((DataEntity)response.getEntity(), CommentEntity.class);
        CommentRestResourcesTest.assertNotNull((Object)commentEntity);
        CommentRestResourcesTest.assertNotNull((Object)commentEntity.getTitle());
        CommentRestResourcesTest.assertEquals((String)commentEntity.getTitle(), (String)"Test Comment");
        if (space != null) {
            this.spaceService.deleteSpace(space);
        }
    }

    public void testShouldNotReturnCommentWhenEntityIsNotFound() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
        testSpaceActivity.setTitle("activity title");
        testSpaceActivity.setPosterId(this.rootIdentity.getId());
        testSpaceActivity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
        this.activityManager.deleteActivity((ExoSocialActivity)testSpaceActivity);
        ContainerResponse response = null;
        response = this.service("GET", "/v1/social/comments/" + testSpaceActivity.getId(), "", null, null);
        CommentRestResourcesTest.assertNotNull((Object)response);
        CommentRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        if (space != null) {
            this.spaceService.deleteSpace(space);
        }
    }

    public void testShouldReturnNotAuthorizedResponseWhenUserIsNotMemberOfSpace() throws Exception {
        this.startSessionAs("john");
        Space space = this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
        testSpaceActivity.setTitle("activity title");
        testSpaceActivity.setPosterId(this.rootIdentity.getId());
        testSpaceActivity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
        ExoSocialActivityImpl testComment = new ExoSocialActivityImpl();
        testComment.setPosterId(this.rootIdentity.getId());
        testComment.setUserId(this.rootIdentity.getId());
        testComment.setTitle("Test Comment");
        ContainerResponse response = null;
        this.activityManager.saveComment((ExoSocialActivity)testSpaceActivity, (ExoSocialActivity)testComment);
        response = this.service("GET", "/v1/social/comments/" + testComment.getId(), "", null, null);
        CommentRestResourcesTest.assertNotNull((Object)response);
        CommentRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        if (space != null) {
            this.spaceService.deleteSpace(space);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSpaceActivity() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        try {
            ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
            testSpaceActivity.setTitle("Test activity");
            this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
            ExoSocialActivityImpl testComment = new ExoSocialActivityImpl();
            testComment.setTitle("Test Comment");
            testComment.setUserId("root");
            testComment.setPosterId("root");
            ContainerResponse response = null;
            this.activityManager.saveComment((ExoSocialActivity)testSpaceActivity, (ExoSocialActivity)testComment);
            response = this.service("GET", "/v1/social/comments/" + testComment.getId(), "", null, null);
            CommentRestResourcesTest.assertNotNull((Object)response);
            CommentRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            CommentEntity commentEntity = this.getBaseEntity((DataEntity)response.getEntity(), CommentEntity.class);
            CommentRestResourcesTest.assertNotNull((Object)commentEntity);
            CommentRestResourcesTest.assertNotNull((Object)commentEntity.getTitle());
            CommentRestResourcesTest.assertEquals((String)commentEntity.getTitle(), (String)"Test Comment");
            response = this.service("GET", "/v1/social/comments/" + testSpaceActivity.getId(), "", null, null);
            CommentRestResourcesTest.assertNotNull((Object)response);
            CommentRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            this.startSessionAs("John");
            response = this.service("GET", "/v1/social/comments/" + testSpaceActivity.getId(), "", null, null);
            CommentRestResourcesTest.assertNotNull((Object)response);
            CommentRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        }
        catch (Exception exc) {
            log.error((Object)exc);
        }
        finally {
            if (space != null) {
                this.spaceService.deleteSpace(space);
            }
        }
    }

    private Space getSpaceInstance(String prettyName, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName(prettyName);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + prettyName);
        space.setType("classic");
        space.setVisibility("private");
        space.setRegistration("validation");
        space.setPriority("2");
        this.spaceService.createSpace(space, creator);
        return space;
    }
}

