/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.SpaceRest;
import org.exoplatform.social.service.rest.SpacesRestService$AjcClosure1;
import org.exoplatform.social.service.rest.SpacesRestService$AjcClosure3;
import org.exoplatform.social.service.rest.SpacesRestService$AjcClosure5;
import org.exoplatform.social.service.rest.SpacesRestService$AjcClosure7;
import org.exoplatform.social.service.rest.SpacesRestService$AjcClosure9;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.IdentityNameList;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.URIWriter;

@Path(value="{portalName}/social/spaces")
@Deprecated
public class SpacesRestService
implements ResourceContainer {
    private static final Log LOG;
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String PENDING_STATUS = "pending";
    private static final String INCOMING_STATUS = "incoming";
    private static final String ALL_SPACES_STATUS = "all_spaces";
    private String portalContainerName;
    private static final QualifiedName PATH;
    private static final QualifiedName LANG;
    private static final QualifiedName REQUEST_SITE_TYPE;
    private static final QualifiedName REQUEST_HANDLER;
    private static final QualifiedName REQUEST_SITE_NAME;
    private static final String ALL_SPACES = "all-spaces";
    private static final String JSON = "json";
    private Router router;
    private SpaceService spaceService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public SpacesRestService(SpaceService spaceService, WebAppController webAppController) {
        this.spaceService = spaceService;
        this.router = webAppController.getRouter();
    }

    @GET
    @Path(value="mySpaces/show.{format}")
    @DeprecatedAPI(value="The endpoint is deprecated, use spaceRestResourcesV1.getSpaces instead ")
    public Response showMySpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        String string = portalName;
        String string2 = format;
        Object[] objectArray = new Object[]{uriInfo2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, joinPoint};
        SpacesRestService$AjcClosure1 spacesRestService$AjcClosure1 = new SpacesRestService$AjcClosure1(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spacesRestService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="lastVisitedSpace/list.{format}")
    @DeprecatedAPI(value="The endpoint is deprecated, use spaceRestResourcesV1.getSpaces instead ")
    public Response getLastVisitedSpace(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format, @QueryParam(value="appId") String appId, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        String string = portalName;
        String string2 = format;
        String string3 = appId;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{uriInfo2, string, string2, string3, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, string3, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        SpacesRestService$AjcClosure3 spacesRestService$AjcClosure3 = new SpacesRestService$AjcClosure3(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spacesRestService$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @GET
    @Path(value="spaceInfo")
    @DeprecatedAPI(value="The endpoint is deprecated, use spaceRestResourcesV1.getSpaces instead ")
    public Response getSpaceInfo(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @QueryParam(value="spaceName") String spaceName) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        String string = portalName;
        String string2 = spaceName;
        Object[] objectArray = new Object[]{uriInfo2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, joinPoint};
        SpacesRestService$AjcClosure5 spacesRestService$AjcClosure5 = new SpacesRestService$AjcClosure5(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spacesRestService$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    private String buildSpaceUrl(String spaceUrl) {
        return "/" + this.portalContainerName + "/g/:spaces:" + spaceUrl + "/" + spaceUrl;
    }

    @GET
    @Path(value="pendingSpaces/show.{format}")
    @DeprecatedAPI(value="The endpoint is deprecated, use spaceRestResourcesV1.getSpaces instead ")
    public Response showPendingSpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        String string = portalName;
        String string2 = format;
        Object[] objectArray = new Object[]{uriInfo2, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, joinPoint};
        SpacesRestService$AjcClosure7 spacesRestService$AjcClosure7 = new SpacesRestService$AjcClosure7(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spacesRestService$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="suggest.{format}")
    @DeprecatedAPI(value="The endpoint is deprecated, use spaceRestResourcesV1.getSpaces instead ")
    public Response suggestSpacenames(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="portalName") String portalName, @QueryParam(value="conditionToSearch") String conditionToSearch, @QueryParam(value="typeOfRelation") String typeOfRelation, @QueryParam(value="currentUser") String userId, @PathParam(value="format") String format) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        HttpServletRequest httpServletRequest = request;
        String string = portalName;
        String string2 = conditionToSearch;
        String string3 = typeOfRelation;
        String string4 = userId;
        String string5 = format;
        Object[] objectArray = new Object[]{uriInfo2, httpServletRequest, string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, httpServletRequest, string, string2, string3, string4, string5, joinPoint};
        SpacesRestService$AjcClosure9 spacesRestService$AjcClosure9 = new SpacesRestService$AjcClosure9(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spacesRestService$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private void addSpaceNames(IdentityNameList nameList, List<Space> spaces) {
        int i = 1;
        for (Space space : spaces) {
            IdentityNameList.Option opt = new IdentityNameList.Option();
            opt.setType("space");
            opt.setInvalid(false);
            opt.setOrder(i++);
            opt.setText(space.getDisplayName());
            opt.setValue(space.getPrettyName());
            opt.setAvatarUrl(space.getAvatarUrl());
            nameList.addOption(opt);
        }
    }

    private SpaceList showMySpaceList(String userId) {
        SpaceList spaceList = new SpaceList();
        List mySpaces = null;
        ArrayList<SpaceRest> mySpacesRest = new ArrayList<SpaceRest>();
        try {
            mySpaces = this.spaceService.getSpaces(userId);
            for (Space space : mySpaces) {
                SpaceRest spaceRest = new SpaceRest(space);
                mySpacesRest.add(spaceRest);
            }
            this.fillSpacesURI(mySpacesRest);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(mySpacesRest);
        return spaceList;
    }

    private SpaceList getLastVisitedSpace(String userId, String appId, int offset, int limit) {
        SpaceList spaceList = new SpaceList();
        List mySpaces = null;
        try {
            mySpaces = this.spaceService.getLastAccessedSpace(userId, appId, offset, limit);
            for (Space space : mySpaces) {
                SpaceRest spaceRest = new SpaceRest(space);
                spaceList.addSpace(spaceRest);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return spaceList;
    }

    private SpaceList showPendingSpaceList(String userId) {
        SpaceList spaceList = new SpaceList();
        ArrayList<SpaceRest> pendingSpacesRest = new ArrayList<SpaceRest>();
        try {
            List pendingSpaces = this.spaceService.getPendingSpaces(userId);
            for (Space space : pendingSpaces) {
                SpaceRest spaceRest = new SpaceRest(space);
                pendingSpacesRest.add(spaceRest);
            }
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(pendingSpacesRest);
        return spaceList;
    }

    private void fillUrlAllSpaces(SpaceList spaceList, String portalOwner) {
        try {
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put(REQUEST_HANDLER, "portal");
            qualifiedName.put(REQUEST_SITE_TYPE, "portal");
            qualifiedName.put(LANG, "");
            StringBuilder urlBuilder = new StringBuilder();
            qualifiedName.put(REQUEST_SITE_NAME, portalOwner);
            qualifiedName.put(PATH, ALL_SPACES);
            this.router.render((Map)qualifiedName, new URIWriter((Appendable)urlBuilder));
            spaceList.setMoreSpacesUrl(urlBuilder.toString());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void fillSpacesURI(List<SpaceRest> mySpaces) {
        if (mySpaces == null || mySpaces.isEmpty()) {
            return;
        }
        try {
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put(REQUEST_HANDLER, "portal");
            qualifiedName.put(REQUEST_SITE_TYPE, "group");
            for (SpaceRest space : mySpaces) {
                StringBuilder urlBuilder = new StringBuilder();
                qualifiedName.put(REQUEST_SITE_NAME, space.getGroupId());
                qualifiedName.put(PATH, space.getUrl());
                this.router.render((Map)qualifiedName, new URIWriter((Appendable)urlBuilder));
                space.setSpaceUrl(urlBuilder.toString());
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    static {
        SpacesRestService.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpacesRestService.class);
        PATH = QualifiedName.create((String)"gtn", (String)"path");
        LANG = QualifiedName.create((String)"gtn", (String)"lang");
        REQUEST_SITE_TYPE = QualifiedName.create((String)"gtn", (String)"sitetype");
        REQUEST_HANDLER = QualifiedName.create((String)"gtn", (String)"handler");
        REQUEST_SITE_NAME = QualifiedName.create((String)"gtn", (String)"sitename");
    }

    static /* synthetic */ Response showMySpaceList_aroundBody0(SpacesRestService ajc$this, UriInfo uriInfo, String portalName, String format, JoinPoint joinPoint) {
        MediaType mediaType = Util.getMediaType(format);
        ConversationState state = ConversationState.getCurrent();
        ajc$this.portalContainerName = portalName;
        String userId = null;
        if (state != null) {
            userId = state.getIdentity().getUserId();
        }
        SpaceList mySpaceList = ajc$this.showMySpaceList(userId);
        ajc$this.fillUrlAllSpaces(mySpaceList, portalName);
        return Util.getResponse(mySpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    static /* synthetic */ Response getLastVisitedSpace_aroundBody2(SpacesRestService ajc$this, UriInfo uriInfo, String portalName, String format, String appId, int offset, int limit, JoinPoint joinPoint) {
        RestChecker.checkAuthenticatedRequest();
        MediaType mediaType = Util.getMediaType(format, new String[]{format});
        ConversationState state = ConversationState.getCurrent();
        ajc$this.portalContainerName = portalName;
        String userId = null;
        if (state != null) {
            userId = state.getIdentity().getUserId();
        }
        int newLimit = Math.min(limit, 100);
        int newOffset = 0;
        newOffset = offset > 0 ? Math.min(offset, newLimit) : 0;
        String newAppId = null;
        if (appId != null && appId.trim().length() > 0) {
            newAppId = appId;
        }
        SpaceList mySpaceList = ajc$this.getLastVisitedSpace(userId, newAppId, newOffset, newLimit);
        ajc$this.fillSpacesURI(mySpaceList.getSpaces());
        return Util.getResponse(mySpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    static /* synthetic */ Response getSpaceInfo_aroundBody4(SpacesRestService ajc$this, UriInfo uriInfo, String portalName, String spaceName, JoinPoint joinPoint) {
        RestChecker.checkAuthenticatedRequest();
        MediaType mediaType = Util.getMediaType(JSON, new String[]{JSON});
        ajc$this.portalContainerName = portalName;
        Space space = ajc$this.spaceService.getSpaceByPrettyName(spaceName);
        if (space == null && StringUtils.isNotBlank((CharSequence)spaceName)) {
            space = ajc$this.spaceService.getSpaceByGroupId("/spaces/" + spaceName);
        }
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        HashMap<String, String> spaceInfo = new HashMap<String, String>();
        spaceInfo.put("displayName", space.getDisplayName());
        spaceInfo.put("url", ajc$this.buildSpaceUrl(space.getUrl()));
        spaceInfo.put("imageSource", space.getAvatarUrl() != null ? space.getAvatarUrl() : "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png");
        return Util.getResponse(spaceInfo, uriInfo, mediaType, Response.Status.OK);
    }

    static /* synthetic */ Response showPendingSpaceList_aroundBody6(SpacesRestService ajc$this, UriInfo uriInfo, String portalName, String format, JoinPoint joinPoint) {
        MediaType mediaType = Util.getMediaType(format);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        ajc$this.portalContainerName = portalName;
        SpaceList pendingSpaceList = ajc$this.showPendingSpaceList(userId);
        return Util.getResponse(pendingSpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    static /* synthetic */ Response suggestSpacenames_aroundBody8(SpacesRestService ajc$this, UriInfo uriInfo, HttpServletRequest request, String portalName, String conditionToSearch, String typeOfRelation, String userId, String format, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!userId.equals(request.getRemoteUser())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        MediaType mediaType = Util.getMediaType(format);
        ajc$this.portalContainerName = portalName;
        IdentityNameList nameList = new IdentityNameList();
        if (ALL_SPACES_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = ajc$this.spaceService.getAccessibleSpacesByFilter(userId, new SpaceFilter(conditionToSearch));
            List<Space> spaces = Arrays.asList((Space[])listAccess.load(0, 10));
            ajc$this.addSpaceNames(nameList, spaces);
        } else if (PENDING_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = ajc$this.spaceService.getPendingSpacesByFilter(userId, new SpaceFilter(conditionToSearch));
            List<Space> spaces = Arrays.asList((Space[])listAccess.load(0, 10));
            ajc$this.addSpaceNames(nameList, spaces);
        } else if (INCOMING_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = ajc$this.spaceService.getInvitedSpacesByFilter(userId, new SpaceFilter(conditionToSearch));
            List<Space> spaces = Arrays.asList((Space[])listAccess.load(0, 10));
            ajc$this.addSpaceNames(nameList, spaces);
        } else if (CONFIRMED_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = ajc$this.spaceService.getMemberSpacesByFilter(userId, new SpaceFilter(conditionToSearch));
            List<Space> spaces = Arrays.asList((Space[])listAccess.load(0, 10));
            ajc$this.addSpaceNames(nameList, spaces);
        }
        return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpacesRestService.java", SpacesRestService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "showMySpaceList", "org.exoplatform.social.service.rest.SpacesRestService", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String", "uriInfo:portalName:format", "java.lang.Exception", "javax.ws.rs.core.Response"), 154);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastVisitedSpace", "org.exoplatform.social.service.rest.SpacesRestService", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String:java.lang.String:int:int", "uriInfo:portalName:format:appId:offset:limit", "java.lang.Exception", "javax.ws.rs.core.Response"), 205);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceInfo", "org.exoplatform.social.service.rest.SpacesRestService", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String", "uriInfo:portalName:spaceName", "java.lang.Exception", "javax.ws.rs.core.Response"), 257);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "showPendingSpaceList", "org.exoplatform.social.service.rest.SpacesRestService", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String", "uriInfo:portalName:format", "java.lang.Exception", "javax.ws.rs.core.Response"), 310);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "suggestSpacenames", "org.exoplatform.social.service.rest.SpacesRestService", "javax.ws.rs.core.UriInfo:javax.servlet.http.HttpServletRequest:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "uriInfo:request:portalName:conditionToSearch:typeOfRelation:userId:format", "java.lang.Exception", "javax.ws.rs.core.Response"), 346);
    }

    @XmlRootElement
    public static class SpaceList {
        private String moreSpacesUrl;
        private List<SpaceRest> _spaces;

        public void setSpaces(List<SpaceRest> spaces) {
            this._spaces = spaces;
        }

        public List<SpaceRest> getSpaces() {
            return this._spaces;
        }

        public void addSpace(SpaceRest space) {
            if (this._spaces == null) {
                this._spaces = new LinkedList<SpaceRest>();
            }
            this._spaces.add(space);
        }

        public String getMoreSpacesUrl() {
            return this.moreSpacesUrl;
        }

        public void setMoreSpacesUrl(String allSpacesUrl) {
            this.moreSpacesUrl = allSpacesUrl;
        }
    }
}

