/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.site;

import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.rest.entity.SiteEntity;
import org.exoplatform.social.rest.impl.site.SiteRest;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.junit.Before;
import org.junit.Test;

public class SiteRestTest
extends AbstractResourceTest {
    private static final String ACCESS_PERMISSIONS_ATTRIBUTE = "accessPermissions";
    private static final String EVERYONE = "Everyone";
    private static final String PLATFORM_USERS = "*:/platform/users";
    private LayoutService layoutService;
    private SiteDAO siteDAO;

    @Override
    @Before
    public void setUp() throws Exception {
        this.begin();
        super.setUp();
        this.siteDAO = (SiteDAO)this.getContainer().getComponentInstanceOfType(SiteDAO.class);
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        this.addResource(SiteRest.class, null);
        this.startSessionAs("root1");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetSites() throws Exception {
        HashSet<MembershipEntry> ms = new HashSet<MembershipEntry>();
        ms.add(new MembershipEntry("/platform/users"));
        this.startSessionAs("john", ms);
        String path = "/v1/social/sites";
        ContainerResponse resp = this.getResponse("GET", path, "");
        SiteRestTest.assertEquals((int)200, (int)resp.getStatus());
        Object entity = resp.getEntity();
        SiteRestTest.assertNotNull((Object)entity);
        List siteRestEntities = (List)resp.getEntity();
        SiteRestTest.assertFalse((boolean)siteRestEntities.isEmpty());
        path = "/v1/social/sites?siteType=PORTAL&sortByDisplayOrder=true&filterByDisplayed=true&displayed=true";
        resp = this.getResponse("GET", path, "");
        SiteRestTest.assertEquals((int)200, (int)resp.getStatus());
        entity = resp.getEntity();
        SiteRestTest.assertNotNull((Object)entity);
        siteRestEntities = (List)resp.getEntity();
        SiteRestTest.assertFalse((boolean)siteRestEntities.isEmpty());
        SiteRestTest.assertEquals((int)0, (int)((SiteEntity)siteRestEntities.get(0)).getDisplayOrder());
        SiteRestTest.assertEquals((int)1, (int)((SiteEntity)siteRestEntities.get(1)).getDisplayOrder());
        path = "/v1/social/sites?siteType=PORTAL&sortByDisplayOrder=true&filterByDisplayed=true&displayed=true&expandNavigations=true&excludeEmptyNavigationSites=true";
        resp = this.getResponse("GET", path, "");
        SiteRestTest.assertEquals((int)200, (int)resp.getStatus());
        entity = resp.getEntity();
        SiteRestTest.assertNotNull((Object)entity);
        siteRestEntities = (List)resp.getEntity();
        SiteRestTest.assertFalse((boolean)((SiteEntity)siteRestEntities.get(0)).getSiteNavigations().isEmpty());
    }

    @Test
    public void testGetSiteBanner() throws Exception {
        String originPath = this.getBaseUrl();
        org.exoplatform.portal.jdbc.entity.SiteEntity site = this.siteDAO.findAll().stream().filter(siteEntity -> siteEntity.getSiteType() == SiteType.PORTAL).findFirst().get();
        site.setBannerFileId(1L);
        this.siteDAO.update((Object)site);
        String path = originPath + "notValidSiteName/banner?bannerId=1";
        ContainerResponse resp = this.getResponse("GET", path, "");
        SiteRestTest.assertEquals((int)404, (int)resp.getStatus());
        path = originPath + site.getName() + "/banner?bannerId=0";
        resp = this.getResponse("GET", path, "");
        SiteRestTest.assertEquals((int)200, (int)resp.getStatus());
        Object entity = resp.getEntity();
        SiteRestTest.assertNotNull((Object)entity);
        path = originPath + site.getName() + "/banner?bannerId=1";
        resp = this.getResponse("GET", path, "");
        SiteRestTest.assertEquals((int)200, (int)resp.getStatus());
    }

    @Test
    public void testGetSiteById() throws Exception {
        HashSet<MembershipEntry> ms = new HashSet<MembershipEntry>();
        ms.add(new MembershipEntry("/platform/users"));
        this.startSessionAs("john", ms);
        org.exoplatform.portal.jdbc.entity.SiteEntity site = this.siteDAO.findAll().stream().filter(siteEntity -> siteEntity.getSiteType() == SiteType.PORTAL).findFirst().get();
        String path = this.getBaseUrl() + "8594";
        ContainerResponse resp = this.getResponse("GET", path, "");
        SiteRestTest.assertEquals((int)404, (int)resp.getStatus());
        Object entity = resp.getEntity();
        SiteRestTest.assertNull((Object)entity);
        path = this.getBaseUrl() + site.getId();
        resp = this.getResponse("GET", path, "");
        SiteRestTest.assertEquals((int)200, (int)resp.getStatus());
        entity = resp.getEntity();
        SiteRestTest.assertNotNull((Object)entity);
        SiteEntity siteEntity2 = (SiteEntity)entity;
        SiteRestTest.assertEquals((String)siteEntity2.getDescription(), (String)site.getDescription());
        SiteRestTest.assertEquals((long)siteEntity2.getBannerFileId(), (long)site.getBannerFileId());
        SiteRestTest.assertNotNull((Object)siteEntity2.getRootNode());
        SiteRestTest.assertNotNull((Object)siteEntity2.getBannerUrl());
    }

    @Test
    public void testUpdateSiteById() {
        PortalConfig portalConfig = this.layoutService.getPortalConfig("classic");
        portalConfig.setAccessPermissions(new String[]{PLATFORM_USERS});
        this.layoutService.save(portalConfig);
        this.startSessionAs("test", true);
        ContainerResponse resp = this.savePortalAccessPermission(ACCESS_PERMISSIONS_ATTRIBUTE, PLATFORM_USERS, portalConfig.getStorageId());
        SiteRestTest.assertEquals((int)204, (int)resp.getStatus());
        portalConfig = this.layoutService.getPortalConfig("classic");
        SiteRestTest.assertNotNull((Object)portalConfig.getAccessPermissions());
        SiteRestTest.assertEquals((String)PLATFORM_USERS, (String)portalConfig.getAccessPermissions()[0]);
        resp = this.savePortalAccessPermission(ACCESS_PERMISSIONS_ATTRIBUTE, EVERYONE, portalConfig.getStorageId());
        SiteRestTest.assertEquals((int)204, (int)resp.getStatus());
        portalConfig = this.layoutService.getPortalConfig("classic");
        SiteRestTest.assertNotNull((Object)portalConfig.getAccessPermissions());
        SiteRestTest.assertEquals((String)EVERYONE, (String)portalConfig.getAccessPermissions()[0]);
        resp = this.savePortalAccessPermission(ACCESS_PERMISSIONS_ATTRIBUTE, EVERYONE, "site_555648");
        SiteRestTest.assertEquals((int)404, (int)resp.getStatus());
        this.startSessionAs("test");
        resp = this.savePortalAccessPermission(ACCESS_PERMISSIONS_ATTRIBUTE, PLATFORM_USERS, portalConfig.getStorageId());
        SiteRestTest.assertEquals((int)401, (int)resp.getStatus());
    }

    private ContainerResponse savePortalAccessPermission(String name, String permissions, String siteStorageId) {
        try {
            long siteId = Long.parseLong(siteStorageId.split("_")[1]);
            String path = this.getBaseUrl() + siteId;
            String urlParam = "name=" + name + "&value=" + permissions;
            MultivaluedMapImpl h = new MultivaluedMapImpl();
            h.putSingle((Object)"content-type", (Object)"application/x-www-form-urlencoded");
            h.putSingle((Object)"content-length", (Object)("" + urlParam.length()));
            return this.service("PATCH", path, "", (MultivaluedMap<String, String>)h, urlParam.getBytes());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String getBaseUrl() {
        return "/v1/social/sites/";
    }
}

