/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.List;
import java.util.Random;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.SecurityManager;
import org.exoplatform.social.service.test.AbstractServiceTest;

public class SecurityManagerTest
extends AbstractServiceTest {
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private ActivityManager activityManager;
    private SpaceService spaceService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        this.demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        SecurityManagerTest.assertNotNull((Object)this.rootIdentity);
        SecurityManagerTest.assertNotNull((Object)this.johnIdentity);
        SecurityManagerTest.assertNotNull((Object)this.maryIdentity);
        SecurityManagerTest.assertNotNull((Object)this.demoIdentity);
        this.restartTransaction();
        this.begin();
        this.deleteAllRelationships();
        this.restartTransaction();
    }

    @Override
    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public void testCanAccessActivityUnknown() {
        this.createActivities(this.demoIdentity, this.demoIdentity, 2);
        RealtimeListAccess demoActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ExoSocialActivity activity = (ExoSocialActivity)demoActivitiesListAccess.loadAsList(0, demoActivitiesListAccess.getSize()).get(0);
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (String)this.johnIdentity.getRemoteId(), (ExoSocialActivity)activity));
    }

    public void testCanAccessActivityMine() {
        this.createActivities(this.demoIdentity, this.demoIdentity, 2);
        RealtimeListAccess demoActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ExoSocialActivity activity = (ExoSocialActivity)demoActivitiesListAccess.loadAsList(0, demoActivitiesListAccess.getSize()).get(0);
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (String)this.demoIdentity.getRemoteId(), (ExoSocialActivity)activity));
    }

    public void testCanAccessActivityNetwork() {
        this.createActivities(this.demoIdentity, this.demoIdentity, 2);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        RealtimeListAccess demoActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ExoSocialActivity activity = (ExoSocialActivity)demoActivitiesListAccess.loadAsList(0, demoActivitiesListAccess.getSize()).get(0);
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (String)this.johnIdentity.getRemoteId(), (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (String)this.maryIdentity.getRemoteId(), (ExoSocialActivity)activity));
    }

    public void testCanAccessActivitySpace() throws SpaceException {
        this.createSpace("space1");
        Space space1 = this.spaceService.getSpaceByDisplayName("space1");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space1.getPrettyName(), false);
        this.createActivities(spaceIdentity, spaceIdentity, 2);
        RealtimeListAccess spaceActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(spaceIdentity);
        ExoSocialActivity activity = (ExoSocialActivity)spaceActivitiesListAccess.loadAsList(0, 10).get(0);
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (String)this.demoIdentity.getRemoteId(), (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)true, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (String)this.maryIdentity.getRemoteId(), (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)false, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)activity));
        SecurityManagerTest.assertEquals((boolean)false, (boolean)SecurityManager.canAccessActivity((PortalContainer)this.getContainer(), (String)this.johnIdentity.getRemoteId(), (ExoSocialActivity)activity));
    }

    public void testCanPostActivity() {
        boolean demoPostToDemo = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (Identity)this.demoIdentity);
        SecurityManagerTest.assertTrue((String)"demoPostToDemo must be true", (boolean)demoPostToDemo);
        boolean demoPostToJohn = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (Identity)this.johnIdentity);
        SecurityManagerTest.assertFalse((String)"demoPostToJohn must be false", (boolean)demoPostToJohn);
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        boolean demoPostToMary = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (Identity)this.maryIdentity);
        boolean maryPostToDemo = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (Identity)this.demoIdentity);
        SecurityManagerTest.assertFalse((String)"demoPostToMary must be false", (boolean)demoPostToMary);
        SecurityManagerTest.assertFalse((String)"maryPostToDemo must be false", (boolean)maryPostToDemo);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        demoPostToMary = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (Identity)this.maryIdentity);
        maryPostToDemo = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (Identity)this.demoIdentity);
        SecurityManagerTest.assertTrue((String)"demoPostToMary must be true", (boolean)demoPostToMary);
        SecurityManagerTest.assertTrue((String)"maryPostToDemo must be true", (boolean)maryPostToDemo);
        this.createSpace("space2");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "space2", false);
        SecurityManagerTest.assertNotNull((String)"spaceIdentity must not be null", (Object)spaceIdentity);
        boolean demoPostToSpace = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (Identity)spaceIdentity);
        SecurityManagerTest.assertTrue((String)"demoPostToSpace must be true", (boolean)demoPostToSpace);
        boolean maryPostToSpace = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (Identity)spaceIdentity);
        SecurityManagerTest.assertTrue((String)"maryPostToSpace must be false", (boolean)maryPostToSpace);
        boolean johnPostToSpace = SecurityManager.canPostActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (Identity)spaceIdentity);
        SecurityManagerTest.assertFalse((String)"johnPostToSpace must be false", (boolean)johnPostToSpace);
    }

    public void testCanDeleteActivity() {
        this.createActivities(this.demoIdentity, this.demoIdentity, 2);
        RealtimeListAccess demoActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ExoSocialActivity demoActivity = (ExoSocialActivity)demoActivitiesListAccess.loadAsList(0, demoActivitiesListAccess.getSize()).get(1);
        boolean demoDeleteDemoActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)demoActivity);
        SecurityManagerTest.assertTrue((String)"demoDeleteDemoActivity must be true", (boolean)demoDeleteDemoActivity);
        boolean maryDeleteDemoActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)demoActivity);
        SecurityManagerTest.assertFalse((String)"maryDeleteDemoActivity must be false", (boolean)maryDeleteDemoActivity);
        this.createActivities(this.johnIdentity, this.johnIdentity, 1);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, false);
        RealtimeListAccess johnActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.johnIdentity);
        ExoSocialActivity johnActivity = (ExoSocialActivity)johnActivitiesListAccess.loadAsList(0, johnActivitiesListAccess.getSize()).get(0);
        boolean demoDeleteJohnActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)johnActivity);
        SecurityManagerTest.assertFalse((String)"demoDeleteDemoActivity must be false", (boolean)demoDeleteJohnActivity);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.demoIdentity, this.johnIdentity, 1);
        johnActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.johnIdentity);
        demoActivity = (ExoSocialActivity)johnActivitiesListAccess.loadAsList(0, johnActivitiesListAccess.getSize()).get(0);
        demoDeleteDemoActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)demoActivity);
        SecurityManagerTest.assertTrue((String)"demoDeleteDemoActivity must be true", (boolean)demoDeleteDemoActivity);
        boolean johnDeleteDemoActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)demoActivity);
        SecurityManagerTest.assertTrue((String)"johnDeleteDemoActivity must be true", (boolean)johnDeleteDemoActivity);
        this.createSpace("space3");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "space3", false);
        this.createActivities(spaceIdentity, spaceIdentity, 1);
        RealtimeListAccess spaceActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(spaceIdentity);
        ExoSocialActivity spaceActivity = (ExoSocialActivity)spaceActivitiesListAccess.loadAsList(0, 1).get(0);
        boolean demoDeleteSpaceActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)spaceActivity);
        SecurityManagerTest.assertTrue((String)"demoDeleteDemoActivity must be true", (boolean)demoDeleteSpaceActivity);
        boolean maryDeleteSpaceActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)spaceActivity);
        SecurityManagerTest.assertFalse((String)"maryDeleteSpaceActivity must be false", (boolean)maryDeleteSpaceActivity);
        boolean johnDeleteSpaceActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)spaceActivity);
        SecurityManagerTest.assertFalse((String)"johnDeleteSpaceActivity must be false", (boolean)johnDeleteSpaceActivity);
        this.createActivities(this.demoIdentity, spaceIdentity, 1);
        spaceActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(spaceIdentity);
        ExoSocialActivity demoToSpaceActivity = (ExoSocialActivity)spaceActivitiesListAccess.loadAsList(0, 10).get(0);
        boolean demoDeleteDemoToSpaceActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)demoToSpaceActivity);
        SecurityManagerTest.assertTrue((String)"demoDeleteDemoToSpaceActivity must be true", (boolean)demoDeleteDemoToSpaceActivity);
        boolean maryDeleteDemoToSpaceActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)demoToSpaceActivity);
        SecurityManagerTest.assertFalse((String)"maryDeleteDemoToSpaceActivity must be false", (boolean)maryDeleteDemoToSpaceActivity);
        boolean johnDeleteDemoToSpaceActivity = SecurityManager.canDeleteActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)demoToSpaceActivity);
        SecurityManagerTest.assertFalse((String)"johnDeleteDemoToSpaceActivity must be false", (boolean)johnDeleteDemoToSpaceActivity);
    }

    public void testCanCommentToActivity() {
        this.createActivities(this.demoIdentity, this.demoIdentity, 1);
        RealtimeListAccess demoActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ExoSocialActivity demoActivity = (ExoSocialActivity)demoActivitiesListAccess.loadAsList(0, demoActivitiesListAccess.getSize()).get(0);
        boolean demoCommentToDemoActivity = SecurityManager.canCommentToActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)demoActivity);
        SecurityManagerTest.assertTrue((String)"demoCommentToDemoActivity must be true", (boolean)demoCommentToDemoActivity);
        this.connectIdentities(this.maryIdentity, this.demoIdentity, false);
        boolean maryCommentToDemoActivity = SecurityManager.canCommentToActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)demoActivity);
        SecurityManagerTest.assertFalse((String)"maryCommentToDemoActivity must be false", (boolean)maryCommentToDemoActivity);
        this.connectIdentities(this.maryIdentity, this.demoIdentity, true);
        maryCommentToDemoActivity = SecurityManager.canCommentToActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)demoActivity);
        SecurityManagerTest.assertTrue((String)"maryCommentToDemoActivity must be true", (boolean)maryCommentToDemoActivity);
        this.createMentionsActivities(this.johnIdentity, this.maryIdentity);
        RealtimeListAccess johnActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.johnIdentity);
        ExoSocialActivity johnActivity = (ExoSocialActivity)johnActivitiesListAccess.loadAsList(0, johnActivitiesListAccess.getSize()).get(0);
        SecurityManagerTest.assertTrue((boolean)SecurityManager.canCommentToActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)johnActivity));
        this.createSpace("space4");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "space4", false);
        this.createActivities(spaceIdentity, spaceIdentity, 1);
        RealtimeListAccess spaceActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(spaceIdentity);
        ExoSocialActivity spaceActivity = (ExoSocialActivity)spaceActivitiesListAccess.loadAsList(0, spaceActivitiesListAccess.getSize()).get(0);
        boolean demoCommentToSpaceActivity = SecurityManager.canCommentToActivity((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)spaceActivity);
        SecurityManagerTest.assertTrue((String)"demoCommentToSpaceActivity must be true", (boolean)demoCommentToSpaceActivity);
        boolean maryCommentToSpaceActivity = SecurityManager.canCommentToActivity((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)spaceActivity);
        SecurityManagerTest.assertTrue((String)"maryCommentToSpaceActivity must be true", (boolean)maryCommentToSpaceActivity);
        boolean johnCommentToSpaceActivity = SecurityManager.canCommentToActivity((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)spaceActivity);
        SecurityManagerTest.assertFalse((String)"johnCommentToSpaceActivity must be false", (boolean)johnCommentToSpaceActivity);
    }

    public void testCanDeleteComment() {
        this.createActivities(this.demoIdentity, this.demoIdentity, 1);
        RealtimeListAccess demoActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ExoSocialActivity demoActivity = (ExoSocialActivity)demoActivitiesListAccess.loadAsList(0, demoActivitiesListAccess.getSize()).get(0);
        this.createComment(demoActivity, this.demoIdentity, 1);
        RealtimeListAccess demoCommentsListAccess = this.activityManager.getCommentsWithListAccess(demoActivity);
        ExoSocialActivity demoComment = (ExoSocialActivity)demoCommentsListAccess.loadAsList(0, demoCommentsListAccess.getSize()).get(0);
        boolean demoDeleteDemoComment = SecurityManager.canDeleteComment((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (ExoSocialActivity)demoComment);
        SecurityManagerTest.assertTrue((String)"demoDeleteDemoComment must be true", (boolean)demoDeleteDemoComment);
        boolean maryDeleteDemoComment = SecurityManager.canDeleteComment((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)demoComment);
        SecurityManagerTest.assertFalse((String)"maryDeleteDemoComment must be false", (boolean)maryDeleteDemoComment);
        this.connectIdentities(this.maryIdentity, this.demoIdentity, true);
        this.createActivities(this.maryIdentity, this.maryIdentity, 1);
        RealtimeListAccess maryActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(this.maryIdentity);
        ExoSocialActivity maryActivity = (ExoSocialActivity)maryActivitiesListAccess.loadAsList(0, -1).get(0);
        this.createComment(maryActivity, this.demoIdentity, 1);
        this.createComment(maryActivity, this.maryIdentity, 1);
        RealtimeListAccess maryActivityCommentListAccess = this.activityManager.getCommentsWithListAccess(maryActivity);
        List comments = maryActivityCommentListAccess.loadAsList(0, maryActivityCommentListAccess.getSize());
        SecurityManagerTest.assertEquals((int)2, (int)comments.size());
        SecurityManagerTest.assertTrue((String)"comments.get(0).getPostedTime() < comments.get(1).getPostedTime() must return true", (((ExoSocialActivity)comments.get(0)).getPostedTime() < ((ExoSocialActivity)comments.get(1)).getPostedTime() ? 1 : 0) != 0);
        ExoSocialActivity demoCommentMaryActivity = (ExoSocialActivity)comments.get(0);
        ExoSocialActivity maryCommentMaryActivity = (ExoSocialActivity)comments.get(1);
        boolean demoDeleteMaryCommentMaryActivity = SecurityManager.canDeleteComment((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)maryCommentMaryActivity);
        SecurityManagerTest.assertTrue((String)"demoDeleteMaryCommentMaryActivity must be true", (boolean)demoDeleteMaryCommentMaryActivity);
        boolean johnDeleteDemoCommentMaryActivity = SecurityManager.canDeleteComment((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (ExoSocialActivity)demoCommentMaryActivity);
        SecurityManagerTest.assertFalse((String)"johnDeleteDemoCommentMaryActivity must be false", (boolean)johnDeleteDemoCommentMaryActivity);
        this.createSpace("space5");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "space5", false);
        this.createActivities(spaceIdentity, spaceIdentity, 1);
        RealtimeListAccess spaceActivitiesListAccess = this.activityManager.getActivitiesWithListAccess(spaceIdentity);
        ExoSocialActivity spaceActivity = (ExoSocialActivity)spaceActivitiesListAccess.loadAsList(0, spaceActivitiesListAccess.getSize()).get(0);
        this.createComment(spaceActivity, this.maryIdentity, 1);
        this.createComment(spaceActivity, this.demoIdentity, 1);
        RealtimeListAccess spaceActivityCommentsListAccess = this.activityManager.getCommentsWithListAccess(spaceActivity);
        List spaceActivityComments = spaceActivityCommentsListAccess.loadAsList(0, spaceActivityCommentsListAccess.getSize());
        ExoSocialActivity maryCommentSpaceActivity = (ExoSocialActivity)spaceActivityComments.get(0);
        ExoSocialActivity demoCommentSpaceActivity = (ExoSocialActivity)spaceActivityComments.get(1);
        boolean maryDeleteDemoCommentSpaceActivity = SecurityManager.canDeleteComment((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)demoCommentSpaceActivity);
        SecurityManagerTest.assertFalse((String)"maryDeleteDemoCommentSpaceActivity must be false", (boolean)maryDeleteDemoCommentSpaceActivity);
        boolean demoDeleteMaryCommentSpaceActivity = SecurityManager.canDeleteComment((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (ExoSocialActivity)maryCommentSpaceActivity);
        SecurityManagerTest.assertTrue((String)"demoDeleteMaryCommentSpaceActivity must be true", (boolean)demoDeleteMaryCommentSpaceActivity);
    }

    public void testCanAccessActivityStream() {
        SecurityManagerTest.assertTrue((String)"SecurityManager.canAccessActivityStream(getContainer(), demoIdentity, johnIdentity) must return true", (boolean)SecurityManager.canAccessActivityStream((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (Identity)this.johnIdentity));
        this.createSpace("space6");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "space6", false);
        SecurityManagerTest.assertFalse((String)"SecurityManager.canAccessActivityStream(getContainer(), johnIdentity, spaceIdentity) must return false", (boolean)SecurityManager.canAccessActivityStream((PortalContainer)this.getContainer(), (Identity)this.johnIdentity, (Identity)spaceIdentity));
        SecurityManagerTest.assertTrue((String)"SecurityManager.canAccessActivityStream(getContainer(), maryIdentity, spaceIdentity) must return true", (boolean)SecurityManager.canAccessActivityStream((PortalContainer)this.getContainer(), (Identity)this.maryIdentity, (Identity)spaceIdentity));
        SecurityManagerTest.assertTrue((String)"SecurityManager.canAccessActivityStream(getContainer(), demoIdentity, spaceIdentity) musts return true", (boolean)SecurityManager.canAccessActivityStream((PortalContainer)this.getContainer(), (Identity)this.demoIdentity, (Identity)spaceIdentity));
    }

    private void createActivities(Identity posterIdentity, Identity identityStream, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setType("exosocial:core");
            activity.setTitle("title " + i);
            activity.setUserId(posterIdentity.getId());
            activity.setPosterId(posterIdentity.getId());
            this.activityManager.saveActivityNoReturn(identityStream, (ExoSocialActivity)activity);
            activity = this.activityManager.getActivity(activity.getId());
        }
    }

    private void createMentionsActivities(Identity posterIdentity, Identity mentionedIdentity) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @" + mentionedIdentity.getRemoteId());
        activity.setUserId(posterIdentity.getId());
        activity.setPosterId(posterIdentity.getId());
        this.activityManager.saveActivityNoReturn(posterIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
    }

    private void createComment(ExoSocialActivity existingActivity, Identity posterIdentity, int number) {
        RealtimeListAccess existingActivityCommentListAccess = null;
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(posterIdentity.getId());
            this.activityManager.saveComment(existingActivity, (ExoSocialActivity)comment);
            existingActivityCommentListAccess = this.activityManager.getCommentsWithListAccess(existingActivity);
            comment = (ExoSocialActivity)existingActivityCommentListAccess.loadAsList(0, existingActivityCommentListAccess.getSize()).get(0);
        }
    }

    private void createSpace(String name) {
        Space space = new Space();
        space.setDisplayName(name);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + name);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/spaces/space" + new Random().nextInt());
        String[] managers = new String[]{"demo"};
        String[] members = new String[]{"demo", "mary"};
        String[] invitedUsers = new String[]{"john"};
        String[] pendingUsers = new String[]{"root"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.createSpace(space, "demo");
    }

    private void connectIdentities(Identity senderIdentity, Identity receiverIdentity, boolean beConfirmed) {
        this.relationshipManager.inviteToConnect(senderIdentity, receiverIdentity);
        if (beConfirmed) {
            this.relationshipManager.confirm(receiverIdentity, senderIdentity);
        }
    }
}

