/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.test;

import java.util.Arrays;
import junit.framework.TestCase;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.service.rest.Util;

public class UtilTest
extends TestCase {
    public void testIsValidURL() throws Exception {
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"abcd.com"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"http://google.com"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"http://\u0111\u1ecbach\u1ec9doanhnghi\u1ec7p.vn"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"http://www.google.com/language_tools?hl=en"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"https://mail.google.com/mail/?shva=1#inbox"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"http://a+b=sadasd.com.vn"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"mailto:abc@facebook.com"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"http://translate.google.com/#en|vi|What has changed?"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"translate.google.com/#en|vi|What has changed?"));
        UtilTest.assertFalse((boolean)Util.isValidURL(null));
        UtilTest.assertFalse((boolean)Util.isValidURL((String)""));
        UtilTest.assertFalse((boolean)Util.isValidURL((String)"abc"));
        UtilTest.assertFalse((boolean)Util.isValidURL((String)"a bc.com"));
        UtilTest.assertFalse((boolean)Util.isValidURL((String)"abc.c om"));
        UtilTest.assertFalse((boolean)Util.isValidURL((String)"abc : fsdfs"));
        UtilTest.assertFalse((boolean)Util.isValidURL((String)"abc #$ vn"));
        UtilTest.assertFalse((boolean)Util.isValidURL((String)"http://www.opensourcesummit.a/"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"http://www.opensourcesummit.abce/"));
        UtilTest.assertTrue((boolean)Util.isValidURL((String)"http://www.opensourcesummit.abcdef/"));
    }

    public void testGetDecodeQueryURL() throws Exception {
        String url = "http://google.com";
        UtilTest.assertEquals((String)url, (String)Util.getDecodeQueryURL((String)url));
        url = "translate.google.com/#en|vi|What has changed?";
        UtilTest.assertEquals((String)url, (String)Util.getDecodeQueryURL((String)url));
        url = "translate.google.com/?translate=abc#en";
        UtilTest.assertEquals((String)url, (String)Util.getDecodeQueryURL((String)url));
        url = "http://google.com?%3Cscript%3Ealert(%22Link_attached%22)%3C/script%3E";
        UtilTest.assertEquals((String)"http://google.com?<script>alert(\"Link_attached\")</script>", (String)Util.getDecodeQueryURL((String)url));
    }

    public void testBuildLinkForHeader() throws Exception {
        CollectionEntity rc = new CollectionEntity(Arrays.asList(new DataEntity()), "key", 0, 20);
        rc.setSize(60);
        String requestPath = "https://localhost:8080/rest/private/v1/social/identities";
        rc.setOffset(0);
        String linkForHeader = EntityBuilder.buildLinkForHeader((Object)rc, (String)requestPath).toString();
        UtilTest.assertEquals((String)"<https://localhost:8080/rest/private/v1/social/identities?offset=20&limit=20>; rel=\"next\", <https://localhost:8080/rest/private/v1/social/identities?offset=40&limit=20>; rel=\"last\"", (String)linkForHeader);
        rc.setOffset(60);
        linkForHeader = EntityBuilder.buildLinkForHeader((Object)rc, (String)requestPath).toString();
        UtilTest.assertEquals((String)"<https://localhost:8080/rest/private/v1/social/identities?offset=40&limit=20>; rel=\"prev\", <https://localhost:8080/rest/private/v1/social/identities?offset=0&limit=20>; rel=\"first\"", (String)linkForHeader);
        rc.setOffset(20);
        linkForHeader = EntityBuilder.buildLinkForHeader((Object)rc, (String)requestPath).toString();
        UtilTest.assertEquals((String)"<https://localhost:8080/rest/private/v1/social/identities?offset=40&limit=20>; rel=\"next\", <https://localhost:8080/rest/private/v1/social/identities?offset=0&limit=20>; rel=\"prev\", <https://localhost:8080/rest/private/v1/social/identities?offset=0&limit=20>; rel=\"first\", <https://localhost:8080/rest/private/v1/social/identities?offset=40&limit=20>; rel=\"last\"", (String)linkForHeader);
    }
}

