/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Map;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.tools.ResourceLauncher;
import org.exoplatform.services.test.mock.MockPrincipal;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.service-local-configuration.xml")})
public abstract class BaseRestServicesTestCase
extends AbstractKernelTest {
    protected ProviderBinder providers;
    protected ResourceBinder binder;
    protected ResourceLauncher launcher;
    protected ExoContainer container;

    public void setUp() throws Exception {
        this.begin();
        PortalContainer container = this.getContainer();
        this.container = container;
        this.binder = (ResourceBinder)container.getComponentInstanceOfType(ResourceBinder.class);
        RequestHandlerImpl requestHandler = (RequestHandlerImpl)container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ProviderBinder.setInstance((ProviderBinder)new ProviderBinder());
        this.providers = ProviderBinder.getInstance();
        this.binder.clear();
        ApplicationContextImpl.setCurrent((ApplicationContext)new ApplicationContextImpl(null, null, this.providers, null));
        this.launcher = new ResourceLauncher((RequestHandler)requestHandler);
        this.registry(this.getComponentClass());
    }

    public void tearDown() throws Exception {
        this.unregistry(this.getComponentClass());
        this.end();
    }

    protected abstract Class<?> getComponentClass();

    protected <T> T getService(Class<T> clazz) {
        return clazz.cast(this.container.getComponentInstanceOfType(clazz));
    }

    private void registry(Class<?> resourceClass) throws Exception {
        this.binder.addResource(resourceClass, null);
    }

    private void unregistry(Class<?> resourceClass) {
        this.binder.removeResource(resourceClass);
    }

    protected <T> T createProxy(Class<T> type, final Map<String, Object> result) {
        Object o = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                Object o = result.get(method.getName());
                return o instanceof Invoker ? ((Invoker)o).invoke(args) : o;
            }
        });
        return type.cast(o);
    }

    protected static class MockListAccess<T>
    implements ListAccess<T> {
        private final T[] values;

        public MockListAccess(T[] values) {
            this.values = values;
        }

        public T[] load(int index, int length) throws Exception, IllegalArgumentException {
            return this.values;
        }

        public int getSize() throws Exception {
            return this.values.length;
        }
    }

    protected static class MockSecurityContext
    implements SecurityContext {
        private final String username;

        public MockSecurityContext(String username) {
            this.username = username;
        }

        public Principal getUserPrincipal() {
            return new MockPrincipal(this.username);
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    }

    protected static interface Invoker {
        public Object invoke(Object[] var1);
    }
}

