/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.registry;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.PortletInvoker;

@Path(value="applications")
@Tag(name="applications", description="Managing Application Registry")
public class ApplicationRegistryRest
implements ResourceContainer {
    private ApplicationRegistryService applicationRegistryService;
    private UserACL userAcl;

    public ApplicationRegistryRest(ApplicationRegistryService applicationRegistryService, UserACL userAcl) {
        this.applicationRegistryService = applicationRegistryService;
        this.userAcl = userAcl;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets all applications", method="GET", description="This returns a list of all supported applications of type Portlet.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getApplications(@Parameter(description="Allow to include optional resource properties when needed", required=false) @QueryParam(value="expand") String expand) {
        Collection categories = this.applicationRegistryService.detectPortletsFromWars();
        List<Application> applications = categories.stream().flatMap(c -> c.getApplications().stream()).filter(this::hasPermission).toList();
        if (StringUtils.contains((CharSequence)expand, (CharSequence)"supportedModes")) {
            applications.forEach(this::addSupportedMode);
        }
        return Response.ok(applications).build();
    }

    @GET
    @Path(value="categories")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets all application categories", method="GET", description="This returns a list of application categories as configured in application registry")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getApplicationCategories(@Parameter(description="Allow to include optional resource properties when needed", required=false) @QueryParam(value="expand") String expand) {
        List<ApplicationCategory> categories = this.applicationRegistryService.getApplicationCategories().stream().filter(this::hasPermission).map(c -> this.filterApplications((ApplicationCategory)c, expand)).toList();
        return Response.ok(categories).build();
    }

    private ApplicationCategory filterApplications(ApplicationCategory category, String expand) {
        if (category.getApplications() != null) {
            category.setApplications(category.getApplications().stream().filter(this::hasPermission).toList());
            if (StringUtils.contains((CharSequence)expand, (CharSequence)"supportedModes")) {
                category.getApplications().forEach(this::addSupportedMode);
            }
        }
        return category;
    }

    private boolean hasPermission(ApplicationCategory category) {
        if (CollectionUtils.isEmpty((Collection)category.getAccessPermissions())) {
            return this.userAcl.isUserInGroup(this.userAcl.getAdminGroups());
        }
        return this.userAcl.hasPermission(category.getAccessPermissions().toArray(new String[0]));
    }

    private boolean hasPermission(Application application) {
        if (CollectionUtils.isEmpty((Collection)application.getAccessPermissions())) {
            return this.userAcl.isUserInGroup(this.userAcl.getAdminGroups());
        }
        return this.userAcl.hasPermission(application.getAccessPermissions().toArray(new String[0]));
    }

    private void addSupportedMode(Application application) {
        ExoContainer manager = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)manager.getComponentInstance(PortletInvoker.class);
        portletInvoker.getPortlets().stream().filter(p -> StringUtils.equals((CharSequence)application.getContentId(), (CharSequence)(p.getInfo().getApplicationName() + "/" + p.getInfo().getName()))).findFirst().ifPresent(p -> {
            Set allModes = p.getInfo().getCapabilities().getModes(MediaType.create((String)"text/html"));
            application.setSupportedModes(allModes.stream().map(m -> m.getModeName()).toList());
        });
    }
}

