/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.suggest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.suggest.SpaceRestServices;
import org.exoplatform.social.service.rest.BaseRestServicesTestCase;

public class TestSpaceRestServices
extends BaseRestServicesTestCase {
    @Override
    protected Class<?> getComponentClass() {
        return SpaceRestServices.class;
    }

    public void testSuggestions() throws Exception {
        String path = "/homepage/intranet/spaces/suggestions";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(path, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        ContainerResponse resp = this.launcher.service("GET", path, "", null, null, envctx);
        TestSpaceRestServices.assertEquals((int)500, (int)resp.getStatus());
        Identity idRoot = new Identity("organization", "root");
        idRoot.setId("root");
        Identity idFoo = new Identity("organization", "foo");
        idFoo.setId("foo");
        Identity idBar = new Identity("organization", "bar");
        idBar.setId("bar");
        envctx.put(SecurityContext.class, (Object)new BaseRestServicesTestCase.MockSecurityContext(idFoo.getRemoteId()));
        HashMap<String, Object> imResults = new HashMap<String, Object>();
        IdentityManager im = this.createProxy(IdentityManager.class, imResults);
        this.getContainer().registerComponentInstance((Object)"IdentityManager", (Object)im);
        HashMap<String, Object> relationShipResults = new HashMap<String, Object>();
        RelationshipManager relationShip = this.createProxy(RelationshipManager.class, relationShipResults);
        this.getContainer().registerComponentInstance((Object)"RelationshipManager", (Object)relationShip);
        HashMap<String, Object> ssResults = new HashMap<String, Object>();
        ssResults.put("getPublicSpacesWithListAccess", new BaseRestServicesTestCase.MockListAccess<Space>(new Space[0]));
        SpaceService ss = this.createProxy(SpaceService.class, ssResults);
        this.getContainer().registerComponentInstance((Object)"SpaceService", (Object)ss);
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        TestSpaceRestServices.assertEquals((int)200, (int)resp.getStatus());
        TestSpaceRestServices.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        TestSpaceRestServices.assertTrue((boolean)resp.getEntity().toString().contains("items"));
        imResults.put("getOrCreateIdentity", idFoo);
        relationShipResults.put("getConnections", new BaseRestServicesTestCase.MockListAccess<Identity>(new Identity[0]));
        Space space1 = new Space();
        space1.setPrettyName("space1");
        space1.setId("space1");
        space1.setVisibility("hidden");
        Space space2 = new Space();
        space2.setPrettyName("space2");
        space2.setId("space2");
        space2.setVisibility("public");
        space2.setRegistration("closed");
        Space space3 = new Space();
        space3.setPrettyName("space3");
        space3.setId("space3");
        space3.setVisibility("public");
        space3.setRegistration("open");
        space3.setMembers(new String[]{idFoo.getRemoteId()});
        Space space4 = new Space();
        space4.setPrettyName("space4");
        space4.setId("space4");
        space4.setVisibility("public");
        space4.setRegistration("open");
        space4.setPendingUsers(new String[]{idFoo.getRemoteId()});
        Space space5 = new Space();
        space5.setPrettyName("space5");
        space5.setId("space5");
        space5.setVisibility("public");
        space5.setRegistration("open");
        Space space6 = new Space();
        space6.setPrettyName("space6");
        space6.setId("space6");
        space6.setVisibility("public");
        space6.setRegistration("open");
        ss.setIgnored(space6.getId(), idFoo.getRemoteId());
        ssResults.put("getPublicSpacesWithListAccess", new BaseRestServicesTestCase.MockListAccess<Space>(new Space[]{space1, space2, space3, space4, space5}));
        ssResults.put("getLastSpaces", Arrays.asList(space1, space2, space3, space4, space5, space6));
        ssResults.put("isMember", new BaseRestServicesTestCase.Invoker(){

            @Override
            public Object invoke(Object[] args) {
                return ArrayUtils.contains((Object[])((Space)args[0]).getMembers(), (Object)args[1]);
            }
        });
        ssResults.put("isInvitedUser", new BaseRestServicesTestCase.Invoker(){

            @Override
            public Object invoke(Object[] args) {
                return ArrayUtils.contains((Object[])((Space)args[0]).getInvitedUsers(), (Object)args[1]);
            }
        });
        ssResults.put("isPendingUser", new BaseRestServicesTestCase.Invoker(){

            @Override
            public Object invoke(Object[] args) {
                return ArrayUtils.contains((Object[])((Space)args[0]).getPendingUsers(), (Object)args[1]);
            }
        });
        ssResults.put("isIgnored", new BaseRestServicesTestCase.Invoker(){

            @Override
            public Object invoke(Object[] args) {
                return ((Space)args[0]).getId().equals("space6");
            }
        });
        resp = this.launcher.service("GET", path, "", null, null, envctx);
        TestSpaceRestServices.assertEquals((int)200, (int)resp.getStatus());
        TestSpaceRestServices.assertEquals((String)"application/json", (String)resp.getContentType().toString());
        TestSpaceRestServices.assertTrue((boolean)resp.getEntity().toString().contains("items"));
        TestSpaceRestServices.assertFalse((boolean)resp.getEntity().toString().contains("space1"));
        TestSpaceRestServices.assertFalse((boolean)resp.getEntity().toString().contains("space2"));
        TestSpaceRestServices.assertFalse((boolean)resp.getEntity().toString().contains("space3"));
        TestSpaceRestServices.assertFalse((boolean)resp.getEntity().toString().contains("space4"));
        TestSpaceRestServices.assertTrue((boolean)resp.getEntity().toString().contains("space5"));
        TestSpaceRestServices.assertFalse((boolean)resp.getEntity().toString().contains("space6"));
        this.getContainer().unregisterComponent((Object)"SpaceService");
        this.getContainer().unregisterComponent((Object)"IdentityManager");
    }
}

