/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.composer;

import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;

@ComponentConfig
public class UIDefaultActivityComposer
extends UIActivityComposer {
    public UIDefaultActivityComposer() {
        this.setReadyForPostingActivity(false);
    }

    @Override
    public void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
        if (postedMessage.equals("")) {
            UIApplication uiApplication = requestContext.getUIApplication();
            uiApplication.addMessage(new ApplicationMessage("UIComposer.msg.error.Empty_Message", null, 1));
            return;
        }
        if (postContext == UIComposer.PostContext.SPACE) {
            UISpaceActivitiesDisplay uiDisplaySpaceActivities = (UISpaceActivitiesDisplay)this.getActivityDisplay();
            Space space = uiDisplaySpaceActivities.getSpace();
            Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", space.getPrettyName(), false);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(Utils.getViewerIdentity().getId(), "exosocial:spaces", postedMessage, null);
            activity.setType("DEFAULT_ACTIVITY");
            Utils.getActivityManager().saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            uiDisplaySpaceActivities.init();
        } else if (postContext == UIComposer.PostContext.USER) {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getActivityDisplay();
            Identity ownerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", uiUserActivitiesDisplay.getOwnerName(), false);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(Utils.getViewerIdentity().getId(), "exosocial:people", postedMessage, null);
            activity.setType("DEFAULT_ACTIVITY");
            Utils.getActivityManager().saveActivityNoReturn(ownerIdentity, (ExoSocialActivity)activity);
            uiUserActivitiesDisplay.setPostActivity(true);
            if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.MY_SPACE) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(UIUserActivitiesDisplay.DisplayMode.ALL_ACTIVITIES);
            }
        }
    }

    @Override
    protected void onClose(Event<UIActivityComposer> event) {
    }

    @Override
    protected void onSubmit(Event<UIActivityComposer> event) {
    }

    @Override
    protected void onActivate(Event<UIActivityComposer> event) {
    }
}

