/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIHeaderSection.gtmpl", events={@EventConfig(listeners={AddContactActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AcceptContactActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DenyContactActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIProfileSection.EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class})})
public class UIHeaderSection
extends UIProfileSection {
    private static final String INVITATION_REVOKED_INFO = "UIHeaderSection.label.RevokedInfo";
    private static final String INVITATION_ESTABLISHED_INFO = "UIHeaderSection.label.InvitationEstablishedInfo";
    private static final String HTML_ATTRIBUTE_TITLE = "title";

    public UIHeaderSection() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        UIFormStringInput position = new UIFormStringInput("position", "position", null);
        position.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIHeaderSection.label.yourPosition"));
        this.addUIFormInput((UIFormInput)position.addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        this.setSubmitAction("return false;");
    }

    protected Relationship.Type getContactStatus() throws Exception {
        Relationship rl = this.getRelationship();
        if (rl == null) {
            return null;
        }
        return rl.getStatus();
    }

    protected Relationship getRelationship() throws Exception {
        return Utils.getRelationshipManager().get(Utils.getOwnerIdentity(), Utils.getViewerIdentity());
    }

    public void setValue() throws Exception {
        if (!this.isFirstLoad()) {
            UIFormStringInput uiPosition = (UIFormStringInput)this.getChildById("position");
            Profile profile = this.getProfile();
            String position = StringEscapeUtils.unescapeHtml((String)((String)profile.getProperty("position")));
            position = position == null ? "" : position;
            uiPosition.setValue((Object)position);
            this.setFirstLoad(true);
        }
    }

    public static class DenyContactActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeaderSection = (UIHeaderSection)((Object)event.getSource());
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            Relationship relationship = uiHeaderSection.getRelationship();
            if (relationship == null) {
                uiApplication.addMessage(new ApplicationMessage(UIHeaderSection.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().delete(relationship);
            Utils.updateWorkingWorkSpace();
        }
    }

    public static class AcceptContactActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeaderSection = (UIHeaderSection)((Object)event.getSource());
            Relationship relationship = uiHeaderSection.getRelationship();
            if (relationship == null || relationship.getStatus().equals((Object)Relationship.Type.IGNORED)) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIHeaderSection.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().confirm(relationship.getReceiver(), relationship.getSender());
            Utils.updateWorkingWorkSpace();
        }
    }

    public static class AddContactActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeaderSection = (UIHeaderSection)((Object)event.getSource());
            Relationship relationship = uiHeaderSection.getRelationship();
            if (relationship != null) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIHeaderSection.INVITATION_ESTABLISHED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().inviteToConnect(Utils.getViewerIdentity(), Utils.getOwnerIdentity());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiHeaderSection);
        }
    }

    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIHeaderSection uiHeaderSect = (UIHeaderSection)sect;
            UIFormStringInput uiPosition = (UIFormStringInput)uiHeaderSect.getChildById("position");
            String position = (String)uiPosition.getValue();
            Profile p = uiHeaderSect.getProfile();
            p.setProperty("position", (Object)sect.escapeHtml(position));
            Utils.getIdentityManager().updateProfile(p);
            sect.setFirstLoad(false);
        }
    }

    public static class CancelActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeader = (UIHeaderSection)((Object)event.getSource());
            uiHeader.setEditMode(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiHeader);
        }
    }

    public static class EditActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeader = (UIHeaderSection)((Object)event.getSource());
            uiHeader.setEditMode(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiHeader);
            uiHeader.setFirstLoad(false);
        }
    }
}

