/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UIPageNodeForm;
import org.exoplatform.social.webui.space.UISpaceNavigationManagement;
import org.exoplatform.social.webui.space.UISpaceNavigationNodeSelector;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/social/webui/space/UIManageMySpaces.gtmpl", events={@EventConfig(listeners={DeleteSpaceActionListener.class}, confirm="UIManageMySpaces.msg.confirm_space_delete"), @EventConfig(listeners={LeaveSpaceActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={LoadMoreSpaceActionListener.class})})
public class UIManageMySpaces
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIManageMySpaces.class);
    private static final String MSG_WARNING_LEAVE_SPACE = "UIManageMySpaces.msg.warning_leave_space";
    private static final Integer LEADER = 1;
    private static final Integer MEMBER = 2;
    private static final String SPACE_DELETED_INFO = "UIManageMySpaces.msg.DeletedInfo";
    private static final String MEMBERSHIP_REMOVED_INFO = "UIManageMySpaces.msg.MemberShipRemovedInfo";
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String SEARCH_ALL = "All";
    private final Integer SPACES_PER_PAGE = 20;
    private SpaceService spaceService = null;
    private String userId = null;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");
    private boolean loadAtEnd = false;
    private boolean hasUpdatedSpace = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private String spaceNameSearch;
    private List<Space> mySpacesList;
    private ListAccess<Space> mySpacesListAccess;
    private int mySpacesNum;

    public UIManageMySpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(CONFIRMED_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.init();
    }

    public void init() {
        try {
            this.setHasUpdatedSpace(false);
            this.setLoadAtEnd(false);
            this.enableLoadNext = true;
            this.currentLoadIndex = 0;
            this.loadingCapacity = this.SPACES_PER_PAGE;
            this.mySpacesList = new ArrayList<Space>();
            this.setMySpacesList(this.loadMySpaces(this.currentLoadIndex, this.loadingCapacity));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean unableLoadNext) {
        this.enableLoadNext = unableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public boolean isHasUpdatedSpace() {
        return this.hasUpdatedSpace;
    }

    public void setHasUpdatedSpace(boolean hasUpdatedSpace) {
        this.hasUpdatedSpace = hasUpdatedSpace;
    }

    public List<Space> getMySpacesList() throws Exception {
        if (this.isHasUpdatedSpace()) {
            this.setHasUpdatedSpace(false);
            this.setMySpacesList(this.loadMySpaces(0, this.mySpacesList.size()));
        }
        this.setEnableLoadNext(this.mySpacesList.size() >= this.SPACES_PER_PAGE && this.mySpacesList.size() < this.getMySpacesNum());
        return this.mySpacesList;
    }

    public void setMySpacesList(List<Space> mySpacesList) {
        this.mySpacesList = mySpacesList;
    }

    public int getMySpacesNum() {
        return this.mySpacesNum;
    }

    public void setMySpacesNum(int mySpacesNum) {
        this.mySpacesNum = mySpacesNum;
    }

    public String getSpaceNameSearch() {
        return this.spaceNameSearch;
    }

    public void setSpaceNameSearch(String spaceNameSearch) {
        this.spaceNameSearch = spaceNameSearch;
    }

    public ListAccess<Space> getMySpacesListAccess() {
        return this.mySpacesListAccess;
    }

    public void setMySpacesListAccess(ListAccess<Space> mySpacesListAccess) {
        this.mySpacesListAccess = mySpacesListAccess;
    }

    public void loadNext() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
        if (this.currentLoadIndex <= this.getMySpacesNum()) {
            this.mySpacesList.addAll(new ArrayList<Object>(Arrays.asList(this.getMySpacesListAccess().load(this.currentLoadIndex, this.loadingCapacity))));
        }
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setMySpacesList(this.loadMySpaces(this.currentLoadIndex, this.loadingCapacity));
    }

    private List<Space> loadMySpaces(int index, int length) throws Exception {
        String charSearch = this.uiSpaceSearch.getSelectedChar();
        String searchCondition = this.uiSpaceSearch.getSpaceNameSearch();
        if (charSearch == null && searchCondition == null || charSearch != null && charSearch.equals(SEARCH_ALL)) {
            this.setMySpacesListAccess((ListAccess<Space>)this.getSpaceService().getMemberSpaces(this.getUserId()));
        } else {
            SpaceFilter spaceFilter = null;
            spaceFilter = charSearch != null ? new SpaceFilter(charSearch.charAt(0)) : new SpaceFilter(searchCondition);
            this.setMySpacesListAccess((ListAccess<Space>)this.getSpaceService().getMemberSpacesByFilter(this.getUserId(), spaceFilter));
        }
        this.setMySpacesNum(this.getMySpacesListAccess().getSize());
        this.uiSpaceSearch.setSpaceNum(this.getMySpacesNum());
        Space[] spaces = (Space[])this.getMySpacesListAccess().load(index, length);
        return new ArrayList<Space>(Arrays.asList(spaces));
    }

    private List<String> getMySpaceNames() {
        ArrayList<String> spaceNames = new ArrayList<String>();
        for (Space space : this.mySpacesList) {
            spaceNames.add(space.getDisplayName());
        }
        return spaceNames;
    }

    public int getRole(String spaceId) throws SpaceException {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(spaceId);
        String userId = this.getUserId();
        if (space != null && spaceService.hasSettingPermission(space, userId)) {
            return LEADER;
        }
        return MEMBER;
    }

    public boolean hasMembership(String spaceId) throws SpaceException {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        Space space = spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        return spaceService.isMember(space, userId);
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public static class LeaveSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)((Object)event.getSource());
            SpaceService spaceService = uiMySpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiMySpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            uiMySpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isMember(space, userId) && !spaceService.hasSettingPermission(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MEMBERSHIP_REMOVED_INFO, null, 2));
                return;
            }
            if (spaceService.isOnlyManager(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MSG_WARNING_LEAVE_SPACE, null, 1));
                return;
            }
            spaceService.removeMember(space, userId);
            spaceService.setManager(space, userId, false);
            uiMySpaces.setHasUpdatedSpace(true);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    public static class DeleteSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)((Object)event.getSource());
            SpaceService spaceService = uiMySpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            Space space = spaceService.getSpaceById(spaceId);
            String userId = uiMySpaces.getUserId();
            uiMySpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isMember(space, userId) && !spaceService.hasSettingPermission(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MEMBERSHIP_REMOVED_INFO, null, 2));
                return;
            }
            spaceService.deleteSpace(space);
            uiMySpaces.setHasUpdatedSpace(true);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    public static class BackActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiPageNode = (UIPageNodeForm)((Object)event.getSource());
            UserNavigation contextNavigation = uiPageNode.getContextPageNavigation();
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)uiPageNode.getAncestorOfType(UIManageMySpaces.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiMySpaces.getChild(UIPopupWindow.class);
            UISpaceNavigationManagement navigationManager = (UISpaceNavigationManagement)uiMySpaces.createUIComponent(UISpaceNavigationManagement.class, null, null);
            navigationManager.setOwner(contextNavigation.getKey().getName());
            navigationManager.setOwnerType(contextNavigation.getKey().getTypeName());
            UISpaceNavigationNodeSelector selector = (UISpaceNavigationNodeSelector)navigationManager.getChild(UISpaceNavigationNodeSelector.class);
            selector.setEdittedNavigation(contextNavigation);
            selector.initTreeData();
            uiPopup.setUIComponent((UIComponent)navigationManager);
            uiPopup.setWindowSize(400, 400);
            uiPopup.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMySpaces);
        }
    }

    public static class SearchActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiManageMySpaces = (UIManageMySpaces)((Object)event.getSource());
            uiManageMySpaces.loadSearch();
            uiManageMySpaces.setLoadAtEnd(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManageMySpaces);
        }
    }

    public static class LoadMoreSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiManageMySpaces = (UIManageMySpaces)((Object)event.getSource());
            uiManageMySpaces.loadNext();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManageMySpaces);
        }
    }
}

