/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/social/webui/space/UIManageAllSpaces.gtmpl", events={@EventConfig(listeners={RequestToJoinActionListener.class}), @EventConfig(listeners={CancelInvitationActionListener.class}), @EventConfig(listeners={AcceptInvitationActionListener.class}), @EventConfig(listeners={IgnoreInvitationActionListener.class}), @EventConfig(listeners={LeaveSpaceActionListener.class}), @EventConfig(listeners={DeleteSpaceActionListener.class}, confirm="UIManageAllSpaces.msg.confirm_space_delete"), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMoreSpaceActionListener.class})})
public class UIManageAllSpaces
extends UIContainer {
    public static final String SEARCH_ALL = "All";
    private static final String SPACE_SEARCH = "SpaceSearch";
    private static final Log LOG = ExoLogger.getLogger(UIManageAllSpaces.class);
    private static final String SPACE_DELETED_INFO = "UIManageAllSpaces.msg.DeletedInfo";
    private static final String MEMBERSHIP_REMOVED_INFO = "UIManageAllSpaces.msg.MemberShipRemovedInfo";
    private static final String MSG_WARNING_LEAVE_SPACE = "UIManageAllSpaces.msg.warning_leave_space";
    private static final String INVITATION_REVOKED_INFO = "UIManageAllSpaces.msg.RevokedInfo";
    private SpaceService spaceService = null;
    private String userId = null;
    private final Integer SPACES_PER_PAGE = 20;
    private static final String ALL_SPACES_STATUS = "all_spaces";
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");
    private boolean loadAtEnd = false;
    private boolean hasUpdatedSpace = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private String spaceNameSearch;
    private List<Space> spacesList;
    private ListAccess<Space> spacesListAccess;
    private int spacesNum;
    private String selectedChar = null;

    public UIManageAllSpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(ALL_SPACES_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.init();
    }

    public void init() {
        try {
            this.setHasUpdatedSpace(false);
            this.setLoadAtEnd(false);
            this.enableLoadNext = false;
            this.currentLoadIndex = 0;
            this.loadingCapacity = this.SPACES_PER_PAGE;
            this.spacesList = new ArrayList<Space>();
            this.setSpacesList(this.loadSpaces(this.currentLoadIndex, this.loadingCapacity));
            this.setSelectedChar(SEARCH_ALL);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public boolean isHasUpdatedSpace() {
        return this.hasUpdatedSpace;
    }

    public void setHasUpdatedSpace(boolean hasUpdatedSpace) {
        this.hasUpdatedSpace = hasUpdatedSpace;
    }

    public List<Space> getSpacesList() throws Exception {
        if (this.isHasUpdatedSpace()) {
            this.setHasUpdatedSpace(false);
            this.setSpacesList(this.loadSpaces(0, this.spacesList.size()));
        }
        this.setEnableLoadNext(this.spacesList.size() >= this.SPACES_PER_PAGE && this.spacesList.size() < this.getSpacesNum());
        return this.spacesList;
    }

    public void setSpacesList(List<Space> spacesList) {
        this.spacesList = spacesList;
    }

    public int getSpacesNum() {
        return this.spacesNum;
    }

    public void setSpacesNum(int spacesNum) {
        this.spacesNum = spacesNum;
    }

    public String getSelectedChar() {
        return this.selectedChar;
    }

    public void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public String getSpaceNameSearch() {
        return this.spaceNameSearch;
    }

    public void setSpaceNameSearch(String spaceNameSearch) {
        this.spaceNameSearch = spaceNameSearch;
    }

    public ListAccess<Space> getSpacesListAccess() {
        return this.spacesListAccess;
    }

    public void setSpacesListAccess(ListAccess<Space> spacesListAccess) {
        this.spacesListAccess = spacesListAccess;
    }

    public void loadNext() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
        if (this.currentLoadIndex <= this.getSpacesNum()) {
            this.spacesList.addAll(new ArrayList<Object>(Arrays.asList(this.getSpacesListAccess().load(this.currentLoadIndex, this.loadingCapacity))));
        }
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setSpacesList(this.loadSpaces(this.currentLoadIndex, this.loadingCapacity));
    }

    protected static String getTypeOfSpace(Space space) {
        String currentUserId = Utils.getOwnerIdentity().getRemoteId();
        SpaceService spaceService = Utils.getSpaceService();
        if (spaceService.isInvitedUser(space, currentUserId)) {
            return TypeOfSpace.INVITED.toString();
        }
        if (spaceService.isPendingUser(space, currentUserId)) {
            return TypeOfSpace.SENT.toString();
        }
        if (spaceService.isMember(space, currentUserId)) {
            if (spaceService.isManager(space, currentUserId)) {
                return TypeOfSpace.MANAGER.toString();
            }
            return TypeOfSpace.MEMBER.toString();
        }
        return TypeOfSpace.NONE.toString();
    }

    private List<Space> loadSpaces(int index, int length) throws Exception {
        String charSearch = this.getSelectedChar();
        String searchCondition = this.uiSpaceSearch.getSpaceNameSearch();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (charSearch == null && searchCondition == null || charSearch != null && charSearch.equals(SEARCH_ALL)) {
            this.setSpacesListAccess((ListAccess<Space>)this.getSpaceService().getVisibleSpacesWithListAccess(userId, null));
        } else {
            SpaceFilter spaceFilter = null;
            spaceFilter = charSearch != null ? new SpaceFilter(charSearch.charAt(0)) : new SpaceFilter(searchCondition);
            this.setSpacesListAccess((ListAccess<Space>)this.getSpaceService().getVisibleSpacesWithListAccess(userId, spaceFilter));
        }
        this.setSpacesNum(this.getSpacesListAccess().getSize());
        this.uiSpaceSearch.setSpaceNum(this.getSpacesNum());
        Space[] spaces = (Space[])this.getSpacesListAccess().load(index, length);
        return new ArrayList<Space>(Arrays.asList(spaces));
    }

    public boolean hasEditPermission(Space space) throws Exception {
        return this.spaceService.hasSettingPermission(space, this.getUserId());
    }

    protected boolean hasAccessPermission(Space space) throws Exception {
        return this.spaceService.hasAccessPermission(space, this.getUserId());
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public static class IgnoreInvitationActionListener
    extends EventListener<UIManageAllSpaces> {
        public void execute(Event<UIManageAllSpaces> event) throws Exception {
            UIManageAllSpaces uiManageAllSpaces = (UIManageAllSpaces)((Object)event.getSource());
            SpaceService spaceService = Utils.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = Utils.getViewerRemoteId();
            Space space = spaceService.getSpaceById(spaceId);
            uiManageAllSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isInvitedUser(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            spaceService.removeInvitedUser(space, userId);
            uiManageAllSpaces.setHasUpdatedSpace(true);
        }
    }

    public static class AcceptInvitationActionListener
    extends EventListener<UIManageAllSpaces> {
        public void execute(Event<UIManageAllSpaces> event) throws Exception {
            UIManageAllSpaces uiManageAllSpaces = (UIManageAllSpaces)((Object)event.getSource());
            SpaceService spaceService = Utils.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = Utils.getViewerRemoteId();
            Space space = spaceService.getSpaceById(spaceId);
            uiManageAllSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isInvitedUser(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            spaceService.addMember(space, userId);
            uiManageAllSpaces.setHasUpdatedSpace(true);
            SpaceUtils.updateWorkingWorkSpace();
            JavascriptManager jsManager = ctx.getJavascriptManager();
            jsManager.addJavascript((CharSequence)("try { window.location.href='" + Utils.getSpaceHomeURL(space) + "' } catch(e) {" + "window.location.href('" + Utils.getSpaceHomeURL(space) + "') }"));
        }
    }

    public static class CancelInvitationActionListener
    extends EventListener<UIManageAllSpaces> {
        public void execute(Event<UIManageAllSpaces> event) throws Exception {
            UIManageAllSpaces uiManageAllSpaces = (UIManageAllSpaces)((Object)event.getSource());
            SpaceService spaceService = uiManageAllSpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiManageAllSpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            uiManageAllSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            spaceService.removePendingUser(space, userId);
            uiManageAllSpaces.setHasUpdatedSpace(true);
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiManageAllSpaces);
        }
    }

    public static class LeaveSpaceActionListener
    extends EventListener<UIManageAllSpaces> {
        public void execute(Event<UIManageAllSpaces> event) throws Exception {
            UIManageAllSpaces uiManageAllSpaces = (UIManageAllSpaces)((Object)event.getSource());
            SpaceService spaceService = uiManageAllSpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiManageAllSpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            uiManageAllSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isMember(space, userId) && !spaceService.hasSettingPermission(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.MEMBERSHIP_REMOVED_INFO, null, 2));
                return;
            }
            if (spaceService.isOnlyManager(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.MSG_WARNING_LEAVE_SPACE, null, 1));
                return;
            }
            spaceService.removeMember(space, userId);
            uiManageAllSpaces.setHasUpdatedSpace(true);
            spaceService.setManager(space, userId, false);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    public static class DeleteSpaceActionListener
    extends EventListener<UIManageAllSpaces> {
        public void execute(Event<UIManageAllSpaces> event) throws Exception {
            UIManageAllSpaces uiManageAllSpaces = (UIManageAllSpaces)((Object)event.getSource());
            SpaceService spaceService = uiManageAllSpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            Space space = spaceService.getSpaceById(spaceId);
            String userId = uiManageAllSpaces.getUserId();
            uiManageAllSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isMember(space, userId) && !spaceService.hasSettingPermission(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.MEMBERSHIP_REMOVED_INFO, null, 2));
                return;
            }
            uiManageAllSpaces.setHasUpdatedSpace(true);
            spaceService.deleteSpace(space);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    public static class RequestToJoinActionListener
    extends EventListener<UIManageAllSpaces> {
        public void execute(Event<UIManageAllSpaces> event) throws Exception {
            UIManageAllSpaces uiManageAllSpaces = (UIManageAllSpaces)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            SpaceService spaceService = uiManageAllSpaces.getSpaceService();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiManageAllSpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            uiManageAllSpaces.setLoadAtEnd(false);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageAllSpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            spaceService.addPendingUser(space, userId);
            uiManageAllSpaces.setHasUpdatedSpace(true);
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiManageAllSpaces);
        }
    }

    public static class SearchActionListener
    extends EventListener<UIManageAllSpaces> {
        public void execute(Event<UIManageAllSpaces> event) throws Exception {
            UIManageAllSpaces uiManageAllSpaces = (UIManageAllSpaces)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            String charSearch = ctx.getRequestParameter("objectId");
            if (charSearch == null) {
                uiManageAllSpaces.setSelectedChar(UIManageAllSpaces.SEARCH_ALL);
            } else {
                ResourceBundle resApp = ctx.getApplicationResourceBundle();
                String defaultSpaceNameAndDesc = resApp.getString(uiManageAllSpaces.getId() + ".label.DefaultSpaceNameAndDesc");
                uiManageAllSpaces.uiSpaceSearch.getUIStringInput(UIManageAllSpaces.SPACE_SEARCH).setValue((Object)defaultSpaceNameAndDesc);
                uiManageAllSpaces.setSelectedChar(charSearch);
            }
            uiManageAllSpaces.loadSearch();
            uiManageAllSpaces.setLoadAtEnd(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManageAllSpaces);
        }
    }

    public static class LoadMoreSpaceActionListener
    extends EventListener<UIManageAllSpaces> {
        public void execute(Event<UIManageAllSpaces> event) throws Exception {
            UIManageAllSpaces uiManageAllSpaces = (UIManageAllSpaces)((Object)event.getSource());
            if (uiManageAllSpaces.currentLoadIndex > uiManageAllSpaces.spacesNum) {
                return;
            }
            uiManageAllSpaces.loadNext();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManageAllSpaces);
        }
    }

    public static enum TypeOfSpace {
        INVITED,
        SENT,
        NONE,
        MEMBER,
        MANAGER;

    }
}

