/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space.access;

import java.io.IOException;
import java.util.Collection;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.SpaceAccessType;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SpaceAccessApplicationLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final Log LOG = ExoLogger.getLogger(SpaceAccessApplicationLifecycle.class);

    public void onInit(Application app) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        if (pcontext.isResponseComplete()) {
            return;
        }
        String siteName = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME);
        String siteType = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_TYPE);
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        Utils.setCurrentNavigationData(siteType, siteName, requestPath);
        String spacePrettyName = "";
        SpaceAccessApplicationLifecycle spaceAccessApplicationLifecycle = this;
        synchronized (spaceAccessApplicationLifecycle) {
            ExoRouter.Route route = ExoRouter.route((String)requestPath);
            if (route == null) {
                return;
            }
            spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        }
        if (pcontext.getSiteType().equals((Object)SiteType.GROUP) && pcontext.getSiteName().startsWith("/spaces") && spacePrettyName != null && spacePrettyName.length() > 0) {
            Space space = Utils.getSpaceService().getSpaceByPrettyName(spacePrettyName);
            String remoteId = Utils.getViewerRemoteId();
            if (space != null && remoteId != null) {
                this.addMembershipToIdentity(remoteId, space);
                if (Utils.getSpaceService().isSuperManager(remoteId) || SpaceUtils.isUserHasMembershipTypesInGroup((String)remoteId, (String)space.getGroupId(), (String)"*")) {
                    return;
                }
            }
            this.processSpaceAccess(pcontext, remoteId, space);
        }
    }

    private void addMembershipToIdentity(String remoteId, Space space) {
        IdentityRegistry identityRegistry = (IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(remoteId);
        if (identity != null) {
            SpaceService spaceService = Utils.getSpaceService();
            boolean isSuperManager = spaceService.isSuperManager(remoteId);
            boolean isManager = spaceService.isManager(space, remoteId);
            boolean isMember = spaceService.isMember(space, remoteId);
            MembershipEntry memberMembership = new MembershipEntry(space.getGroupId(), "member");
            MembershipEntry managerMembership = new MembershipEntry(space.getGroupId(), "manager");
            Collection memberships = identity.getMemberships();
            if (isMember || isSuperManager) {
                memberships.add(memberMembership);
            } else {
                memberships.remove(memberMembership);
            }
            if (isManager || isSuperManager) {
                memberships.add(managerMembership);
            } else {
                memberships.remove(managerMembership);
            }
        }
    }

    private void processSpaceAccess(PortalRequestContext pcontext, String remoteId, Space space) throws IOException {
        boolean gotStatus = SpaceAccessType.SPACE_NOT_FOUND.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.SPACE_NOT_FOUND, null);
            return;
        }
        gotStatus = SpaceAccessType.NO_AUTHENTICATED.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.NO_AUTHENTICATED, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.INVITED_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.INVITED_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.REQUESTED_JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.REQUESTED_JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.REQUEST_JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.REQUEST_JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.CLOSED_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.CLOSED_SPACE, space.getPrettyName());
            return;
        }
    }

    private void sendRedirect(PortalRequestContext pcontext, SpaceAccessType type, String spacePrettyName) throws IOException {
        String url = Utils.getURI("space-access");
        LOG.info((Object)type.toString());
        String requestPath = pcontext.getRequestURI();
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.type.key", (Object)type);
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.key", (Object)spacePrettyName);
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.request.path.key", (Object)requestPath);
        pcontext.setResponseComplete(true);
        pcontext.sendRedirect(url);
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) throws Exception {
    }
}

