/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.UISocialGroupSelector;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceGroupBound;
import org.exoplatform.social.webui.space.UISpaceSettings;
import org.exoplatform.social.webui.space.UISpaceVisibility;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={UIFormTabPane.SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CreateActionListener.class}), @EventConfig(listeners={ToggleUseGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeOptionActionListener.class}, phase=Event.Phase.DECODE)})
public class UISpaceAddForm
extends UIFormTabPane {
    private static final Log LOG = ExoLogger.getLogger(UISpaceAddForm.class);
    private static final String MSG_ERROR_SPACE_CREATION = "UISpaceAddForm.msg.error_space_creation";
    private static final String MSG_ERROR_DATASTORE = "UISpaceAddForm.msg.error_space_not_saved";
    private static final String MSG_ERROR_UNABLE_TO_INIT_APP = "UISpaceAddForm.msg.error_unable_to_init_app";
    private static final String MSG_ERROR_UNABLE_TO_ADD_CREATOR = "UISpaceAddForm.msg.error_unable_to_add_creator";
    private static final String MSG_ERROR_UNABLE_TO_ADD_APPLICATION = "UISpaceAddForm.msg.error_unable_to_add_application";
    private static final String MSG_ERROR_RETRIEVING_USER = "UISpaceAddForm.msg.error_unable_to_retrieve_user";
    private static final String MSG_SPACE_CREATION_SUCCESS = "UISpaceAddForm.msg.space_creation_success";
    private static final String MSG_ERROR_SPACE_ALREADY_EXIST = "UISpaceAddForm.msg.error_space_already_exist";
    private final String SPACE_SETTINGS = "UISpaceSettings";
    private final String SPACE_VISIBILITY = "UISpaceVisibility";

    public UISpaceAddForm() throws Exception {
        super("UISpaceAddForm");
        UISpaceSettings uiSpaceSettings = new UISpaceSettings("UISpaceSettings");
        this.addChild((UIComponent)uiSpaceSettings);
        UISpaceVisibility uiSpaceVisibility = new UISpaceVisibility("UISpaceVisibility");
        this.addChild((UIComponent)uiSpaceVisibility);
        this.addChild(UISpaceGroupBound.class, null, null);
        this.setActions(new String[]{"Create"});
        this.setSelectedTab(1);
    }

    public String getLabel(ResourceBundle res, String key) {
        return new StringBuffer(super.getLabel(res, key)).append(key.indexOf("action.") < 0 ? ":" : "").toString();
    }

    public static class ChangeOptionActionListener
    extends EventListener<UISpaceAddForm> {
        private final String VISIBLE_OPEN_SPACE = "UISpaceVisibility.label.VisibleAndOpenSpace";
        private final String VISIBLE_VALIDATION_SPACE = "UISpaceVisibility.label.VisibleAndValidationSpace";
        private final String VISIBLE_CLOSE_SPACE = "UISpaceVisibility.label.VisibleAndCloseSpace";
        private final String HIDDEN_SPACE = "UISpaceVisibility.label.HiddenSpace";

        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiSpaceAddForm = (UISpaceAddForm)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String visibleAndOpenSpace = resApp.getString("UISpaceVisibility.label.VisibleAndOpenSpace");
            String visibleAndValidationSpace = resApp.getString("UISpaceVisibility.label.VisibleAndValidationSpace");
            String visibleAndCloseSpace = resApp.getString("UISpaceVisibility.label.VisibleAndCloseSpace");
            String hiddenSpace = resApp.getString("UISpaceVisibility.label.HiddenSpace");
            UIFormInputSet uiSpaceVisibility = (UIFormInputSet)uiSpaceAddForm.getChildById("UISpaceVisibility");
            UIFormRadioBoxInput selectPriority = (UIFormRadioBoxInput)uiSpaceVisibility.getChildById("UIVisibility");
            UIFormRadioBoxInput selectRegistration = (UIFormRadioBoxInput)uiSpaceVisibility.getChildById("UIRegistration");
            UIFormInputInfo uiFormInfo = (UIFormInputInfo)uiSpaceVisibility.getChild(UIFormInputInfo.class);
            String currentVisibility = (String)selectPriority.getValue();
            String currentRegistration = (String)selectRegistration.getValue();
            boolean isPrivate = "private".equals(currentVisibility);
            boolean isOpen = "open".equals(currentRegistration);
            boolean isValidation = "validation".equals(currentRegistration);
            boolean isClose = "close".equals(currentRegistration);
            if (isPrivate && isOpen) {
                uiFormInfo.setValue((Object)visibleAndOpenSpace);
            } else if (isPrivate && isValidation) {
                uiFormInfo.setValue((Object)visibleAndValidationSpace);
            } else if (isPrivate && isClose) {
                uiFormInfo.setValue((Object)visibleAndCloseSpace);
            } else {
                uiFormInfo.setValue((Object)hiddenSpace);
            }
        }
    }

    public static class ToggleUseGroupActionListener
    extends EventListener<UISpaceAddForm> {
        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiSpaceAddForm = (UISpaceAddForm)((Object)event.getSource());
            UISpaceGroupBound uiSpaceGroupBound = (UISpaceGroupBound)uiSpaceAddForm.getChild(UISpaceGroupBound.class);
            UICheckBoxInput uiUseExistingGroup = (UICheckBoxInput)uiSpaceGroupBound.getChild(UICheckBoxInput.class);
            if (uiUseExistingGroup.isChecked()) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceGroupBound.getChild(UIPopupWindow.class);
                UISocialGroupSelector uiGroupSelector = (UISocialGroupSelector)uiSpaceAddForm.createUIComponent(UISocialGroupSelector.class, null, null);
                uiPopup.setUIComponent((UIComponent)uiGroupSelector);
                uiPopup.setShowMask(true);
                uiPopup.setShow(true);
            } else {
                UIFormInputInfo uiFormInputInfo = (UIFormInputInfo)uiSpaceGroupBound.getChild(UIFormInputInfo.class);
                uiFormInputInfo.setValue(null);
            }
        }
    }

    public static class CreateActionListener
    extends EventListener<UISpaceAddForm> {
        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiAddForm = (UISpaceAddForm)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApplication = ctx.getUIApplication();
            SpaceService spaceService = (SpaceService)uiAddForm.getApplicationComponent(SpaceService.class);
            UISpaceGroupBound uiGroupBound = (UISpaceGroupBound)uiAddForm.getChild(UISpaceGroupBound.class);
            String selectedGroup = uiGroupBound.getSelectedGroup();
            String creator = ctx.getRemoteUser();
            Space space = new Space();
            uiAddForm.invokeSetBindingBean(space);
            space.setDisplayName(space.getDisplayName().trim());
            String spaceDisplayName = (String)uiAddForm.getUIStringInput("displayName").getValue();
            String spaceDescription = (String)uiAddForm.getUIFormTextAreaInput("description").getValue();
            space.setDisplayName(spaceDisplayName.trim());
            space.setDescription(StringEscapeUtils.escapeHtml((String)spaceDescription));
            space.setPrettyName(space.getDisplayName());
            String msg = UISpaceAddForm.MSG_SPACE_CREATION_SUCCESS;
            try {
                Space got;
                SpaceUtils.checkUserExisting((String)ctx.getRemoteUser());
                if (spaceService.getSpaceByDisplayName(space.getDisplayName()) != null) {
                    throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
                }
                String prettyName = space.getPrettyName();
                int count = 1;
                while ((got = spaceService.getSpaceByPrettyName(prettyName)) != null) {
                    if (count == 1 && got.getDisplayName().equalsIgnoreCase(space.getDisplayName())) {
                        throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
                    }
                    prettyName = space.getPrettyName() + "_" + count;
                    ++count;
                }
                space.setPrettyName(prettyName);
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
                Identity identity = idm.getOrCreateIdentity("space", space.getPrettyName(), true);
                if (identity != null) {
                    space.setPrettyName(SpaceUtils.buildPrettyName((Space)space));
                }
                space.setType("classic");
                space = selectedGroup != null ? spaceService.createSpace(space, creator, selectedGroup) : spaceService.createSpace(space, creator);
            }
            catch (SpaceException se) {
                if (se.getCode() == SpaceException.Code.SPACE_ALREADY_EXIST) {
                    msg = UISpaceAddForm.MSG_ERROR_SPACE_ALREADY_EXIST;
                    uiApplication.addMessage(new ApplicationMessage(msg, null, 1));
                    return;
                }
                msg = se.getCode() == SpaceException.Code.UNABLE_TO_ADD_CREATOR ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_ADD_CREATOR : (se.getCode() == SpaceException.Code.ERROR_DATASTORE ? UISpaceAddForm.MSG_ERROR_DATASTORE : (se.getCode() == SpaceException.Code.UNABLE_TO_INIT_APP ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_INIT_APP : (se.getCode() == SpaceException.Code.UNABLE_TO_ADD_APPLICATION ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_ADD_APPLICATION : (se.getCode() == SpaceException.Code.ERROR_RETRIEVING_USER ? UISpaceAddForm.MSG_ERROR_RETRIEVING_USER : UISpaceAddForm.MSG_ERROR_SPACE_CREATION))));
                LOG.error((Object)"Failed to create a new space", (Throwable)se);
                uiApplication.addMessage(new ApplicationMessage(msg, null, 0));
                return;
            }
            SpaceUtils.endRequest();
            UIPopupWindow uiPopup = (UIPopupWindow)uiAddForm.getParent();
            uiPopup.setUIComponent(null);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            Utils.updateWorkingWorkSpace();
            JavascriptManager jsManager = ctx.getJavascriptManager();
            jsManager.addJavascript((CharSequence)("try { window.location.href='" + Utils.getSpaceHomeURL(space) + "' } catch(e) {window.location.href('" + Utils.getSpaceHomeURL(space) + "') }"));
        }
    }
}

