/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.webui.UIFilterableTree;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfigs(value={@ComponentConfig(template="war:/groovy/social/webui/space/UISocialGroupSelector.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={ChangeNodeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectGroupActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectPathActionListener.class})}), @ComponentConfig(type=UIFilterableTree.class, id="UITreeGroupSelector", template="war:/groovy/social/webui/UIFilterableTree.gtmpl", events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbGroupSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={UIBreadcumbs.SelectPathActionListener.class})})})
public class UIUsersInGroupSelector
extends UIContainer {
    public static final String MANAGER = "manager";
    private static Log LOG = ExoLogger.getLogger(UIUsersInGroupSelector.class);
    private Group selectGroup_;
    private String currentGroupId;

    public UIUsersInGroupSelector() throws Exception {
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.addChild(UIBreadcumbs.class, "BreadcumbGroupSelector", "BreadcumbGroupSelector");
        UITree tree = (UITree)this.addChild(UIFilterableTree.class, "UITreeGroupSelector", "TreeGroupSelector");
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        Collection sibblingsGroup = service.getGroupHandler().findGroups(null);
        tree.setSibbling(sibblingsGroup);
        tree.setIcon("GroupAdminIcon");
        tree.setSelectedIcon("PortalIcon");
        tree.setBeanIdField("id");
        tree.setBeanLabelField("label");
        uiBreadcumbs.setBreadcumbsStyle("UIExplorerHistoryPath");
        this.setupFilterableTree();
    }

    public Group getCurrentGroup() {
        return this.selectGroup_;
    }

    public String getCurrentGroupId() {
        return this.currentGroupId;
    }

    public void setCurrentGroupId(String currentGroupId) {
        this.currentGroupId = currentGroupId;
    }

    public List<String> getListGroup() throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        ArrayList<String> listGroup = new ArrayList<String>();
        RequestContext reqCtx = RequestContext.getCurrentInstance();
        String remoteUser = reqCtx.getRemoteUser();
        if (this.getCurrentGroup() == null) {
            return null;
        }
        Collection groups = service.getGroupHandler().findGroups(this.getCurrentGroup());
        groups.remove(service.getGroupHandler().findGroupById(this.getCurrentGroupId()));
        if (groups.size() > 0) {
            for (Group childGroup : groups) {
                Membership membership = service.getMembershipHandler().findMembershipByUserGroupAndType(remoteUser, childGroup.getId(), MANAGER);
                if (membership == null) continue;
                listGroup.add(childGroup.getId());
            }
        }
        return listGroup;
    }

    public String event(String name, String beanId) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        if (uiForm != null) {
            return uiForm.event(name, this.getId(), beanId);
        }
        return super.event(name, beanId);
    }

    private void changeGroup(String groupId) throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        uiBreadcumb.setPath(this.getPath(null, groupId));
        UITree tree = (UITree)this.getChild(UIFilterableTree.class);
        if (groupId == null) {
            Collection sibblingGroup = service.getGroupHandler().findGroups(null);
            tree.setSibbling((Collection)((List)sibblingGroup));
            tree.setChildren(null);
            tree.setSelected(null);
            this.selectGroup_ = null;
            return;
        }
        this.selectGroup_ = service.getGroupHandler().findGroupById(groupId);
        String parentGroupId = null;
        if (this.selectGroup_ != null) {
            parentGroupId = this.selectGroup_.getParentId();
        }
        Group parentGroup = null;
        if (parentGroupId != null) {
            parentGroup = service.getGroupHandler().findGroupById(parentGroupId);
        }
        Collection childrenGroup = service.getGroupHandler().findGroups(this.selectGroup_);
        Group currentAccessedGroup = service.getGroupHandler().findGroupById(this.getCurrentGroupId());
        childrenGroup.remove(currentAccessedGroup);
        Collection sibblingGroup = service.getGroupHandler().findGroups(parentGroup);
        sibblingGroup.remove(currentAccessedGroup);
        tree.setSibbling((Collection)((List)sibblingGroup));
        tree.setChildren((Collection)((List)childrenGroup));
        tree.setSelected((Object)this.selectGroup_);
        tree.setParentSelected((Object)parentGroup);
        this.setupFilterableTree();
    }

    private List<UIBreadcumbs.LocalPath> getPath(List<UIBreadcumbs.LocalPath> list, String id) throws Exception {
        if (list == null) {
            list = new ArrayList<UIBreadcumbs.LocalPath>(5);
        }
        if (id == null) {
            return list;
        }
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        Group group = service.getGroupHandler().findGroupById(id);
        if (group == null) {
            return list;
        }
        list.add(0, new UIBreadcumbs.LocalPath(group.getId(), group.getGroupName()));
        this.getPath(list, group.getParentId());
        return list;
    }

    private void setupFilterableTree() {
        UIFilterableTree.TreeNodeFilter nodeFilter = new UIFilterableTree.TreeNodeFilter(){

            @Override
            public boolean filterThisNode(Object nodeObject, WebuiRequestContext context) {
                String remoteUser = context.getRemoteUser();
                OrganizationService orgService = (OrganizationService)UIUsersInGroupSelector.this.getApplicationComponent(OrganizationService.class);
                if (remoteUser == null) {
                    return true;
                }
                if (!(nodeObject instanceof Group)) {
                    return true;
                }
                Group group = (Group)nodeObject;
                Membership membership = null;
                try {
                    membership = orgService.getMembershipHandler().findMembershipByUserGroupAndType(remoteUser, group.getId(), UIUsersInGroupSelector.MANAGER);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error when finding membership for filtering tree node", (Throwable)e);
                }
                if (membership != null) {
                    return false;
                }
                List groups = null;
                try {
                    groups = (List)orgService.getGroupHandler().findGroups(group);
                    boolean existMembership = this.checkMembershipOfChildren(groups, orgService, remoteUser);
                    for (Group childGroup : groups) {
                        if (existMembership) continue;
                        List childGroups = null;
                        childGroups = (List)orgService.getGroupHandler().findGroups(childGroup);
                        boolean hasMembership = this.checkMembershipOfChildren(childGroups, orgService, remoteUser);
                        if (!hasMembership) continue;
                        return !hasMembership;
                    }
                    return !existMembership;
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error when filtering tree node", (Throwable)e);
                    return true;
                }
            }

            private boolean checkMembershipOfChildren(List<Group> groups, OrganizationService orgService, String remoteUser) {
                Membership membership = null;
                for (Group group : groups) {
                    try {
                        membership = orgService.getMembershipHandler().findMembershipByUserGroupAndType(remoteUser, group.getId(), UIUsersInGroupSelector.MANAGER);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error when filtering tree node", (Throwable)e);
                    }
                    if (membership == null) continue;
                    return true;
                }
                return false;
            }
        };
        ((UIFilterableTree)this.getChild(UIFilterableTree.class)).setTreeNodeFilter(nodeFilter);
    }

    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UIUsersInGroupSelector uiSelector = (UIUsersInGroupSelector)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiSelector.changeGroup(selectGroupId);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSelector.getParent();
            uiPopup.setShow(true);
            UIForm uiForm = (UIForm)((UIBreadcumbs)event.getSource()).getAncestorOfType(UIForm.class);
            if (uiForm != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
            }
        }
    }

    public static class SelectGroupActionListener
    extends EventListener<UIUsersInGroupSelector> {
        public void execute(Event<UIUsersInGroupSelector> event) throws Exception {
            UIUsersInGroupSelector uiSelector = (UIUsersInGroupSelector)((Object)event.getSource());
            WebuiRequestContext pcontext = event.getRequestContext();
            UIPopupWindow uiPopup = (UIPopupWindow)uiSelector.getParent();
            UIForm uiForm = (UIForm)((UIUsersInGroupSelector)((Object)event.getSource())).getAncestorOfType(UIForm.class);
            if (uiForm != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
            }
            if (uiSelector.getCurrentGroup() == null) {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIGroupSelector.msg.selectGroup", null));
                uiPopup.setShow(true);
                return;
            }
            uiSelector.getParent().broadcast(event, event.getExecutionPhase());
            uiPopup.setShow(false);
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UIFilterableTree> {
        public void execute(Event<UIFilterableTree> event) throws Exception {
            UIUsersInGroupSelector uiGroupSelector = (UIUsersInGroupSelector)((UIFilterableTree)((Object)event.getSource())).getAncestorOfType(UIUsersInGroupSelector.class);
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            uiGroupSelector.changeGroup(groupId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiGroupSelector);
        }
    }
}

