/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.AbstractActivitiesDisplay;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.activity.UIActivitiesLoader;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormTextAreaInput;

public class BaseUIActivity
extends UIForm {
    protected static final int LIKES_NUM_DEFAULT = 0;
    private static final Log LOG = ExoLogger.getLogger(BaseUIActivity.class);
    private static final int DEFAULT_LIMIT = 10;
    private static final String HTML_AT_SYMBOL_PATTERN = "@";
    private static final String HTML_AT_SYMBOL_ESCAPED_PATTERN = "&#64;";
    private static final String HTML_ATTRIBUTE_TITLE = "title";
    public static final String TEMPLATE_PARAM_COMMENT = "comment";
    public static final String COMPOSER_TEXT_AREA_EDIT_INPUT = "composerEditInput";
    private static int LATEST_COMMENTS_SIZE = 2;
    private int commentMinCharactersAllowed = 0;
    private int commentMaxCharactersAllowed = 100;
    private int commentSize = 0;
    private int loadCapacity;
    private int currentLoadIndex = 0;
    private RealtimeListAccess<ExoSocialActivity> activityCommentsListAccess;
    private ExoSocialActivity activity;
    private Identity ownerIdentity;
    private String[] identityLikes;
    private boolean commentFormDisplayed = false;
    private boolean allLoaded = false;
    private CommentStatus commentListStatus = CommentStatus.LATEST;
    private boolean allCommentsHidden = false;
    private boolean commentFormFocused = false;
    private String updatedCommentId;
    private ActivityManager activityManager;

    public BaseUIActivity() {
        this.setSubmitAction("return false;");
    }

    public RealtimeListAccess<ExoSocialActivity> getActivityCommentsListAccess() {
        return this.activityCommentsListAccess;
    }

    public void setActivityCommentsListAccess(RealtimeListAccess<ExoSocialActivity> activityCommentsListAccess) {
        this.activityCommentsListAccess = activityCommentsListAccess;
        this.commentSize = activityCommentsListAccess.getSize();
    }

    public String getSpaceGroupId() {
        Space space = SpaceUtils.getSpaceByContext();
        return space == null ? "" : space.getGroupId();
    }

    public String getSpaceURL() {
        String spaceURL = SpaceUtils.getSpaceUrlByContext();
        return spaceURL;
    }

    public int getCurrentLoadIndex() {
        return this.currentLoadIndex;
    }

    public int getLoadCapacity() {
        return this.loadCapacity;
    }

    public void setLoadCapacity(int loadCapacity) {
        this.loadCapacity = loadCapacity;
    }

    public ExoSocialActivity getActivity() {
        return this.activity;
    }

    public void setActivity(ExoSocialActivity activity) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        this.activity = activity;
        Identity identity = Utils.getIdentityManager().getIdentity(activity.getUserId(), true);
        this.setOwnerIdentity(identity);
        UIFormTextAreaInput commentTextArea = new UIFormTextAreaInput("CommentTextarea" + activity.getId(), "CommentTextarea", null);
        commentTextArea.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("BaseUIActivity.label.Add_your_comment"));
        this.addChild((UIComponent)commentTextArea);
        UIFormTextAreaInput messageInput = new UIFormTextAreaInput(COMPOSER_TEXT_AREA_EDIT_INPUT + activity.getId(), COMPOSER_TEXT_AREA_EDIT_INPUT, null);
        this.addChild((UIComponent)messageInput);
        try {
            this.refresh();
        }
        catch (ActivityStorageException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public int getCommentMinCharactersAllowed() {
        return this.commentMinCharactersAllowed;
    }

    public void setCommentMinCharactersAllowed(int num) {
        this.commentMinCharactersAllowed = num;
    }

    public int getCommentMaxCharactersAllowed() {
        return this.commentMaxCharactersAllowed;
    }

    public void setCommentMaxCharactersAllowed(int num) {
        this.commentMaxCharactersAllowed = num;
    }

    public boolean isCommentFormDisplayed() {
        return this.commentFormDisplayed;
    }

    public void setCommentFormDisplayed(boolean commentFormDisplayed) {
        this.commentFormDisplayed = commentFormDisplayed;
    }

    public boolean isAllLoaded() {
        return this.allLoaded;
    }

    public void setAllLoaded(boolean allLoaded) {
        this.allLoaded = allLoaded;
    }

    public boolean isAllCommentsHidden() {
        return this.allCommentsHidden;
    }

    public void setAllCommentsHidden(boolean allCommentsHidden) {
        this.allCommentsHidden = allCommentsHidden;
    }

    public boolean isCommentFormFocused() {
        return this.commentFormFocused;
    }

    public void setCommentFormFocused(boolean commentFormFocused) {
        this.commentFormFocused = commentFormFocused;
    }

    public CommentStatus getCommentListStatus() {
        return this.commentListStatus == null ? CommentStatus.NONE : this.commentListStatus;
    }

    public void setCommentListStatus(CommentStatus status) {
        this.commentListStatus = status;
        if (status == CommentStatus.ALL) {
            this.commentFormDisplayed = true;
        }
    }

    public boolean commentListToggleable() {
        return this.commentSize > LATEST_COMMENTS_SIZE;
    }

    public List<ExoSocialActivity> getComments() {
        if (this.commentSize == 0) {
            return new ArrayList<ExoSocialActivity>();
        }
        List comments = new ArrayList();
        if (this.commentListStatus == CommentStatus.ALL) {
            if (this.currentLoadIndex == 0) {
                this.currentLoadIndex = this.commentSize - 10 - LATEST_COMMENTS_SIZE;
                this.loadCapacity = 10 + LATEST_COMMENTS_SIZE;
            } else {
                this.currentLoadIndex -= 10;
            }
            if (this.currentLoadIndex < 0) {
                this.currentLoadIndex = 0;
            }
            comments = this.activityCommentsListAccess.loadAsList(this.currentLoadIndex, this.loadCapacity);
            if (this.currentLoadIndex > 0) {
                this.loadCapacity += this.currentLoadIndex;
            }
        } else {
            if (this.commentListStatus == CommentStatus.NONE) {
                return comments != null ? comments : new ArrayList();
            }
            comments = this.commentSize > LATEST_COMMENTS_SIZE ? this.activityCommentsListAccess.loadAsList(this.commentSize - LATEST_COMMENTS_SIZE, LATEST_COMMENTS_SIZE) : this.activityCommentsListAccess.loadAsList(0, this.commentSize >= 10 ? 10 : this.commentSize);
        }
        return this.getI18N(comments);
    }

    public int getParentCommentsSize(List<ExoSocialActivity> comments) {
        int count = 0;
        for (ExoSocialActivity exoSocialActivity : comments) {
            if (exoSocialActivity.getParentCommentId() != null) continue;
            ++count;
        }
        return count;
    }

    public int getSubCommentsSize(List<ExoSocialActivity> comments, String commentActivityId) {
        if (StringUtils.isBlank((CharSequence)commentActivityId)) {
            return 0;
        }
        int count = 0;
        for (ExoSocialActivity exoSocialActivity : comments) {
            if (!StringUtils.equals((CharSequence)exoSocialActivity.getParentCommentId(), (CharSequence)commentActivityId)) continue;
            ++count;
        }
        return count;
    }

    public boolean isSubCommentOfComment(List<ExoSocialActivity> comments, String commentId, String subCommentId) {
        if (StringUtils.isBlank((CharSequence)commentId) || StringUtils.isBlank((CharSequence)subCommentId)) {
            return false;
        }
        for (ExoSocialActivity exoSocialActivity : comments) {
            if (!StringUtils.equals((CharSequence)exoSocialActivity.getId(), (CharSequence)subCommentId) || !StringUtils.equals((CharSequence)exoSocialActivity.getParentCommentId(), (CharSequence)commentId)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public List<ExoSocialActivity> getAllComments() {
        return this.activityCommentsListAccess.loadAsList(0, this.activityCommentsListAccess.getSize());
    }

    public int getAllCommentSize() {
        return this.activityCommentsListAccess.getSize();
    }

    public String[] getIdentityLikes() {
        return this.identityLikes;
    }

    public String[] getDisplayedIdentityLikes() throws Exception {
        ArrayUtils.reverse((Object[])this.identityLikes);
        return this.identityLikes;
    }

    public void setIdenityLikes(String[] identityLikes) {
        this.identityLikes = identityLikes;
    }

    public String event(String actionName, String callback, boolean updateForm) throws Exception {
        if (updateForm) {
            return super.url(actionName);
        }
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append(this.getFormId()).append("','");
        b.append(actionName).append("',");
        b.append("true").append(",");
        b.append(callback).append(")");
        return b.toString();
    }

    public String getPostedTimeString(WebuiBindingContext resourceBundle, long postedTime) throws Exception {
        long time = (new Date().getTime() - postedTime) / 1000L;
        if (time < 60L) {
            return resourceBundle.appRes("UIActivity.label.Less_Than_A_Minute");
        }
        if (time < 120L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Minute");
        }
        if (time < 3600L) {
            long value = Math.round(time / 60L);
            return resourceBundle.appRes("UIActivity.label.About_?_Minutes").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 7200L) {
            return resourceBundle.appRes("UIActivity.label.About_An_Hour");
        }
        if (time < 86400L) {
            long value = Math.round(time / 3600L);
            return resourceBundle.appRes("UIActivity.label.About_?_Hours").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 172800L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Day");
        }
        if (time < 2592000L) {
            long value = Math.round(time / 86400L);
            return resourceBundle.appRes("UIActivity.label.About_?_Days").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 5184000L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Month");
        }
        long value = Math.round(time / 2592000L);
        return resourceBundle.appRes("UIActivity.label.About_?_Months").replaceFirst("\\{0\\}", String.valueOf(value));
    }

    public String getPostedTimeInSpaceString(WebuiBindingContext resourceBundle, long postedTime) throws Exception {
        long time = (new Date().getTime() - postedTime) / 1000L;
        if (time < 60L) {
            return resourceBundle.appRes("UIActivity.label.Less_Than_A_Minute_In_Space");
        }
        if (time < 120L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Minute_In_Space");
        }
        if (time < 3600L) {
            long value = Math.round(time / 60L);
            return resourceBundle.appRes("UIActivity.label.About_?_Minutes_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 7200L) {
            return resourceBundle.appRes("UIActivity.label.About_An_Hour_In_Space");
        }
        if (time < 86400L) {
            long value = Math.round(time / 3600L);
            return resourceBundle.appRes("UIActivity.label.About_?_Hours_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 172800L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Day_In_Space");
        }
        if (time < 2592000L) {
            long value = Math.round(time / 86400L);
            return resourceBundle.appRes("UIActivity.label.About_?_Days_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
        }
        if (time < 5184000L) {
            return resourceBundle.appRes("UIActivity.label.About_A_Month_In_Space");
        }
        long value = Math.round(time / 2592000L);
        return resourceBundle.appRes("UIActivity.label.About_?_Months_In_Space").replaceFirst("\\{0\\}", String.valueOf(value));
    }

    private String getFormId() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            return ((PortletRequestContext)context).getWindowId() + "#" + this.getId();
        }
        return this.getId();
    }

    protected ExoSocialActivity saveComment(String remoteUser, String message, String commentId) throws Exception {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl(Utils.getViewerIdentity().getId(), "exosocial:spaces", message, null);
        if (StringUtils.isNotBlank((CharSequence)commentId) && commentId.startsWith(TEMPLATE_PARAM_COMMENT)) {
            comment.setParentCommentId(commentId);
        }
        Utils.getActivityManager().saveComment(this.getActivity(), (ExoSocialActivity)comment);
        this.activityCommentsListAccess = Utils.getActivityManager().getCommentsWithListAccess(this.getActivity(), true);
        this.commentSize = this.activityCommentsListAccess.getSize();
        this.currentLoadIndex = 0;
        this.updatedCommentId = commentId;
        this.setCommentListStatus(CommentStatus.ALL);
        return comment;
    }

    protected void editActivity(String message) {
        this.getActivity().setTitle(message);
        this.getActivity().setUpdated(new Date());
        Utils.getActivityManager().updateActivity(this.getActivity());
    }

    protected ExoSocialActivity editCommentMessage(ExoSocialActivity commentActivity, String message) {
        commentActivity.setTitle(message);
        commentActivity.setUpdated(new Date());
        Utils.getActivityManager().saveComment(this.getActivity(), commentActivity);
        this.activityCommentsListAccess = Utils.getActivityManager().getCommentsWithListAccess(this.getActivity(), true);
        this.commentSize = this.activityCommentsListAccess.getSize();
        this.currentLoadIndex = 0;
        this.updatedCommentId = commentActivity.getId();
        return commentActivity;
    }

    public void setLike(boolean isLiked) throws Exception {
        Identity viewerIdentity = Utils.getViewerIdentity();
        this.activity = Utils.getActivityManager().getActivity(this.activity.getId());
        this.activity.setBody(null);
        this.activity.setTitle(null);
        if (isLiked) {
            Utils.getActivityManager().saveLike(this.activity, viewerIdentity);
        } else {
            Utils.getActivityManager().deleteLike(this.activity, viewerIdentity);
        }
        this.activity = Utils.getActivityManager().getActivity(this.activity.getId());
        this.setIdenityLikes(this.activity.getLikeIdentityIds());
        this.activity = this.getI18N(this.activity);
    }

    public void setLikeComment(boolean isLiked, String commentId) {
        Identity viewerIdentity = Utils.getViewerIdentity();
        ExoSocialActivity commentActivity = Utils.getActivityManager().getActivity(commentId);
        if (isLiked) {
            Utils.getActivityManager().saveLike(commentActivity, viewerIdentity);
        } else {
            Utils.getActivityManager().deleteLike(commentActivity, viewerIdentity);
        }
        this.updatedCommentId = commentActivity.getParentCommentId();
    }

    public String getAndSetUpdatedCommentId(String newValue) {
        String updatedCommentId = this.updatedCommentId;
        this.updatedCommentId = newValue;
        return updatedCommentId;
    }

    protected String getActivityPermalink(String activityId) {
        return LinkProvider.getSingleActivityUrl((String)activityId);
    }

    protected String getCommentPermalink(String activityId, String commentId) {
        return LinkProvider.getSingleActivityUrl((String)activityId) + "&commentId=" + commentId;
    }

    public boolean isLiked() throws Exception {
        return ArrayUtils.contains((Object[])this.identityLikes, (Object)Utils.getViewerIdentity().getId());
    }

    protected void refresh() throws ActivityStorageException {
        this.activity = this.getI18N(this.activity);
        if (this.activity == null) {
            LOG.info((Object)"activity is null, not found. It can be deleted!");
            return;
        }
        this.activityCommentsListAccess = Utils.getActivityManager().getCommentsWithListAccess(this.activity, true);
        this.commentSize = this.activityCommentsListAccess.getSize();
        this.identityLikes = this.activity.getLikeIdentityIds();
        this.initSingleActivity();
    }

    private void initSingleActivity() {
        UIComposer.PostContext postContext = (UIComposer.PostContext)((Object)WebuiRequestContext.getCurrentInstance().getAttribute("postContext"));
        if (postContext == null) {
            postContext = ((UIActivitiesLoader)((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).findFirstComponentOfType(UIActivitiesLoader.class)).getPostContext();
        }
        if (postContext == UIComposer.PostContext.SINGLE) {
            if (!Utils.isExpandLikers() && !Utils.isFocusCommentBox()) {
                this.setCommentListStatus(CommentStatus.ALL);
            } else {
                this.setCommentListStatus(CommentStatus.LATEST);
            }
        }
    }

    public boolean isUserActivity() {
        boolean isUserActivity = false;
        if (this.getOwnerIdentity() != null) {
            isUserActivity = this.getOwnerIdentity().getProviderId().equals("organization");
        }
        return isUserActivity;
    }

    public boolean isSpaceActivity() {
        boolean isSpaceActivity = false;
        if (this.getOwnerIdentity() != null) {
            isSpaceActivity = this.getOwnerIdentity().getProviderId().equals("space");
        }
        return isSpaceActivity;
    }

    public boolean isActivityDeletable() throws SpaceException {
        Identity identityStreamOwner;
        if (Utils.getViewerIdentity().equals((Object)this.getOwnerIdentity())) {
            return true;
        }
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        Space space = null;
        if (postContext == UIComposer.PostContext.SPACE) {
            space = uiActivitiesContainer.getSpace();
        } else if (ActivityStream.Type.SPACE.equals((Object)this.getActivity().getActivityStream().getType()) && (identityStreamOwner = Utils.getIdentityManager().getOrCreateIdentity("space", this.getActivity().getStreamOwner(), false)) != null) {
            space = spaceService.getSpaceByPrettyName(identityStreamOwner.getRemoteId());
        }
        if (space != null) {
            return spaceService.isManager(space, Utils.getOwnerRemoteId());
        }
        return false;
    }

    public boolean isActivityEditable(ExoSocialActivity activity) {
        return this.getActivityManager().isActivityEditable(activity, ConversationState.getCurrent().getIdentity());
    }

    private ActivityManager getActivityManager() {
        if (this.activityManager == null) {
            this.activityManager = (ActivityManager)this.getApplicationComponent(ActivityManager.class);
        }
        return this.activityManager;
    }

    public boolean isActivityCommentAndLikable() throws Exception {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        if (postContext == UIComposer.PostContext.USER) {
            return true;
        }
        return true;
    }

    public boolean isActivityCommentable() throws Exception {
        UIUserActivitiesDisplay uiUserActivitiesDisplay;
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        if (this.getActivity().isLocked()) {
            return false;
        }
        if (postContext == UIComposer.PostContext.USER && (uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class)) != null && !uiUserActivitiesDisplay.isActivityStreamOwner()) {
            String ownerName = uiUserActivitiesDisplay.getOwnerName();
            Identity ownerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", ownerName, false);
            Relationship relationship = Utils.getRelationshipManager().get(ownerIdentity, Utils.getViewerIdentity());
            if (relationship == null) {
                return false;
            }
            if (relationship.getStatus() != Relationship.Type.CONFIRMED) {
                return false;
            }
        }
        return true;
    }

    public boolean isCommentDeletable(String activityUserId) throws SpaceException {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        try {
            Identity identityStreamOwner;
            if (Utils.getViewerIdentity().getId().equals(activityUserId)) {
                return true;
            }
            Space space = null;
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            if (postContext == UIComposer.PostContext.SPACE) {
                space = uiActivitiesContainer.getSpace();
                spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            } else if (ActivityStream.Type.SPACE.equals((Object)this.getActivity().getActivityStream().getType()) && (identityStreamOwner = Utils.getIdentityManager().getOrCreateIdentity("space", this.getActivity().getStreamOwner(), false)) != null) {
                space = spaceService.getSpaceByPrettyName(identityStreamOwner.getRemoteId());
            }
            if (space != null) {
                return spaceService.isManager(space, Utils.getOwnerRemoteId());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("can't not get remoteUserIdentity: remoteUser = " + Utils.getViewerRemoteId()));
        }
        return false;
    }

    public Identity getOwnerIdentity() {
        return this.ownerIdentity;
    }

    public void setOwnerIdentity(Identity ownerIdentity) {
        this.ownerIdentity = ownerIdentity;
    }

    public Identity getSpaceCreatorIdentity() {
        if ("space".equals(this.ownerIdentity.getProviderId())) {
            String spaceCreator = (String)this.activity.getTemplateParams().get("space_creator");
            if (spaceCreator != null) {
                return Utils.getIdentityManager().getOrCreateIdentity("organization", spaceCreator, false);
            }
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = spaceService.getSpaceByPrettyName(this.ownerIdentity.getRemoteId());
            if (space == null) {
                return this.ownerIdentity;
            }
            String[] managers = space.getManagers();
            return Utils.getIdentityManager().getOrCreateIdentity("organization", managers[0], false);
        }
        return null;
    }

    protected boolean isSpaceStreamOwner() {
        return this.getActivity().getActivityStream().getType().name().equalsIgnoreCase("space");
    }

    protected boolean isUISpaceActivitiesDisplay() {
        return this.getParent().getParent().getParent() instanceof UISpaceActivitiesDisplay;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        try {
            Utils.initUserProfilePopup(this.getId());
            String focusActivityId = Utils.getActivityID();
            String focusCommentID = Utils.getCommentID();
            if (StringUtils.isNotBlank((CharSequence)focusCommentID)) {
                ExoSocialActivity focusedActivity = Utils.getActivityManager().getActivity(focusCommentID);
                if (focusedActivity != null && focusedActivity.getParentCommentId() != null) {
                    this.getAndSetUpdatedCommentId(focusedActivity.getParentCommentId());
                } else {
                    this.getAndSetUpdatedCommentId(focusCommentID);
                }
            }
            super.processRender(context);
            if (this.getActivity().getId().equals(focusActivityId)) {
                context.getJavascriptManager().require("SHARED/social-ui-activity", "activity").addScripts("setTimeout(function() { activity.hightlightComment('" + focusActivityId + "');" + (Utils.isFocusCommentBox() ? "activity.replyByURL('" + focusActivityId + "');" : "") + (Utils.isFocusCommentReplyBox() ? "activity.replyByURL('" + focusCommentID + "');" : "") + (StringUtils.isNotBlank((CharSequence)focusCommentID) ? "activity.focusToComment('" + focusCommentID + "');" : "") + (Utils.isExpandLikers() ? "activity.loadLikersByURL();" : "") + "}, 100);");
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isNoLongerExisting(String activityId, Event<BaseUIActivity> event) {
        return this.isNoLongerExisting(activityId);
    }

    protected boolean isNoLongerExisting(String activityId) {
        ExoSocialActivity existingActivity = Utils.getActivityManager().getActivity(activityId);
        if (existingActivity == null) {
            ((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).addMessage(new ApplicationMessage("BaseUIActivity.msg.info.Activity_No_Longer_Exist", null, 2));
            return true;
        }
        return false;
    }

    public boolean isDeletedSpace(String streamOwner) {
        if (this.activity.getActivityStream().getType().toString().equals("space")) {
            return ((SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceByPrettyName(streamOwner) == null;
        }
        return false;
    }

    public Identity getCommenterIdentity() {
        return Utils.getViewerIdentity();
    }

    protected ExoSocialActivity getI18N(ExoSocialActivity activity) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)this.getApplicationComponent(I18NActivityProcessor.class);
        if (activity.getTitleId() != null) {
            Locale userLocale = requestContext.getLocale();
            activity = i18NActivityProcessor.process(activity, userLocale);
        }
        return activity;
    }

    private List<ExoSocialActivity> getI18N(List<ExoSocialActivity> comments) {
        ArrayList<ExoSocialActivity> cmts = new ArrayList<ExoSocialActivity>();
        for (ExoSocialActivity cmt : comments) {
            cmts.add(this.getI18N(cmt));
        }
        return cmts;
    }

    protected void focusToComment(String commentId) {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jm = pContext.getJavascriptManager();
        jm.require("SHARED/social-ui-activity", "UIActivity").addScripts("UIActivity.focusToComment('" + commentId + "', null, 2000);");
    }

    public static class EditCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            WebuiRequestContext requestContext = event.getRequestContext();
            String commentId = requestContext.getRequestParameter("objectId");
            String message = requestContext.getRequestParameter("composerEditComment" + commentId);
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            ExoSocialActivity originalActivity = Utils.getActivityManager().getActivity(commentId);
            uiActivity.editCommentMessage(originalActivity, message);
            if (StringUtils.isNotBlank((CharSequence)commentId)) {
                uiActivity.getAndSetUpdatedCommentId(commentId);
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class EditActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            WebuiRequestContext requestContext = event.getRequestContext();
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            String message = ((String)((UIFormTextAreaInput)uiActivity.getChildById(BaseUIActivity.COMPOSER_TEXT_AREA_EDIT_INPUT + uiActivity.getActivity().getId())).getValue()).replaceAll(BaseUIActivity.HTML_AT_SYMBOL_ESCAPED_PATTERN, BaseUIActivity.HTML_AT_SYMBOL_PATTERN);
            uiActivity.editActivity(message);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class LikeCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            WebuiRequestContext requestContext = event.getRequestContext();
            String[] likeStatus = requestContext.getRequestParameter("objectId").split("_");
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.setLikeComment(Boolean.parseBoolean(likeStatus[0]), likeStatus[1]);
            String commentId = requestContext.getRequestParameter("commentId");
            if (StringUtils.isNotBlank((CharSequence)commentId)) {
                uiActivity.getAndSetUpdatedCommentId(commentId);
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
        }
    }

    public static class DeleteCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            WebuiRequestContext requestContext = event.getRequestContext();
            String commentId = requestContext.getRequestParameter("objectId");
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId()) || uiActivity.isNoLongerExisting(commentId)) {
                return;
            }
            Utils.getActivityManager().deleteComment(activityId, commentId);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
        }
    }

    public static class DeleteActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            boolean isEmptyListActivity;
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId())) {
                return;
            }
            Utils.getActivityManager().deleteActivity(activityId);
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)uiActivity.getAncestorOfType(UIActivitiesContainer.class);
            activitiesContainer.removeChildById(uiActivity.getParent().getId());
            activitiesContainer.removeActivity(uiActivity.getActivity());
            WebuiRequestContext context = event.getRequestContext();
            context.getJavascriptManager().require("SHARED/social-ui-activity", "activity").addScripts("activity.responsiveMobile('" + ((UIPortletApplication)activitiesContainer.getAncestorOfType(UIPortletApplication.class)).getId() + "');");
            boolean bl = isEmptyListActivity = activitiesContainer.getActivityIdList().size() == 0 && activitiesContainer.getActivityList().size() == 0;
            if (isEmptyListActivity) {
                context.addUIComponentToUpdateByAjax(activitiesContainer.getParent().getParent());
            } else {
                AbstractActivitiesDisplay uiActivitiesDisplay = (AbstractActivitiesDisplay)activitiesContainer.getAncestorOfType(AbstractActivitiesDisplay.class);
                uiActivitiesDisplay.init();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivitiesDisplay);
            }
            Utils.clearUserProfilePopup();
        }
    }

    public static class PostCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId())) {
                return;
            }
            String commentId = event.getRequestContext().getRequestParameter("objectId");
            WebuiRequestContext requestContext = event.getRequestContext();
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            if (message == null || message.equals("")) {
                UIApplication uiApplication = requestContext.getUIApplication();
                uiApplication.addMessage(new ApplicationMessage("UIComposer.msg.error.Empty_Message", null, 1));
                return;
            }
            uiFormComment.reset();
            ExoSocialActivity newComment = uiActivity.saveComment(requestContext.getRemoteUser(), message.replaceAll(BaseUIActivity.HTML_AT_SYMBOL_ESCAPED_PATTERN, BaseUIActivity.HTML_AT_SYMBOL_PATTERN), commentId);
            uiActivity.setCommentFormFocused(true);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
            uiActivity.focusToComment(newComment.getId());
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class ToggleDisplayCommentFormActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isCommentFormDisplayed()) {
                uiActivity.setCommentFormDisplayed(false);
            } else {
                uiActivity.setCommentFormDisplayed(true);
            }
            Utils.initUserProfilePopup(uiActivity.getId());
        }
    }

    public static class SetCommentListStatusActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId())) {
                return;
            }
            String status = event.getRequestContext().getRequestParameter("objectId");
            CommentStatus commentListStatus = null;
            if (status.equals(CommentStatus.LATEST.getStatus())) {
                commentListStatus = CommentStatus.LATEST;
            } else if (status.equals(CommentStatus.ALL.getStatus())) {
                commentListStatus = CommentStatus.ALL;
            } else if (status.equals(CommentStatus.NONE.getStatus())) {
                commentListStatus = CommentStatus.NONE;
            }
            if (commentListStatus != null) {
                uiActivity.setCommentListStatus(commentListStatus);
            }
            uiActivity.setCommentFormDisplayed(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            String inputContainerId = "InputContainer" + activityId;
            StringBuffer script = new StringBuffer("(function($) {");
            script.append("var inputContainer = $('#").append(inputContainerId).append("');");
            script.append("inputContainer.addClass('inputContainerShow hidden-phone').show();");
            script.append("})(jq);");
            JavascriptManager jm = event.getRequestContext().getJavascriptManager();
            Utils.initUserProfilePopup(uiActivity.getId());
            jm.require("SHARED/social-ui-activity", "activity").require("SHARED/jquery", "jq").addScripts("activity.initCKEditor('" + activityId + "', activity.spaceURL, activity.commentPlaceholder, activity.spaceGroupId);").addScripts(script.toString());
        }
    }

    public static class LikeActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId())) {
                return;
            }
            WebuiRequestContext requestContext = event.getRequestContext();
            String isLikedStr = requestContext.getRequestParameter("objectId");
            String commentId = requestContext.getRequestParameter("commentId");
            uiActivity.setLike(Boolean.parseBoolean(isLikedStr));
            JavascriptManager jm = requestContext.getJavascriptManager();
            jm.require("SHARED/social-ui-activity", "activity").addScripts("activity.displayLike('#ContextBox" + activityId + "');");
            if (StringUtils.isNotBlank((CharSequence)commentId)) {
                uiActivity.getAndSetUpdatedCommentId(commentId);
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            Utils.initUserProfilePopup(uiActivity.getId());
        }
    }

    public static class LoadLikesActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            String activityId;
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isNoLongerExisting(activityId = uiActivity.getActivity().getId())) {
                return;
            }
            uiActivity.setAllLoaded(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            JavascriptManager jm = event.getRequestContext().getJavascriptManager();
            jm.require("SHARED/social-ui-activity", "activity").addScripts("activity.loadLikes('#ContextBox" + activityId + "');");
            Utils.initUserProfilePopup(uiActivity.getId());
        }
    }

    public static enum CommentStatus {
        LATEST("latest"),
        ALL("all"),
        NONE("none");

        private String commentStatus;

        private CommentStatus(String status) {
            this.commentStatus = status;
        }

        public String getStatus() {
            return this.commentStatus;
        }
    }
}

