/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(template="war:/groovy/social/webui/space/UIVisibilityFormInputSet.gtmpl", events={@EventConfig(listeners={ChangeVisibilityActionListener.class})})
public class UISpaceVisibility
extends UIFormInputSet {
    public static final String UI_SPACE_REGISTRATION = "UIRegistration";
    private static final String REGISTRATION_BINDING = "registration";
    private static final String VISIBLE_SPACE = "UISpaceVisibility.label.VisibleSpace";
    private static final String HIDDEN_SPACE = "UISpaceVisibility.label.HiddenSpace";
    private static final String OPEN_SPACE = "UISpaceVisibility.label.OpenSpace";
    private static final String VALIDATION_SPACE = "UISpaceVisibility.label.ValidationSpace";
    private static final String CLOSE_SPACE = "UISpaceVisibility.label.CloseSpace";
    private String visibility;

    public UISpaceVisibility(String name) throws Exception {
        super(name);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        this.setVisibility("private");
        ArrayList<SelectItemOption> spaceRegistration = new ArrayList<SelectItemOption>(3);
        SelectItemOption openOption = new SelectItemOption((Object)"open");
        openOption.setSelected(true);
        spaceRegistration.add(openOption);
        SelectItemOption validationOption = new SelectItemOption((Object)"validation");
        spaceRegistration.add(validationOption);
        SelectItemOption closeOption = new SelectItemOption((Object)"close");
        spaceRegistration.add(closeOption);
        UIFormRadioBoxInput uiRadioRegistration = new UIFormRadioBoxInput(UI_SPACE_REGISTRATION, REGISTRATION_BINDING, spaceRegistration);
        uiRadioRegistration.setValue((Object)"open");
        this.addUIFormInput((UIFormInput)uiRadioRegistration);
        UIFormInputInfo visibilityInfo = new UIFormInputInfo("Visibility", null, null);
        WebuiRequestContext webReqCtx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resApp = webReqCtx.getApplicationResourceBundle();
        String visible = resApp.getString(VISIBLE_SPACE);
        visibilityInfo.setValue((Object)visible);
        this.addUIFormInput((UIFormInput)visibilityInfo);
        UIFormInputInfo registrationInfo = new UIFormInputInfo("Registration", null, null);
        String validation = resApp.getString(VALIDATION_SPACE);
        registrationInfo.setValue((Object)validation);
        this.addUIFormInput((UIFormInput)registrationInfo);
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibilityInfo(ResourceBundle resourceBundle, String visibility) {
        UIFormInputInfo uiFormInputInfo = this.getUIFormInputInfo("Visibility");
        String visibilityInfo = resourceBundle.getString(VISIBLE_SPACE);
        if ("hidden".equals(visibility)) {
            visibilityInfo = resourceBundle.getString(HIDDEN_SPACE);
        }
        uiFormInputInfo.setValue((Object)visibilityInfo);
    }

    public void setRegistrationInfo(ResourceBundle resourceBundle, String registration) {
        UIFormInputInfo uiFormInputInfo = this.getUIFormInputInfo("Registration");
        String registrationInfo = resourceBundle.getString(VALIDATION_SPACE);
        if ("open".equals(registration)) {
            registrationInfo = resourceBundle.getString(OPEN_SPACE);
        } else if ("close".equals(registration)) {
            registrationInfo = resourceBundle.getString(CLOSE_SPACE);
        }
        uiFormInputInfo.setValue((Object)registrationInfo);
    }

    public static class ChangeVisibilityActionListener
    extends EventListener<UISpaceVisibility> {
        public void execute(Event<UISpaceVisibility> event) throws Exception {
            UISpaceVisibility uiSpaceVisibility = (UISpaceVisibility)((Object)event.getSource());
            String oldVisibility = uiSpaceVisibility.getVisibility();
            String visibility = "hidden".equals(oldVisibility) ? "private" : "hidden";
            uiSpaceVisibility.setVisibility(visibility);
            WebuiRequestContext ctx = event.getRequestContext();
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            uiSpaceVisibility.setVisibilityInfo(resApp, visibility);
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiSpaceVisibility);
        }
    }
}

