/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.UIActivitiesLoader;
import org.exoplatform.social.webui.activity.UIActivityFactory;
import org.exoplatform.social.webui.activity.UIActivityLoader;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/UIActivitiesContainer.gtmpl", events={@EventConfig(listeners={LoadActivityActionListener.class})})
public class UIActivitiesContainer
extends UIContainer {
    public static final String ACTIVITY_STREAM_VISITED_PREFIX_COOKIED = "exo_social_activity_stream_%s_visited_%s";
    private static final String ACTIVITIES_NODE = "activities";
    private List<ExoSocialActivity> activityList;
    private List<String> activityIdList;
    private List<String> uiActivityIdFirstList;
    private List<String> uiActivityIdNextList;
    private UIComposer.PostContext postContext;
    private Space space;
    private String ownerName;
    private String selectedDisplayMode;
    private boolean isRenderFull = false;

    public PopupContainer getPopupContainer() {
        return (PopupContainer)((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).findFirstComponentOfType(PopupContainer.class);
    }

    public UIPopupWindow getPopupWindow() {
        return (UIPopupWindow)((UIPopupWindow)this.getPopupContainer().getChild(UIPopupWindow.class)).setRendered(true);
    }

    public List<ExoSocialActivity> getActivityList() {
        return this.activityList != null ? this.activityList : new LinkedList<ExoSocialActivity>();
    }

    public UIActivitiesContainer setActivityList(List<ExoSocialActivity> activityList) throws Exception {
        this.activityList = activityList;
        this.activityIdList = new LinkedList<String>();
        for (ExoSocialActivity activity : activityList) {
            this.activityIdList.add(activity.getId());
        }
        this.init();
        return this;
    }

    public boolean isRenderFull() {
        return this.isRenderFull;
    }

    public void setRenderFull(boolean isRenderFull, boolean isFirst) {
        if (isFirst) {
            ArrayList containers = new ArrayList();
            ((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).findComponentOfType(containers, UIActivitiesContainer.class);
            for (UIActivitiesContainer uiActivitiesContainer : containers) {
                uiActivitiesContainer.setRenderFull(isRenderFull, false);
            }
        } else {
            this.isRenderFull = isRenderFull;
        }
    }

    public boolean isFirstUIActivitiesContainer() {
        return this.getParent().getId().equals("UIActivitiesLoader");
    }

    public List<String> getActivityIdList() {
        return this.activityIdList != null ? this.activityIdList : new LinkedList<String>();
    }

    public List<String> getUiActivityIdFirstList() {
        return new LinkedList<String>(this.uiActivityIdFirstList);
    }

    public List<String> getUiActivityIdNextList() {
        return new LinkedList<String>(this.uiActivityIdNextList);
    }

    public void addFirstActivityId(String activityId) {
        if (this.activityIdList.contains(activityId)) {
            this.activityIdList.remove(activityId);
        }
        ((LinkedList)this.activityIdList).addFirst(activityId);
    }

    public UIActivitiesContainer setActivityIdList(List<String> activityIdList) throws Exception {
        this.activityIdList = activityIdList;
        this.init();
        return this;
    }

    public void setPostContext(UIComposer.PostContext postContext) {
        this.postContext = postContext;
    }

    public UIComposer.PostContext getPostContext() {
        return this.postContext;
    }

    public Space getSpace() {
        return this.space;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getSelectedDisplayMode() {
        return this.selectedDisplayMode;
    }

    public void setSelectedDisplayMode(String selectedDisplayMode) {
        this.selectedDisplayMode = selectedDisplayMode;
    }

    protected long getCurrentServerTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public boolean isOnMyActivities() {
        return Utils.getSelectedNode() != null && Utils.getSelectedNode().startsWith(ACTIVITIES_NODE);
    }

    private void init() throws Exception {
        while (this.getChild(UIActivityLoader.class) != null) {
            this.removeChild(UIActivityLoader.class);
        }
        if (this.activityIdList == null) {
            return;
        }
        UIActivitiesLoader activitiesLoader = (UIActivitiesLoader)this.getParent();
        int activityFullRender = activitiesLoader.getLoadingCapacity();
        boolean isFirstLoader = ((Object)((Object)activitiesLoader)).getClass().getSimpleName().equals(activitiesLoader.getId());
        int index = 0;
        this.uiActivityIdFirstList = new LinkedList<String>();
        this.uiActivityIdNextList = new LinkedList<String>();
        ActivityManager activityManager = (ActivityManager)this.getApplicationComponent(ActivityManager.class);
        List activities = activityManager.getActivities(this.activityIdList);
        for (ExoSocialActivity activity : activities) {
            UIActivityFactory factory;
            if (activity == null) continue;
            UIActivityLoader uiActivityLoader = (UIActivityLoader)this.addChild(UIActivityLoader.class, null, UIActivityLoader.buildComponentId(activity.getId()));
            if (this.isRenderFull()) {
                factory = (UIActivityFactory)((Object)CommonsUtils.getService(UIActivityFactory.class));
                factory.addChild(activity, uiActivityLoader);
                continue;
            }
            if (activityFullRender > 0 && isFirstLoader) {
                if (index < activityFullRender) {
                    factory = (UIActivityFactory)((Object)CommonsUtils.getService(UIActivityFactory.class));
                    factory.addChild(activity, uiActivityLoader);
                    this.uiActivityIdFirstList.add(uiActivityLoader.getId());
                } else {
                    this.uiActivityIdNextList.add(uiActivityLoader.getId());
                }
                ++index;
                continue;
            }
            this.uiActivityIdNextList.add(uiActivityLoader.getId());
        }
    }

    public void addActivity(ExoSocialActivity activity) throws Exception {
        if (this.activityList == null) {
            this.activityList = new LinkedList<ExoSocialActivity>();
        }
        this.activityList.add(0, activity);
        this.addFirstActivityId(activity.getId());
        this.init();
    }

    public void removeActivity(ExoSocialActivity removedActivity) {
        if (this.activityIdList != null) {
            this.activityIdList.remove(removedActivity.getId());
        }
        if (this.activityList != null) {
            for (ExoSocialActivity activity : this.activityList) {
                if (!activity.getId().equals(removedActivity.getId())) continue;
                this.activityList.remove(activity);
                break;
            }
        }
    }

    public String getCookiesKey(String displayMode) {
        return String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, displayMode, Utils.getViewerRemoteId());
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().getRequireJS().require("SHARED/social-ui-activities-loader", "activitiesLoader").addScripts("activitiesLoader.loadingActivities('" + this.getId() + "');");
        super.processRender(context);
    }

    protected String getLoadActivityUrl() throws Exception {
        return this.event("LoadActivity").replace("javascript:ajaxGet('", "").replace("')", "&objectId=");
    }

    public static class LoadActivityActionListener
    extends EventListener<UIActivitiesContainer> {
        public void execute(Event<UIActivitiesContainer> event) throws Exception {
            UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)((Object)event.getSource());
            String uiActivityId = event.getRequestContext().getRequestParameter("objectId");
            if (uiActivityId == null || uiActivityId.isEmpty()) {
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
            }
            String activityId = uiActivityId.replace(UIActivityLoader.COMPONENT_ID, "");
            ExoSocialActivity activity = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(activityId);
            UIActivityLoader uiActivityLoader = (UIActivityLoader)uiActivitiesContainer.getChildById(uiActivityId);
            if (uiActivityLoader != null) {
                uiActivitiesContainer.removeChildById(uiActivityId);
            }
            if (activity != null) {
                uiActivityLoader = (UIActivityLoader)uiActivitiesContainer.addChild(UIActivityLoader.class, null, UIActivityLoader.buildComponentId(activityId));
                UIActivityFactory factory = (UIActivityFactory)((Object)CommonsUtils.getService(UIActivityFactory.class));
                factory.addChild(activity, uiActivityLoader);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivityLoader);
            } else {
                activity = new ExoSocialActivityImpl();
                activity.setId(activityId);
                uiActivitiesContainer.removeActivity(activity);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiActivitiesContainer.getParent());
            }
        }
    }
}

