/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.Calendar;
import org.apache.commons.lang.Validate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.AbstractActivitiesDisplay;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.activity.UIActivitiesLoader;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="war:/groovy/social/webui/profile/UIUserActivitiesDisplay.gtmpl", events={@EventConfig(listeners={RefreshStreamActionListener.class})})})
public class UIUserActivitiesDisplay
extends AbstractActivitiesDisplay {
    private static final Log LOG = ExoLogger.getLogger(UIUserActivitiesDisplay.class);
    private static final String SLASH = "/";
    private static final String ACTIVITIES_PER_PAGE_KEY = "social.activities.display.per.page";
    private static int ACTIVITY_PER_PAGE = 10;
    public static final String ACTIVITY_STREAM_VISITED_PREFIX_COOKIED = "exo_social_activity_stream_%s_visited_%s";
    private Object locker = new Object();
    private boolean notChangedMode;
    private boolean postActivity;
    private int numberOfUpdatedActivities;
    private DisplayMode selectedDisplayMode = DisplayMode.ALL_ACTIVITIES;
    private boolean isActivityStreamOwner = false;
    private UIActivitiesLoader activitiesLoader;
    private String ownerName;
    private String viewerName;

    public UIUserActivitiesDisplay() throws Exception {
        ACTIVITY_PER_PAGE = Integer.valueOf(PrivilegedSystemHelper.getProperty((String)ACTIVITIES_PER_PAGE_KEY, (String)"10").trim());
        String selectedDisplayMode = Utils.getCookies(String.format("exo_social_activity_stream_tab_selected_%s", Utils.getViewerRemoteId()));
        selectedDisplayMode = selectedDisplayMode != null ? selectedDisplayMode : DisplayMode.ALL_ACTIVITIES.name();
        this.setSelectedDisplayMode(selectedDisplayMode);
    }

    public UIActivitiesLoader getActivitiesLoader() {
        return this.activitiesLoader;
    }

    public boolean isSingleContext() {
        return this.getActivitiesLoader().getPostContext() == UIComposer.PostContext.SINGLE;
    }

    public boolean isActivityStreamOwner() {
        return this.isActivityStreamOwner;
    }

    public void setNumberOfUpdatedActivities(int numberOfUpdatedActivities) {
        this.numberOfUpdatedActivities = numberOfUpdatedActivities;
    }

    public int getNumberOfUpdatedActivities() {
        return this.numberOfUpdatedActivities;
    }

    public void setSelectedDisplayMode(DisplayMode displayMode) {
        this.selectedDisplayMode = displayMode;
    }

    public void setSelectedDisplayMode(String selectedDisplayMode) {
        DisplayMode[] displayModes = DisplayMode.values();
        for (int i = 0; i < displayModes.length; ++i) {
            if (!displayModes[i].name().equals(selectedDisplayMode)) continue;
            this.setSelectedDisplayMode(displayModes[i]);
            break;
        }
    }

    public DisplayMode getSelectedDisplayMode() {
        return this.selectedDisplayMode;
    }

    public String getCookiesKey(String displayMode) {
        return String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, displayMode, Utils.getViewerRemoteId());
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        this.viewerName = Utils.getViewerRemoteId();
        this.ownerName = Utils.getOwnerRemoteId();
        Validate.notNull((Object)this.ownerName, (String)"ownerName must not be null.");
        Validate.notNull((Object)this.viewerName, (String)"viewerName must not be null.");
        this.isActivityStreamOwner = this.viewerName.equals(this.ownerName);
        if (!this.isActivityStreamOwner) {
            this.selectedDisplayMode = DisplayMode.OWNER_STATUS;
        }
        Object object = this.locker;
        synchronized (object) {
            this.removeChild(UIActivitiesLoader.class);
            this.activitiesLoader = (UIActivitiesLoader)this.addChild(UIActivitiesLoader.class, null, "UIActivitiesLoader");
            ((UIActivitiesContainer)this.activitiesLoader.getChild(UIActivitiesContainer.class)).setRenderFull(this.isRenderFull(), true);
        }
        String activityId = Utils.getActivityID();
        if (activityId != null && activityId.length() > 0) {
            this.activitiesLoader.setPostContext(UIComposer.PostContext.SINGLE);
        } else {
            this.activitiesLoader.setPostContext(UIComposer.PostContext.USER);
        }
        String currentUserName = URLUtils.getCurrentUser();
        if (currentUserName != null) {
            this.selectedDisplayMode = DisplayMode.OWNER_STATUS;
        }
        this.activitiesLoader.setLoadingCapacity(ACTIVITY_PER_PAGE);
        this.activitiesLoader.setOwnerName(this.ownerName);
        this.activitiesLoader.setSelectedDisplayMode(this.selectedDisplayMode.toString());
        Identity ownerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", this.ownerName, false);
        ActivityManager activityManager = Utils.getActivityManager();
        RealtimeListAccess activitiesListAccess = null;
        switch (this.selectedDisplayMode) {
            case MY_ACTIVITIES: {
                activitiesListAccess = activityManager.getActivitiesWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                break;
            }
            case OWNER_STATUS: {
                if (!this.isActivityStreamOwner) {
                    Identity viewerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", this.viewerName, false);
                    activitiesListAccess = activityManager.getActivitiesWithListAccess(ownerIdentity, viewerIdentity);
                    this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                    break;
                }
                activitiesListAccess = activityManager.getActivitiesWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                break;
            }
            case CONNECTIONS: {
                activitiesListAccess = activityManager.getActivitiesOfConnectionsWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                break;
            }
            case MY_SPACE: {
                activitiesListAccess = activityManager.getActivitiesOfUserSpacesWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                break;
            }
            default: {
                activitiesListAccess = activityManager.getActivityFeedWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
            }
        }
        String lastVisitedModeCookieKey = String.format("exo_social_activity_stream_tab_selected_%s", Utils.getViewerRemoteId());
        String lastVisitedMode = Utils.getCookies(lastVisitedModeCookieKey);
        this.notChangedMode = lastVisitedMode == null ? true : this.selectedDisplayMode.toString().equals(lastVisitedMode.trim());
        this.setNumberOfUpdatedActivities(0);
        this.activitiesLoader.init();
    }

    public void setChangedMode(boolean changedMode) {
        this.notChangedMode = changedMode;
    }

    protected long getCurrentServerTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    protected String getSitePath() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String siteName = portalRequestContext.getSiteName();
        SiteType siteType = portalRequestContext.getSiteType();
        return SLASH + siteType.getName() + SLASH + siteName + SLASH;
    }

    protected boolean hasActivities() {
        try {
            UIActivitiesLoader uiActivitiesLoader = (UIActivitiesLoader)this.getChild(UIActivitiesLoader.class);
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)uiActivitiesLoader.getChild(UIActivitiesContainer.class);
            return activitiesContainer != null && activitiesContainer.getChildren().size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void resetCookies() {
        Utils.setLastVisited(this.selectedDisplayMode.toString());
        if (this.selectedDisplayMode == DisplayMode.ALL_ACTIVITIES) {
            Utils.setLastVisited(DisplayMode.CONNECTIONS.toString());
            Utils.setLastVisited(DisplayMode.MY_ACTIVITIES.toString());
            Utils.setLastVisited(DisplayMode.MY_SPACE.toString());
        }
    }

    public void setPostActivity(boolean postActivity) {
        this.postActivity = postActivity;
    }

    protected boolean isWelcomeActivity() {
        this.viewerName = PortalRequestContext.getCurrentInstance().getRemoteUser();
        if (!this.viewerName.equals(this.ownerName)) {
            return false;
        }
        boolean hasActivities = this.getActivitiesLoader().getActivitiesContainer().getChildren().size() > 0;
        boolean isAllActivitiesModeOnHomePage = DisplayMode.ALL_ACTIVITIES.equals((Object)this.getSelectedDisplayMode());
        return Utils.isHomePage() ? !hasActivities && isAllActivitiesModeOnHomePage : !hasActivities;
    }

    public boolean isRelationConfirmed() {
        Relationship relationship;
        return Utils.getViewerIdentity() != null && Utils.getOwnerIdentity() != null && !Utils.getViewerIdentity().getId().equals(Utils.getOwnerIdentity().getId()) && (relationship = Utils.getRelationshipManager().get(Utils.getViewerIdentity(), Utils.getOwnerIdentity())) != null && relationship.getStatus() == Relationship.Type.CONFIRMED;
    }

    public static class RefreshStreamActionListener
    extends EventListener<UIUserActivitiesDisplay> {
        public void execute(Event<UIUserActivitiesDisplay> event) throws Exception {
            UIUserActivitiesDisplay uiUserActivities = (UIUserActivitiesDisplay)((Object)event.getSource());
            uiUserActivities.init();
            event.getRequestContext().getJavascriptManager().require("SHARED/social-ui-activity", "activity").addScripts("activity.responsiveMobile('" + ((UIPortletApplication)uiUserActivities.getAncestorOfType(UIPortletApplication.class)).getId() + "');");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUserActivities);
        }
    }

    public static enum DisplayMode {
        OWNER_STATUS,
        ALL_ACTIVITIES,
        CONNECTIONS,
        MY_SPACE,
        MY_ACTIVITIES,
        POSTER_ACTIVITIES;

    }
}

