/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceApplication;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/space/UIAddApplicationSpace.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={InstallActionListener.class})})
public class UIAddApplicationSpace
extends UIForm
implements UIPopupComponent {
    private UIPageIterator iterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorAddSpaceApplication");
    private String spaceId;
    private static final String iteratorID = "UIIteratorAddSpaceApplication";
    private final String HOME_APPLICATION = "HomeSpacePortlet";

    public UIAddApplicationSpace() throws Exception {
        this.addChild((UIComponent)this.iterator_);
    }

    public void setSpaceId(String spaceId) throws Exception {
        this.spaceId = spaceId;
        Space space = Utils.getSpaceService().getSpaceById(spaceId);
        List list = SpaceUtils.getApplications((String)space.getGroupId());
        String appList = space.getApp();
        if (appList != null) {
            for (Application app : list) {
                String appName = app.getApplicationName();
                if (!appList.contains(appName) && !appName.equals("HomeSpacePortlet")) continue;
                list.remove(app);
            }
        }
    }

    public List<Application> getApplications() throws Exception {
        List lists = this.iterator_.getCurrentPageData();
        return lists;
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator_;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class InstallActionListener
    extends EventListener<UIAddApplicationSpace> {
        public void execute(Event<UIAddApplicationSpace> event) throws Exception {
            UIAddApplicationSpace uiform = (UIAddApplicationSpace)((Object)event.getSource());
            SpaceService spaceService = (SpaceService)uiform.getApplicationComponent(SpaceService.class);
            String appId = event.getRequestContext().getRequestParameter("objectId");
            spaceService.installApplication(uiform.spaceId, appId);
            spaceService.activateApplication(uiform.spaceId, appId);
            UISpaceApplication uiForm = (UISpaceApplication)uiform.getAncestorOfType(UISpaceApplication.class);
            Space space = spaceService.getSpaceById(uiform.spaceId);
            uiForm.setValue(space);
            SpaceUtils.updateWorkingWorkSpace();
            UIPopupContainer uiPopup = (UIPopupContainer)uiForm.getChild(UIPopupContainer.class);
            uiPopup.cancelPopupAction();
        }
    }

    public static class CloseActionListener
    extends EventListener<UIAddApplicationSpace> {
        public void execute(Event<UIAddApplicationSpace> event) throws Exception {
            UIAddApplicationSpace uiSpaceApp = (UIAddApplicationSpace)((Object)event.getSource());
            UISpaceApplication uiForm = (UISpaceApplication)uiSpaceApp.getAncestorOfType(UISpaceApplication.class);
            UIPopupContainer uiPopup = (UIPopupContainer)uiForm.getChild(UIPopupContainer.class);
            uiPopup.cancelPopupAction();
        }
    }
}

