/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.navigation.help;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.social.navigation.help.Helper;

public class HelpService {
    public static final String DEFAULT_HELP_PAGE = " http://docs.exoplatform.com/PLF35/index.jsp?topic=%2Forg.exoplatform.doc.35%2FUserGuide.html";
    private PropertiesParam props = null;

    public HelpService(InitParams params) {
        if (params == null) {
            throw new IllegalStateException("given params are null in helpService");
        }
        this.props = params.getPropertiesParam("help.pages");
        if (this.props == null) {
            throw new IllegalStateException("params.getPropertiesParam() returns null in helpService");
        }
    }

    public String fetchHelpPage(String currentNavigation) {
        String helpPage = DEFAULT_HELP_PAGE;
        if (this.props != null) {
            helpPage = this.props.getProperty(currentNavigation);
        }
        if (!Helper.present(helpPage)) {
            return this.getDefaultPageHelp();
        }
        return helpPage;
    }

    public String getDefaultPageHelp() {
        if (this.props != null && Helper.present(this.props.getProperty("default"))) {
            return this.props.getProperty("default");
        }
        return DEFAULT_HELP_PAGE;
    }
}

