/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.feedmash;

import com.google.common.collect.Lists;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import com.sun.syndication.io.impl.Base64;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.extras.feedmash.Application;
import org.exoplatform.social.extras.feedmash.ApplicationsIdentityProvider;
import org.exoplatform.social.extras.feedmash.MashupStateHolder;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class AbstractFeedmashJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(AbstractFeedmashJob.class);
    protected static final String LAST_CHECKED = "lastChecked";
    protected String targetActivityStream;
    protected String portalContainer;
    protected String feedUrl;
    protected Integer rampup = 1;
    protected String pluginName;
    protected String feedLastCheck;
    protected String username;
    protected String password;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            String authStringEnc;
            byte[] authEncBytes;
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            this.init(dataMap);
            if (this.severIsStarting(dataMap)) {
                return;
            }
            this.beforeJobExecute(dataMap);
            SyndFeedInput input = new SyndFeedInput();
            URLConnection urlConnection = null;
            URL url = new URL(this.feedUrl);
            if (url.getUserInfo() != null) {
                authEncBytes = Base64.encode((byte[])url.getUserInfo().getBytes());
                authStringEnc = new String(authEncBytes);
                urlConnection = url.openConnection();
                urlConnection.setRequestProperty("Authorization", "Basic " + authStringEnc);
            } else if (this.username != null && this.password != null) {
                authEncBytes = Base64.encode((byte[])(this.username + ":" + this.password).getBytes());
                authStringEnc = new String(authEncBytes);
                urlConnection = url.openConnection();
                urlConnection.setRequestProperty("Authorization", "Basic " + authStringEnc);
            } else {
                urlConnection = url.openConnection();
            }
            InputStream is = urlConnection.getInputStream();
            SyndFeed feed = input.build((Reader)new XmlReader(is));
            List entries = feed.getEntries();
            for (SyndEntryImpl entry : Lists.reverse((List)entries)) {
                if (!this.accept(entry)) continue;
                this.handle(entry);
            }
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    protected abstract void handle(SyndEntryImpl var1);

    protected abstract boolean accept(SyndEntryImpl var1);

    public void beforeJobExecute(JobDataMap dataMap) {
    }

    protected Object getState(String key) {
        String uniqueKey = this.getStateKey(key);
        return this.getExoComponent(MashupStateHolder.class).getState(uniqueKey);
    }

    protected void saveState(String key, Object state) {
        String uniqueKey = this.getStateKey(key);
        this.getExoComponent(MashupStateHolder.class).saveState(uniqueKey, state);
    }

    protected String getStateKey(String key) {
        return this.pluginName + "." + key;
    }

    protected boolean alreadyChecked(Date date) {
        Date lastChecked = (Date)this.getState(this.feedLastCheck);
        if (lastChecked == null) {
            return false;
        }
        return !lastChecked.before(date);
    }

    protected <T> T getExoComponent(Class<T> type) {
        ExoContainer container = ExoContainerContext.getContainerByName((String)this.portalContainer);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        return (T)container.getComponentInstanceOfType(type);
    }

    protected void publishActivity(String message, Identity from, Identity to) throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(message);
        activity.setAppId("feedmash:" + this.getClass());
        activity.setUserId(from.getId());
        ActivityManager activityManager = this.getExoComponent(ActivityManager.class);
        activityManager.saveActivityNoReturn(to, (ExoSocialActivity)activity);
    }

    protected Identity getIdentity(String targetUser) {
        Identity identity = null;
        String[] identityInfo = null;
        try {
            if (targetUser == null || targetUser.split(":").length != 2) {
                throw new Exception();
            }
            identityInfo = targetUser.split(":");
            IdentityManager identityManager = this.getExoComponent(IdentityManager.class);
            identity = identityManager.getOrCreateIdentity(identityInfo[0], identityInfo[1], false);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not find identity for " + targetUser + ": " + e.getMessage()));
        }
        return identity;
    }

    protected String getStringParam(JobDataMap dataMap, String name, String defaultValue) {
        String value = dataMap.getString(name);
        return value == null ? defaultValue : value;
    }

    protected Identity getAppIdentity(Application app) throws Exception {
        IdentityManager identityManager = this.getExoComponent(IdentityManager.class);
        ApplicationsIdentityProvider appIdentityProvider = new ApplicationsIdentityProvider();
        appIdentityProvider.addApplication(app);
        identityManager.addIdentityProvider((IdentityProvider)appIdentityProvider);
        Identity identity = identityManager.getOrCreateIdentity("apps", app.getId(), true);
        return identity;
    }

    private void init(JobDataMap dataMap) {
        this.pluginName = dataMap.getString("pluginName");
        this.targetActivityStream = dataMap.getString("targetActivityStream");
        this.portalContainer = dataMap.getString("portalContainer");
        this.feedUrl = dataMap.getString("feedURL");
        this.username = dataMap.getString("username");
        this.password = dataMap.getString("password");
    }

    private boolean severIsStarting(JobDataMap dataMap) {
        if (this.rampup > 1) {
            this.rampup = this.rampup - 1;
            LOG.debug((Object)("waiting #" + this.rampup));
            return true;
        }
        return false;
    }
}

