/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Random;
import org.chromattic.api.query.QueryBuilder;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.SpaceEntity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.query.WhereExpression;
import org.exoplatform.social.extras.injection.IdentityInjector;
import org.exoplatform.social.extras.injection.PatternInjectorConfig;
import org.exoplatform.social.extras.injection.utils.LoremIpsum4J;
import org.exoplatform.social.extras.injection.utils.NameGenerator;

public abstract class AbstractSocialInjector
extends DataInjector {
    private static Log LOG = ExoLogger.getLogger(IdentityInjector.class);
    private static final String DEFAULT_USER_BASE = "bench.user";
    private static final String DEFAULT_SPACE_BASE = "bench.space";
    protected final String password;
    protected static final String DOMAIN = "exoplatform.int";
    protected static int spaceSuffixValue = -1;
    protected static int userSuffixValue = -1;
    protected String spaceSuffixPattern = null;
    protected String userSuffixPattern = null;
    protected String userBase;
    protected String spaceBase;
    protected String spacePrettyBase;
    protected int userNumber;
    protected int spaceNumber;
    protected final IdentityManager identityManager;
    protected final IdentityStorage identityStorage;
    protected final RelationshipManager relationshipManager;
    protected final ActivityManager activityManager;
    protected final OrganizationService organizationService;
    protected final SpaceService spaceService;
    protected final UserHandler userHandler;
    protected final Random random;
    protected NameGenerator nameGenerator;
    protected LoremIpsum4J lorem;
    protected PortalContainer container = PortalContainer.getInstance();

    public AbstractSocialInjector(PatternInjectorConfig config) {
        this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
        this.identityStorage = (IdentityStorage)this.container.getComponentInstanceOfType(IdentityStorage.class);
        this.relationshipManager = (RelationshipManager)this.container.getComponentInstanceOfType(RelationshipManager.class);
        this.activityManager = (ActivityManager)this.container.getComponentInstanceOfType(ActivityManager.class);
        this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        this.organizationService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        this.userHandler = this.organizationService.getUserHandler();
        this.nameGenerator = new NameGenerator();
        this.random = new Random();
        this.lorem = new LoremIpsum4J();
        spaceSuffixValue = config.getSpaceSuffixValue();
        userSuffixValue = config.getUserSuffixValue();
        this.password = config.getUserPasswordValue();
    }

    public void init(String userPrefix, String spacePrefix) {
        this.userBase = userPrefix == null ? DEFAULT_USER_BASE : userPrefix;
        this.spaceBase = spacePrefix == null ? DEFAULT_SPACE_BASE : spacePrefix;
        this.spacePrettyBase = this.spaceBase.replace(".", "");
        this.userNumber = 0;
        this.spaceNumber = 0;
        boolean started = AbstractStorage.startSynchronization();
        try {
            this.userNumber = this.userNumber(this.userBase);
            this.spaceNumber = this.spaceNumber(this.spaceBase);
        }
        catch (UndeclaredThrowableException e) {
            LOG.info((Object)"No users/spaces existing.");
        }
        AbstractStorage.stopSynchronization((boolean)started);
        LOG.info((Object)("Initial user number : " + this.userNumber));
        LOG.info((Object)("Initial space number : " + this.spaceNumber));
    }

    public void init(String userPrefix, String spacePrefix, int userSuffixLength, int spaceSuffixLength) {
        this.init(userPrefix, spacePrefix);
        if (spaceSuffixLength > 0) {
            this.spaceSuffixPattern = "%s%0" + spaceSuffixLength + "d";
            LOG.info((Object)("Initial space suffix pattern : " + this.spaceSuffixPattern));
        } else {
            this.spaceSuffixPattern = null;
        }
        if (userSuffixLength > 0) {
            this.userSuffixPattern = "%s%0" + userSuffixLength + "d";
            LOG.info((Object)("Initial user suffix pattern : " + userSuffixLength));
        } else {
            this.userSuffixPattern = null;
        }
    }

    public Log getLog() {
        return ExoLogger.getExoLogger(((Object)((Object)this)).getClass());
    }

    public Object execute(HashMap<String, String> stringStringHashMap) throws Exception {
        return null;
    }

    public void reject(HashMap<String, String> stringStringHashMap) throws Exception {
    }

    private int userNumber(String base) {
        PortalContainer container = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
        QueryBuilder builder = lifeCycle.getSession().createQueryBuilder(IdentityEntity.class);
        WhereExpression where = new WhereExpression();
        where.like(IdentityEntity.remoteId, (Object)(base + "%")).or().like(IdentityEntity.remoteId, (Object)(base.toLowerCase() + "%"));
        return builder.where(where.toString()).get().objects().size();
    }

    private int spaceNumber(String base) {
        PortalContainer container = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
        QueryBuilder builder = lifeCycle.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression where = new WhereExpression();
        where.like(SpaceEntity.displayName, (Object)(base + "%"));
        return builder.where(where.toString()).get().objects().size();
    }

    protected String userName() {
        return this.userSuffixPattern != null ? this.userNameSuffixPattern() : this.userBase + this.userNumber;
    }

    protected String spaceName() {
        return this.spaceSuffixPattern != null ? this.spaceNameSuffixPattern() : this.spaceBase + this.spaceNumber;
    }

    private String userNameSuffixPattern() {
        return String.format(this.userSuffixPattern, this.userBase, this.userNumber);
    }

    protected String userNameSuffixPattern(int userNumber) {
        String result = this.userSuffixPattern != null ? String.format(this.userSuffixPattern, this.userBase, userNumber) : this.userBase + userNumber;
        return result;
    }

    protected String spaceNameSuffixPattern() {
        return String.format(this.spaceSuffixPattern, this.spaceBase, this.spaceNumber);
    }

    protected String spaceNameSuffixPattern(int spaceNumber) {
        String result = this.spaceSuffixPattern != null ? String.format(this.spaceSuffixPattern, this.spacePrettyBase, spaceNumber) : this.spacePrettyBase + spaceNumber;
        return result;
    }

    protected int param(HashMap<String, String> params, String name) {
        if (params == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String value = params.get(name);
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Integer number expected for property " + name));
        }
        return 0;
    }
}

