/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class NameGenerator {
    ArrayList<String> pre = new ArrayList();
    ArrayList<String> mid = new ArrayList();
    ArrayList<String> sur = new ArrayList();
    private static char[] vocals = new char[]{'a', 'e', 'i', 'o', 'u', '\u00e4', '\u00f6', '\u00f5', '\u00fc', 'y'};
    private static char[] consonants = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y'};
    private static final String ROMAN_SYLLABES = "-a\n-al\n-au +c\n-an\n-ba\n-be\n-bi\n-br +v\n-da\n-di\n-do\n-du\n-e\n-eu +c\n-fa\nbi\nbe\nbo\nbu\nnul +v\ngu\nda\nau +c -c\nfri\ngus\n+tus\n+lus\n+lius\n+nus\n+es\n+ius -c\n+cus\n+tor\n+cio\n+tin";
    private String syllabes;

    public NameGenerator(String syllabes) {
        this.syllabes = syllabes;
        this.refresh();
    }

    public NameGenerator() {
        this(ROMAN_SYLLABES);
    }

    public void changeSyllabes(String syllabes) {
        if (syllabes == null) {
            throw new RuntimeException("Syllabes cannot be null");
        }
        this.syllabes = syllabes;
        this.refresh();
    }

    public void refresh() {
        try {
            StringReader sReader = new StringReader(this.syllabes);
            BufferedReader bufRead = new BufferedReader(sReader);
            String line = "";
            while (line != null) {
                line = bufRead.readLine();
                if (line == null || line.equals("")) continue;
                if (line.charAt(0) == '-') {
                    this.pre.add(line.substring(1).toLowerCase());
                    continue;
                }
                if (line.charAt(0) == '+') {
                    this.sur.add(line.substring(1).toLowerCase());
                    continue;
                }
                this.mid.add(line.toLowerCase());
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String upper(String s) {
        return s.substring(0, 1).toUpperCase().concat(s.substring(1));
    }

    private boolean containsConsFirst(ArrayList<String> array) {
        for (String s : array) {
            if (!this.consonantFirst(s)) continue;
            return true;
        }
        return false;
    }

    private boolean containsVocFirst(ArrayList<String> array) {
        for (String s : array) {
            if (!this.vocalFirst(s)) continue;
            return true;
        }
        return false;
    }

    private boolean allowCons(ArrayList<String> array) {
        for (String s : array) {
            if (!this.hatesPreviousVocals(s) && this.hatesPreviousConsonants(s)) continue;
            return true;
        }
        return false;
    }

    private boolean allowVocs(ArrayList<String> array) {
        for (String s : array) {
            if (!this.hatesPreviousConsonants(s) && this.hatesPreviousVocals(s)) continue;
            return true;
        }
        return false;
    }

    private boolean expectsVocal(String s) {
        return s.substring(1).contains("+v");
    }

    private boolean expectsConsonant(String s) {
        return s.substring(1).contains("+c");
    }

    private boolean hatesPreviousVocals(String s) {
        return s.substring(1).contains("-c");
    }

    private boolean hatesPreviousConsonants(String s) {
        return s.substring(1).contains("-v");
    }

    private String pureSyl(String s) {
        if ((s = s.trim()).charAt(0) == '+' || s.charAt(0) == '-') {
            s = s.substring(1);
        }
        return s.split(" ")[0];
    }

    private boolean vocalFirst(String s) {
        return String.copyValueOf(vocals).contains(String.valueOf(s.charAt(0)).toLowerCase());
    }

    private boolean consonantFirst(String s) {
        return String.copyValueOf(consonants).contains(String.valueOf(s.charAt(0)).toLowerCase());
    }

    private boolean vocalLast(String s) {
        return String.copyValueOf(vocals).contains(String.valueOf(s.charAt(s.length() - 1)).toLowerCase());
    }

    private boolean consonantLast(String s) {
        return String.copyValueOf(consonants).contains(String.valueOf(s.charAt(s.length() - 1)).toLowerCase());
    }

    public String compose(int syls) {
        int c;
        if (syls > 2 && this.mid.size() == 0) {
            throw new RuntimeException("You are trying to create a name with more than 3 parts, which requires middle parts, which you have none in the file " + this.syllabes + ". You should add some. Every word, which doesn't have + or - for a prefix is counted as a middle part.");
        }
        if (this.pre.size() == 0) {
            throw new RuntimeException("You have no prefixes to start creating a name. add some and use \"-\" prefix, to identify it as a prefix for a name. (example: -asd)");
        }
        if (this.sur.size() == 0) {
            throw new RuntimeException("You have no suffixes to end a name. add some and use \"+\" prefix, to identify it as a suffix for a name. (example: +asd)");
        }
        if (syls < 1) {
            throw new RuntimeException("compose(int syls) can't have less than 1 syllable");
        }
        int expecting = 0;
        int last = 0;
        int a = (int)(Math.random() * (double)this.pre.size());
        last = this.vocalLast(this.pureSyl(this.pre.get(a))) ? 1 : 2;
        if (syls > 2) {
            if (this.expectsVocal(this.pre.get(a))) {
                expecting = 1;
                if (!this.containsVocFirst(this.mid)) {
                    throw new RuntimeException("Expecting \"middle\" part starting with vocal, but there is none. You should add one, or remove requirement for one.. ");
                }
            }
            if (this.expectsConsonant(this.pre.get(a))) {
                expecting = 2;
                if (!this.containsConsFirst(this.mid)) {
                    throw new RuntimeException("Expecting \"middle\" part starting with consonant, but there is none. You should add one, or remove requirement for one.. ");
                }
            }
        } else {
            if (this.expectsVocal(this.pre.get(a))) {
                expecting = 1;
                if (!this.containsVocFirst(this.sur)) {
                    throw new RuntimeException("Expecting \"suffix\" part starting with vocal, but there is none. You should add one, or remove requirement for one.. ");
                }
            }
            if (this.expectsConsonant(this.pre.get(a))) {
                expecting = 2;
                if (!this.containsConsFirst(this.sur)) {
                    throw new RuntimeException("Expecting \"suffix\" part starting with consonant, but there is none. You should add one, or remove requirement for one.. ");
                }
            }
        }
        if (this.vocalLast(this.pureSyl(this.pre.get(a))) && !this.allowVocs(this.mid)) {
            throw new RuntimeException("Expecting \"middle\" part that allows last character of prefix to be a vocal, but there is none. You should add one, or remove requirements that cannot be fulfilled.. the prefix used, was : \"" + this.pre.get(a) + "\", whichmeans there should be a part available, that has \"-v\" requirement or no requirements for previous syllables at all.");
        }
        if (this.consonantLast(this.pureSyl(this.pre.get(a))) && !this.allowCons(this.mid)) {
            throw new RuntimeException("Expecting \"middle\" part that allows last character of prefix to be a consonant, but there is none. You should add one, or remove requirements that cannot be fulfilled.. the prefix used, was : \"" + this.pre.get(a) + "\", whichmeans there should be a part available, that has \"-c\" requirement or no requirements for previous syllables at all.");
        }
        int[] b = new int[syls];
        for (int i = 0; i < b.length - 2; ++i) {
            do {
                b[i] = (int)(Math.random() * (double)this.mid.size());
            } while (expecting == 1 && !this.vocalFirst(this.pureSyl(this.mid.get(b[i]))) || expecting == 2 && !this.consonantFirst(this.pureSyl(this.mid.get(b[i]))) || last == 1 && this.hatesPreviousVocals(this.mid.get(b[i])) || last == 2 && this.hatesPreviousConsonants(this.mid.get(b[i])));
            expecting = 0;
            if (this.expectsVocal(this.mid.get(b[i]))) {
                expecting = 1;
                if (i < b.length - 3 && !this.containsVocFirst(this.mid)) {
                    throw new RuntimeException("Expecting \"middle\" part starting with vocal, but there is none. You should add one, or remove requirement for one.. ");
                }
                if (i == b.length - 3 && !this.containsVocFirst(this.sur)) {
                    throw new RuntimeException("Expecting \"suffix\" part starting with vocal, but there is none. You should add one, or remove requirement for one.. ");
                }
            }
            if (this.expectsConsonant(this.mid.get(b[i]))) {
                expecting = 2;
                if (i < b.length - 3 && !this.containsConsFirst(this.mid)) {
                    throw new RuntimeException("Expecting \"middle\" part starting with consonant, but there is none. You should add one, or remove requirement for one.. ");
                }
                if (i == b.length - 3 && !this.containsConsFirst(this.sur)) {
                    throw new RuntimeException("Expecting \"suffix\" part starting with consonant, but there is none. You should add one, or remove requirement for one.. ");
                }
            }
            if (this.vocalLast(this.pureSyl(this.mid.get(b[i]))) && !this.allowVocs(this.mid) && syls > 3) {
                throw new RuntimeException("Expecting \"middle\" part that allows last character of last syllable to be a vocal, but there is none. You should add one, or remove requirements that cannot be fulfilled.. the part used, was : \"" + this.mid.get(b[i]) + "\", which means there should be a part available, that has \"-v\" requirement or no requirements for previous syllables at all.");
            }
            if (this.consonantLast(this.pureSyl(this.mid.get(b[i]))) && !this.allowCons(this.mid) && syls > 3) {
                throw new RuntimeException("Expecting \"middle\" part that allows last character of last syllable to be a consonant, but there is none. You should add one, or remove requirements that cannot be fulfilled.. the part used, was : \"" + this.mid.get(b[i]) + "\", which means there should be a part available, that has \"-c\" requirement or no requirements for previous syllables at all.");
            }
            if (i == b.length - 3) {
                if (this.vocalLast(this.pureSyl(this.mid.get(b[i]))) && !this.allowVocs(this.sur)) {
                    throw new RuntimeException("Expecting \"suffix\" part that allows last character of last syllable to be a vocal, but there is none. You should add one, or remove requirements that cannot be fulfilled.. the part used, was : \"" + this.mid.get(b[i]) + "\", which means there should be a suffix available, that has \"-v\" requirement or no requirements for previous syllables at all.");
                }
                if (this.consonantLast(this.pureSyl(this.mid.get(b[i]))) && !this.allowCons(this.sur)) {
                    throw new RuntimeException("Expecting \"suffix\" part that allows last character of last syllable to be a consonant, but there is none. You should add one, or remove requirements that cannot be fulfilled.. the part used, was : \"" + this.mid.get(b[i]) + "\", which means there should be a suffix available, that has \"-c\" requirement or no requirements for previous syllables at all.");
                }
            }
            last = this.vocalLast(this.pureSyl(this.mid.get(b[i]))) ? 1 : 2;
        }
        do {
            c = (int)(Math.random() * (double)this.sur.size());
        } while (expecting == 1 && !this.vocalFirst(this.pureSyl(this.sur.get(c))) || expecting == 2 && !this.consonantFirst(this.pureSyl(this.sur.get(c))) || last == 1 && this.hatesPreviousVocals(this.sur.get(c)) || last == 2 && this.hatesPreviousConsonants(this.sur.get(c)));
        String name = this.upper(this.pureSyl(this.pre.get(a).toLowerCase()));
        for (int i = 0; i < b.length - 2; ++i) {
            name = name.concat(this.pureSyl(this.mid.get(b[i]).toLowerCase()));
        }
        if (syls > 1) {
            name = name.concat(this.pureSyl(this.sur.get(c).toLowerCase()));
        }
        return name;
    }
}

