/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.link;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;

public final class UILinkUtil {
    private static Pattern pattern = Pattern.compile("(?-i)(\\.jpg|\\.gif|\\.jpeg|\\.bmp|\\.png|\\.tif)($|\\?.*)");

    public static boolean isImageLink(String link) {
        if (link == null || link.trim().length() == 0) {
            return false;
        }
        return pattern.matcher(link).find();
    }

    public static String simpleEscapeHtml(String input) {
        if (input == null || input.trim().length() == 0) {
            return "";
        }
        int length = input.length();
        StringBuilder writer = new StringBuilder((int)((double)length * 1.5));
        block6: for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '<': {
                    writer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    writer.append("&gt;");
                    continue block6;
                }
                case '\'': {
                    writer.append("&#39;");
                    continue block6;
                }
                case '\"': {
                    writer.append("&#34;");
                    continue block6;
                }
                default: {
                    writer.append(ch);
                }
            }
        }
        return writer.toString();
    }

    public static String encodeURI(String input) {
        if (input == null || input.trim().length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
    }
}

