/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.spaceaccess;

import java.util.HashMap;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import juzu.Action;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.template.Template;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;

public class Controller {
    @Inject
    @Path(value="index.gtmpl")
    Template message;
    @Inject
    SpaceService spaceService;
    private static final String ALL_SPACE_LINK = "all-spaces";

    @View
    public void index() throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)WebuiRequestContext.getCurrentInstance();
        Object statusObject = pcontext.getRequest().getSession().getAttribute("social.accessed.space.type.key");
        Object spacePrettyNameObj = pcontext.getRequest().getSession().getAttribute("social.accessed.space.key");
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (spacePrettyNameObj == null) {
            parameters.put("status", statusObject != null ? statusObject.toString() : "");
            parameters.put("spaceDisplayName", "");
            parameters.put("spacePrettyName", "");
            parameters.put("redirectURI", statusObject != null ? Utils.getURI((String)ALL_SPACE_LINK) : "");
            this.message.with(parameters).render();
            return;
        }
        String status = statusObject.toString();
        String spacePrettyName = spacePrettyNameObj.toString();
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        String spaceDisplayName = space.getDisplayName();
        if ("social.space.access.not-access-wiki-space".equals(status)) {
            Object wikiPageObj = pcontext.getRequest().getSession().getAttribute("social.accessed.space.wiki.page.key");
            pcontext.sendRedirect(this.getPermanWikiLink(spacePrettyName, wikiPageObj.toString()));
            return;
        }
        parameters.put("status", status);
        parameters.put("spaceDisplayName", spaceDisplayName);
        parameters.put("spacePrettyName", spacePrettyName);
        parameters.put("redirectURI", "");
        this.message.with(parameters).render();
    }

    @Action
    public Response.Redirect accept(String spacePrettyName) {
        String remoteId = Utils.getOwnerRemoteId();
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        this.spaceService.addMember(space, remoteId);
        return Response.redirect((String)Utils.getSpaceHomeURL((Space)space));
    }

    @Action
    public Response.Redirect requestToJoin(String spacePrettyName) {
        String remoteId = Utils.getOwnerRemoteId();
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        this.spaceService.addPendingUser(space, remoteId);
        return Response.redirect((String)Utils.getSpaceHomeURL((Space)space));
    }

    @Action
    public Response.Redirect refuse(String spacePrettyName) {
        String remoteId = Utils.getOwnerRemoteId();
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        this.spaceService.removeInvitedUser(space, remoteId);
        return Response.redirect((String)Utils.getURI((String)ALL_SPACE_LINK));
    }

    @Action
    public Response.Redirect join(String spacePrettyName) {
        String remoteId = Utils.getOwnerRemoteId();
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        this.spaceService.addMember(space, remoteId);
        PortalRequestContext pcontext = (PortalRequestContext)WebuiRequestContext.getCurrentInstance();
        String originalRequest = pcontext.getRequest().getSession().getAttribute("social.accessed.space.request.path.key").toString();
        pcontext.getRequest().getSession().removeAttribute("social.accessed.space.request.path.key");
        return Response.redirect((String)originalRequest);
    }

    private String getPermanWikiLink(String spacePrettyName, String wikiPage) {
        StringBuilder sb = new StringBuilder("wiki/group/spaces/").append(spacePrettyName).append("/").append(wikiPage);
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), sb.toString());
        return nodeURL.setResource(resource).toString();
    }

    @PreDestroy
    public void cleanSession() {
        PortalRequestContext pcontext = (PortalRequestContext)WebuiRequestContext.getCurrentInstance();
        pcontext.getRequest().getSession().removeAttribute("social.accessed.space.key");
        pcontext.getRequest().getSession().removeAttribute("social.accessed.space.type.key");
    }
}

