/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.userNotification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.impl.common.Tools;
import juzu.impl.io.AppendableStream;
import juzu.impl.request.Request;
import juzu.io.Stream;
import juzu.request.ApplicationContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.GroupProvider;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;

public class UserNotificationSetting {
    private static final Log LOG = ExoLogger.getLogger(UserNotificationSetting.class);
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    @Path(value="UIChannelContainer.gtmpl")
    Template channelContainer;
    @Inject
    ResourceBundle bundle;
    @Inject
    PluginSettingService pluginSettingService;
    @Inject
    ChannelManager channelManager;
    @Inject
    UserSettingService userSettingService;
    private static final String DAILY = "Daily";
    private static final String WEEKLY = "Weekly";
    private static final String NEVER = "Never";
    private static final String SELECT_BOX_PREFIX = "SelectBox";
    private Locale locale = Locale.ENGLISH;

    @View
    public Response index(ApplicationContext applicationContext, UserContext userContext) {
        if (!CommonsUtils.isFeatureActive((String)"notification")) {
            return this.redirectToHomePage();
        }
        if (this.bundle == null) {
            this.locale = userContext.getLocale();
            this.bundle = applicationContext.resolveBundle(this.locale);
        }
        return this.index.ok(this.parameters()).withCharset(Tools.UTF_8);
    }

    @Ajax
    @POST
    @Resource
    public Response saveSetting(String pluginId, String channels, String digest) {
        JSON data = new JSON();
        try {
            UserSetting setting = this.userSettingService.get(this.getRemoteUser());
            if (WEEKLY.equals(digest)) {
                setting.addPlugin(pluginId, UserSetting.FREQUENCY.WEEKLY);
            } else if (DAILY.equals(digest)) {
                setting.addPlugin(pluginId, UserSetting.FREQUENCY.DAILY);
            } else {
                setting.removePlugin(pluginId, UserSetting.FREQUENCY.WEEKLY);
                setting.removePlugin(pluginId, UserSetting.FREQUENCY.DAILY);
            }
            Map<String, String> datas = this.parserParams(channels);
            for (String channelId : datas.keySet()) {
                if (Boolean.valueOf(datas.get(channelId)).booleanValue()) {
                    setting.addChannelPlugin(channelId, pluginId);
                    continue;
                }
                setting.removeChannelPlugin(channelId, pluginId);
            }
            this.userSettingService.save(setting);
            data.set("ok", (Object)"true");
            data.set("status", (Object)"true");
            data.set("context", (Object)this.getChannelContainer(setting, pluginId));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save user settings: ", (Throwable)e);
            data.set("ok", (Object)"false");
            data.set("status", (Object)e.toString());
        }
        return Response.ok((CharSequence)data.toString()).withMimeType("application/json").withCharset(Tools.UTF_8);
    }

    private List<String> getChannels() {
        ArrayList<String> channels = new ArrayList<String>();
        for (AbstractChannel channel : this.channelManager.getChannels()) {
            channels.add(channel.getId());
        }
        return channels;
    }

    private String getChannelContainer(UserSetting setting, String pluginId) {
        List<String> channels = this.getChannels();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Context context = new Context(this.bundle);
        parameters.put("_ctx", context);
        Map<String, String> options = this.buildOptions(context);
        HashMap<String, Boolean> channelStatus = new HashMap<String, Boolean>();
        HashMap<String, CheckBoxInput> channelCheckBoxList = new HashMap<String, CheckBoxInput>();
        parameters.put("emailSelectBox", null);
        for (String channelId : channels) {
            if (!this.pluginSettingService.isActive(channelId, pluginId)) continue;
            boolean isChannelActive = setting.isChannelActive(channelId);
            channelStatus.put(channelId, isChannelActive);
            channelCheckBoxList.put(channelId, new CheckBoxInput(channelId, pluginId, setting.isActive(channelId, pluginId), isChannelActive));
            if (!UserSetting.EMAIL_CHANNEL.equals(channelId)) continue;
            parameters.put("emailSelectBox", new SelectBoxInput(channelId + pluginId, options, this.getValue(setting, pluginId), isChannelActive));
        }
        parameters.put("channels", channels);
        parameters.put("channelCheckBoxList", channelCheckBoxList);
        parameters.put("channelStatus", channelStatus);
        parameters.put("emailChannel", UserSetting.EMAIL_CHANNEL);
        parameters.put("pluginId", pluginId);
        StringBuilder buffer = new StringBuilder();
        this.channelContainer.renderTo((Stream)new AppendableStream(Tools.UTF_8, (Appendable)buffer), parameters);
        return buffer.toString();
    }

    @Ajax
    @Resource
    public Response saveActiveStatus(String channelId, String enable) {
        JSON data = new JSON();
        try {
            UserSetting setting = this.userSettingService.get(this.getRemoteUser());
            if (enable.equals("true") || enable.equals("false")) {
                if (enable.equals("true")) {
                    setting.setChannelActive(channelId);
                } else {
                    setting.removeChannelActive(channelId);
                }
                this.userSettingService.save(setting);
            }
            data.set("ok", (Object)"true");
            data.set("type", (Object)channelId);
            data.set("enable", (Object)enable);
            StringBuilder buffer = new StringBuilder();
            this.index.renderTo((Stream)new AppendableStream(Tools.UTF_8, (Appendable)buffer), this.parameters());
            data.set("context", (Object)buffer.toString());
        }
        catch (Exception e) {
            data.set("ok", (Object)"false");
            data.set("status", (Object)e.toString());
            return new Response.Error("Exception in switching stat of provider " + channelId + ". " + e.toString());
        }
        return Response.ok((CharSequence)data.toString()).withMimeType("application/json").withCharset(Tools.UTF_8);
    }

    @Ajax
    @Resource
    public Response resetSetting(String params) {
        try {
            UserSetting setting = this.userSettingService.getDefaultSettings();
            this.userSettingService.save(setting.setUserId(this.getRemoteUser()));
        }
        catch (Exception e) {
            return new Response.Error("Error to save default notification user setting" + e.toString());
        }
        return this.index.ok(this.parameters()).withMimeType("text/html").withCharset(Tools.UTF_8);
    }

    private String getRemoteUser() {
        return Request.getCurrent().getSecurityContext().getRemoteUser();
    }

    private Map<String, Object> parameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Context context = new Context(this.bundle);
        parameters.put("_ctx", context);
        UserSetting setting = this.userSettingService.get(this.getRemoteUser());
        List groups = this.pluginSettingService.getGroupPlugins();
        parameters.put("groups", groups);
        boolean hasActivePlugin = false;
        HashMap<String, SelectBoxInput> emailSelectBoxList = new HashMap<String, SelectBoxInput>();
        HashMap<String, CheckBoxInput> channelCheckBoxList = new HashMap<String, CheckBoxInput>();
        Map<String, String> options = this.buildOptions(context);
        List<String> channels = this.getChannels();
        for (GroupProvider groupProvider : this.pluginSettingService.getGroupPlugins()) {
            for (PluginInfo info : groupProvider.getPluginInfos()) {
                String pluginId = info.getType();
                for (String channelId : channels) {
                    if (!info.isChannelActive(channelId)) continue;
                    hasActivePlugin = true;
                    boolean isChannelActive = setting.isChannelActive(channelId);
                    channelCheckBoxList.put(channelId + pluginId, new CheckBoxInput(channelId, pluginId, setting.isActive(channelId, pluginId), isChannelActive));
                    if (!UserSetting.EMAIL_CHANNEL.equals(channelId)) continue;
                    emailSelectBoxList.put(pluginId, new SelectBoxInput(channelId + pluginId, options, this.getValue(setting, pluginId), isChannelActive));
                }
            }
        }
        parameters.put("hasActivePlugin", hasActivePlugin);
        parameters.put("emailSelectBoxList", emailSelectBoxList);
        parameters.put("channelCheckBoxList", channelCheckBoxList);
        HashMap<String, Boolean> channelStatus = new HashMap<String, Boolean>();
        for (String channelId : channels) {
            channelStatus.put(channelId, setting.isChannelActive(channelId));
        }
        parameters.put("channelStatus", channelStatus);
        parameters.put("channels", channels);
        parameters.put("emailChannel", UserSetting.EMAIL_CHANNEL);
        return parameters;
    }

    private String makeSelectBoxId(String pluginId) {
        return new StringBuffer(pluginId).append(SELECT_BOX_PREFIX).toString();
    }

    private String getValue(UserSetting setting, String pluginId) {
        if (setting.isInWeekly(pluginId)) {
            return WEEKLY;
        }
        if (setting.isInDaily(pluginId)) {
            return DAILY;
        }
        return NEVER;
    }

    private Map<String, String> buildOptions(Context context) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(DAILY, context.appRes("UINotification.label.Daily"));
        options.put(WEEKLY, context.appRes("UINotification.label.Weekly"));
        options.put(NEVER, context.appRes("UINotification.label.Never"));
        return options;
    }

    private Map<String, String> parserParams(String params) {
        HashMap<String, String> datas = new HashMap<String, String>();
        String[] arrays = params.split("&");
        for (int i = 0; i < arrays.length; ++i) {
            String[] data = arrays[i].split("=");
            datas.put(data[0], data[1]);
        }
        return datas;
    }

    private Response.Redirect redirectToHomePage() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest currentServletRequest = portalRequestContext.getRequest();
        StringBuilder sb = new StringBuilder();
        sb.append(currentServletRequest.getScheme()).append("://").append(currentServletRequest.getServerName()).append(":").append(currentServletRequest.getServerPort()).append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(portalRequestContext.getPortalOwner());
        WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jsManager = ctx.getJavascriptManager();
        jsManager.addJavascript((CharSequence)("try { window.location.href='" + sb.toString() + "' } catch(e) {window.location.href('" + sb.toString() + "') }"));
        return Response.redirect((String)sb.toString());
    }

    public class SelectBoxInput {
        public static final String NEVER = "Never";
        public static final String DAILY = "Daily";
        public static final String WEEKLY = "Weekly";
        private final String name;
        private final Map<String, String> options;
        private final String selectedId;
        private final boolean isActive;

        public SelectBoxInput(String name, Map<String, String> options, String selectedId, boolean isActive) {
            this.name = name;
            this.options = options;
            this.selectedId = selectedId;
            this.isActive = isActive;
        }

        public String getName() {
            return this.name;
        }

        public String getSelectedId() {
            return this.selectedId;
        }

        public String getValueLabel() {
            if (this.options.containsKey(this.selectedId)) {
                return this.options.get(this.selectedId);
            }
            return this.selectedId;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean isActiveSend() {
            return !"Never".equals(this.selectedId);
        }

        public String render() {
            String selected = "";
            String id = UserNotificationSetting.this.makeSelectBoxId(this.name);
            StringBuffer buffer = new StringBuffer("<span class=\"uiSelectbox\">");
            buffer.append("<select name=\"").append(id).append("\" id=\"").append(id).append("\"").append(!this.isActive ? " disabled " : "").append(" class=\"selectbox input-small\">");
            for (String key : this.options.keySet()) {
                selected = key.equals(this.selectedId) ? " selected=\"selected\" " : "";
                buffer.append("<option value=\"").append(key).append("\" class=\"option\"").append(selected).append(">").append(this.options.get(key)).append("</option>");
            }
            buffer.append("</select>").append("</span>");
            return buffer.toString();
        }
    }

    public class CheckBoxInput {
        private final String pluginId;
        private final String channelId;
        private final boolean isChecked;
        private final boolean isActive;

        public CheckBoxInput(String channelId, String pluginId, boolean isChecked, boolean isActive) {
            this.pluginId = pluginId;
            this.channelId = channelId;
            this.isActive = isActive;
            this.isChecked = isChecked;
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public String render(String label) {
            String name = this.channelId + this.pluginId;
            StringBuffer buffer = new StringBuffer("<label class=\"uiCheckbox\" for=\"").append(name).append("\">");
            buffer.append("<input type=\"checkbox\" class=\"checkbox\" ").append(this.isChecked ? "checked=\"checked\" " : "").append(!this.isActive ? "disabled " : "").append("name=\"").append(name).append("\" id=\"").append(name).append("\" ").append("data-channel=\"").append(this.channelId).append("\" />").append("<span>").append(label).append("</span></label>");
            return buffer.toString();
        }
    }

    public class Context {
        ResourceBundle rs;

        public Context(ResourceBundle rs) {
            this.rs = rs;
        }

        public String appRes(String key) {
            try {
                return this.rs.getString(key).replaceAll("'", "&#39;").replaceAll("\"", "&#34;");
            }
            catch (MissingResourceException e) {
                LOG.debug((Object)("Can't find resource for bundle key " + key));
                if (key.indexOf("checkbox-") > 0) {
                    return this.appRes("UINotification.label.checkbox.default").replace("{0}", this.capitalizeFirstLetter(key.split("-")[1]));
                }
                if (key.indexOf("channel-") > 0) {
                    return this.appRes("UINotification.label.channel.default").replace("{0}", this.capitalizeFirstLetter(key.split("-")[1]));
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Error when get resource bundle key " + key), (Throwable)e);
            }
            return this.capitalizeFirstLetter(key.substring(key.lastIndexOf(".") + 1));
        }

        private String getBundlePath(String id) {
            PluginConfig pluginConfig = UserNotificationSetting.this.pluginSettingService.getPluginConfig(id);
            if (pluginConfig != null) {
                return pluginConfig.getBundlePath();
            }
            if (GroupProvider.defaultGroupIds.contains(id)) {
                return UserNotificationSetting.this.pluginSettingService.getPluginConfig("DigestDailyPlugin").getBundlePath();
            }
            List groups = UserNotificationSetting.this.pluginSettingService.getGroupPlugins();
            for (GroupProvider groupProvider : groups) {
                if (!groupProvider.getGroupId().equals(id)) continue;
                return ((PluginInfo)groupProvider.getPluginInfos().get(0)).getBundlePath();
            }
            return "";
        }

        public String pluginRes(String key, String id) {
            String path = this.getBundlePath(id);
            return TemplateUtils.getResourceBundle((String)key, (Locale)UserNotificationSetting.this.bundle.getLocale(), (String)path);
        }

        public String getChannelKey(String channelId) {
            return channelId.replace("_CHANNEL", "").toLowerCase();
        }

        public String capitalizeFirstLetter(String original) {
            return original.length() <= 1 ? original : original.substring(0, 1).toUpperCase() + original.substring(1);
        }
    }
}

