/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.ResourceURL;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.user.portlet.UserProfileHelper;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIPortletApplication;
import org.json.JSONObject;

public abstract class UIAbstractUserPortlet
extends UIPortletApplication {
    protected Profile currentProfile;

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        this.beforeProcessRender(context);
        super.processRender(app, context);
        this.afterProcessRender(context);
    }

    public void beforeProcessRender(WebuiRequestContext context) {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        PortletMode portletMode = portletReqContext.getApplicationMode();
        if (portletMode == PortletMode.VIEW) {
            Identity ownerIdentity = Utils.getOwnerIdentity((boolean)true);
            this.currentProfile = ownerIdentity.getProfile();
        }
    }

    public void afterProcessRender(WebuiRequestContext context) {
    }

    protected boolean isOwner() {
        return Utils.isOwner();
    }

    protected String getCurrentRemoteId() {
        return this.currentProfile.getIdentity().getRemoteId();
    }

    protected void initProfilePopup() throws Exception {
        JSONObject object = new JSONObject();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        object.put("StatusTitle", (Object)UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UserProfilePopup.label.Loading"));
        String[] keys = new String[]{"Connect", "Confirm", "CancelRequest", "RemoveConnection", "Ignore"};
        for (int i = 0; i < keys.length; ++i) {
            object.put(keys[i], (Object)UserProfileHelper.getLabel((WebuiRequestContext)context, (String)("UserProfilePopup.label." + keys[i])));
        }
        context.getJavascriptManager().getRequireJS().require("SHARED/social-ui-profile", "profile" + this.getId()).addScripts("profile" + this.getId() + ".initUserProfilePopup('" + this.getId() + "', " + object.toString() + ");");
    }

    protected String buildResourceURL(String key) {
        try {
            WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            MimeResponse res = (MimeResponse)ctx.getResponse();
            ResourceURL rsURL = res.createResourceURL();
            rsURL.setResourceID(key);
            return rsURL.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

