/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserProfileHelper {
    public static final String CSS_ICON_PREFIX = "uiIconSoc";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String URL_KEY = "url";
    public static final String OTHER_KEY = "other";
    public static final String DEFAULT_PROTOCOL = "http://";
    private static final Pattern ESCAPE_HTML_PATTERN = Pattern.compile("<(.*?)>", 2);
    private static final Pattern UNESCAPE_HTML_PATTERN = Pattern.compile("&lt;(.*?)&gt;", 2);

    public static Map<String, Object> getDisplayProfileInfo(Profile currentProfile) {
        String gender;
        String jobTitle;
        LinkedHashMap<String, Object> infos = new LinkedHashMap<String, Object>();
        String email = currentProfile.getEmail();
        if (!UserProfileHelper.isEmpty((String)email)) {
            infos.put("email", email);
        }
        if (!UserProfileHelper.isEmpty((String)(jobTitle = currentProfile.getPosition()))) {
            infos.put("position", UserProfileHelper.encodeHTML((String)jobTitle));
        }
        if (!UserProfileHelper.isEmpty((String)(gender = currentProfile.getGender()))) {
            infos.put("gender", UserProfileHelper.encodeHTML((String)gender));
        }
        UserProfileHelper.putInfoData((Profile)currentProfile, infos, (String)"phones");
        UserProfileHelper.putInfoData((Profile)currentProfile, infos, (String)"ims");
        UserProfileHelper.putInfoData((Profile)currentProfile, infos, (String)"urls");
        return infos;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static List<Map<String, String>> getDisplayExperience(Profile currentProfile) throws Exception {
        ArrayList<Map<String, String>> pastExperiences = new ArrayList<Map<String, String>>();
        ArrayList<Map> lastExperiences = new ArrayList<Map>();
        List experiences = UserProfileHelper.getMultiValues((Profile)currentProfile, (String)"experiences");
        if (experiences != null) {
            for (Map srcExperience : experiences) {
                if (UserProfileHelper.isCurrent((Map)srcExperience)) {
                    pastExperiences.add(UserProfileHelper.theExperienceData((Map)srcExperience, (boolean)true));
                    continue;
                }
                lastExperiences.add(UserProfileHelper.theExperienceData((Map)srcExperience, (boolean)false));
            }
            pastExperiences.addAll(lastExperiences);
        }
        return pastExperiences;
    }

    public static List<Map<String, String>> getMultiValues(Profile currentProfile, String key) {
        return (List)currentProfile.getProperty(key);
    }

    public static List<String> getURLValues(Profile currentProfile) {
        List mapUrls = UserProfileHelper.getMultiValues((Profile)currentProfile, (String)"urls");
        ArrayList<String> urls = new ArrayList<String>();
        if (mapUrls != null) {
            for (Map map : mapUrls) {
                urls.add(UserProfileHelper.decodeHTML((String)((String)map.get("value"))));
            }
        }
        return urls;
    }

    public static boolean isString(Object s) {
        return s instanceof String;
    }

    public static boolean isURL(String key) {
        if (key == null) {
            return false;
        }
        return "urls".equals(key);
    }

    public static String toAbsoluteURL(String url) {
        try {
            URI uri = new URI(url);
            if (uri.isAbsolute()) {
                return url;
            }
        }
        catch (URISyntaxException e) {
            return "http://" + url;
        }
        return "http://" + url;
    }

    public static boolean isIMs(String key) {
        if (key == null) {
            return false;
        }
        return "ims".equals(key);
    }

    public static boolean isGender(String key) {
        if (key == null) {
            return false;
        }
        return "gender".equals(key);
    }

    public static String getIconCss(String key) {
        StringBuilder classBuilder = new StringBuilder();
        if (key.length() > 0) {
            classBuilder.append("uiIconSoc").append(Character.toUpperCase(key.charAt(0)));
            if (key.length() > 1) {
                classBuilder.append(key.substring(1));
            }
        }
        return classBuilder.toString();
    }

    private static Map<String, String> theExperienceData(Map<String, String> srcExperience, boolean isCurrent) {
        LinkedHashMap<String, String> experience = new LinkedHashMap<String, String>();
        UserProfileHelper.putExperienceData(srcExperience, experience, (String)"company");
        UserProfileHelper.putExperienceData(srcExperience, experience, (String)"position");
        UserProfileHelper.putExperienceData(srcExperience, experience, (String)"description");
        UserProfileHelper.putExperienceData(srcExperience, experience, (String)"skills");
        UserProfileHelper.putExperienceData(srcExperience, experience, (String)"startDate");
        if (isCurrent) {
            experience.put("isCurrent", "true");
        } else {
            UserProfileHelper.putExperienceData(srcExperience, experience, (String)"endDate");
        }
        return experience;
    }

    private static boolean isCurrent(Map<String, String> srcExperience) {
        return Boolean.valueOf(String.valueOf(srcExperience.get("isCurrent")));
    }

    private static void putExperienceData(Map<String, String> srcExperience, Map<String, String> destExperience, String key) {
        String value = srcExperience.get(key);
        if (!UserProfileHelper.isEmpty((String)value)) {
            destExperience.put(key, value);
        }
    }

    public static String getLabel(WebuiRequestContext context, String key) {
        if (context == null) {
            context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        }
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString(key);
        }
        catch (Exception e) {
            return key.indexOf(".") > 0 ? key.substring(key.lastIndexOf(".") + 1) : key;
        }
    }

    private static void putInfoData(Profile currentProfile, Map<String, Object> infos, String mainKey) {
        List multiValues = UserProfileHelper.getMultiValues((Profile)currentProfile, (String)mainKey);
        if (multiValues != null && multiValues.size() > 0) {
            HashMap mainValue = new HashMap();
            ArrayList valuesOfOther = new ArrayList();
            for (Map map : multiValues) {
                ArrayList<String> values = new ArrayList<String>();
                String key = (String)map.get("key");
                String value = UserProfileHelper.encodeHTML((String)((String)map.get("value")));
                if (mainValue.containsKey(key)) {
                    values.addAll((Collection)mainValue.get(key));
                    values.add(value);
                } else {
                    values.add(value);
                }
                if ("other".equals(key)) {
                    valuesOfOther.addAll(values);
                    continue;
                }
                mainValue.put(key, values);
            }
            if (valuesOfOther.size() > 0) {
                LinkedHashMap newValues = new LinkedHashMap();
                newValues.putAll(mainValue);
                newValues.put("other", valuesOfOther);
                infos.put(mainKey, newValues);
            } else {
                infos.put(mainKey, mainValue);
            }
        }
    }

    public static String encodeHTML(String s) {
        if (UserProfileHelper.isEmpty((String)s)) {
            return s;
        }
        return ESCAPE_HTML_PATTERN.matcher(s).replaceAll("&lt;$1&gt;");
    }

    public static String decodeHTML(String s) {
        if (UserProfileHelper.isEmpty((String)s)) {
            return s;
        }
        return UNESCAPE_HTML_PATTERN.matcher(s).replaceAll("<$1>");
    }

    public static boolean isExistingEmail(String email) {
        try {
            Query query = new Query();
            query.setEmail(email);
            OrganizationService service = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            return service.getUserHandler().findUsersByQuery(query).getSize() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

