/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.organization.OrganizationUtils;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UISocialLogoPortlet.gtmpl")
public class UISocialLogoPortlet
extends UIPortletApplication {
    private Profile profile;
    private static IdentityManager im;

    public String getURL() throws Exception {
        String imageSource = this.getProfile(true).getAvatarUrl();
        if (imageSource == null) {
            imageSource = "/eXoSkin/skin/images/system/UserAvtDefault.png";
        }
        return imageSource;
    }

    public String getNavigationTitle() throws Exception {
        UserNode selectedNode = Util.getUIPortal().getSelectedUserNode();
        UserNavigation userNav = selectedNode.getNavigation();
        if (userNav.getKey().getType().equals((Object)PortalConfig.GROUP_TYPE)) {
            return OrganizationUtils.getGroupLabel((String)userNav.getKey().getName());
        }
        if (userNav.getKey().getType().equals((Object)PortalConfig.USER_TYPE)) {
            ConversationState state = ConversationState.getCurrent();
            User user = (User)state.getAttribute("UserProfile");
            return user.getFullName();
        }
        return "";
    }

    public Profile getProfile(boolean forceReload) throws Exception {
        if (forceReload || this.profile == null) {
            Identity id = this.getIdentity();
            this.profile = id.getProfile();
        }
        return this.profile;
    }

    private Identity getIdentity() throws Exception {
        if (im == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return im.getOrCreateIdentity("organization", this.getCurrentProfileID());
    }

    private String getCurrentProfileID() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }
}

