/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserProfileHelper {
    public static final String CSS_ICON_PREFIX = "uiIconSoc";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String URL_KEY = "url";
    public static final String OTHER_KEY = "other";
    public static final String DEFAULT_PROTOCOL = "http://";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy");

    public static Map<String, Object> getDisplayProfileInfo(Profile currentProfile) {
        String gender;
        String jobTitle;
        LinkedHashMap<String, Object> infos = new LinkedHashMap<String, Object>();
        String email = currentProfile.getEmail();
        if (StringUtils.isNotBlank((CharSequence)email)) {
            infos.put("email", email);
        }
        if (StringUtils.isNotBlank((CharSequence)(jobTitle = currentProfile.getPosition()))) {
            infos.put("position", StringEscapeUtils.escapeHtml4((String)jobTitle));
        }
        if (StringUtils.isNotBlank((CharSequence)(gender = currentProfile.getGender()))) {
            infos.put("gender", StringEscapeUtils.escapeHtml4((String)gender));
        }
        UserProfileHelper.putInfoData((Profile)currentProfile, infos, (String)"phones");
        UserProfileHelper.putInfoData((Profile)currentProfile, infos, (String)"ims");
        UserProfileHelper.putInfoData((Profile)currentProfile, infos, (String)"urls");
        return infos;
    }

    public static List<Map<String, String>> getSortedExperiences(Profile currentProfile) {
        List experiences = UserProfileHelper.getMultiValues((Profile)currentProfile, (String)"experiences");
        if (experiences != null) {
            Collections.sort(experiences, Comparator.comparing(UserProfileHelper::isCurrent).thenComparing(UserProfileHelper::getStartDate).reversed());
        }
        return experiences;
    }

    public static List<Map<String, String>> getMultiValues(Profile currentProfile, String key) {
        return (List)currentProfile.getProperty(key);
    }

    public static List<String> getURLValues(Profile currentProfile) {
        List mapUrls = UserProfileHelper.getMultiValues((Profile)currentProfile, (String)"urls");
        ArrayList<String> urls = new ArrayList<String>();
        if (mapUrls != null) {
            for (Map map : mapUrls) {
                urls.add(StringEscapeUtils.unescapeHtml4((String)((String)map.get("value"))));
            }
        }
        return urls;
    }

    public static boolean isString(Object s) {
        return s instanceof String;
    }

    public static boolean isURL(String key) {
        if (key == null) {
            return false;
        }
        return "urls".equals(key);
    }

    public static String toAbsoluteURL(String url) {
        try {
            URI uri = new URI(url);
            if (uri.isAbsolute()) {
                return url;
            }
        }
        catch (URISyntaxException e) {
            return "http://" + url;
        }
        return "http://" + url;
    }

    public static boolean isIMs(String key) {
        if (key == null) {
            return false;
        }
        return "ims".equals(key);
    }

    public static boolean isGender(String key) {
        if (key == null) {
            return false;
        }
        return "gender".equals(key);
    }

    public static String getIconCss(String key) {
        StringBuilder classBuilder = new StringBuilder();
        if (key.length() > 0) {
            classBuilder.append("uiIconSoc").append(Character.toUpperCase(key.charAt(0)));
            if (key.length() > 1) {
                classBuilder.append(key.substring(1));
            }
        }
        return classBuilder.toString();
    }

    public static Map<String, String> escapeExperience(Map<String, String> experience) {
        LinkedHashMap<String, String> escapedExperience = new LinkedHashMap<String, String>();
        UserProfileHelper.putExperienceData(experience, escapedExperience, (String)"id");
        UserProfileHelper.putExperienceData(experience, escapedExperience, (String)"company");
        UserProfileHelper.putExperienceData(experience, escapedExperience, (String)"position");
        UserProfileHelper.putExperienceData(experience, escapedExperience, (String)"description");
        UserProfileHelper.putExperienceData(experience, escapedExperience, (String)"skills");
        UserProfileHelper.putExperienceData(experience, escapedExperience, (String)"startDate");
        UserProfileHelper.putExperienceData(experience, escapedExperience, (String)"endDate");
        return escapedExperience;
    }

    private static boolean isCurrent(Map<String, String> srcExperience) {
        return Boolean.valueOf(String.valueOf(srcExperience.get("isCurrent")));
    }

    private static LocalDate getStartDate(Map<String, String> srcExperience) {
        return LocalDate.parse(srcExperience.get("startDate"), DATE_TIME_FORMATTER);
    }

    private static void putExperienceData(Map<String, String> srcExperience, Map<String, String> destExperience, String key) {
        String value = srcExperience.get(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            destExperience.put(key, StringEscapeUtils.escapeHtml4((String)value));
        }
    }

    public static String getLabel(WebuiRequestContext context, String key) {
        if (context == null) {
            context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        }
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString(key);
        }
        catch (Exception e) {
            return key.indexOf(".") > 0 ? key.substring(key.lastIndexOf(".") + 1) : key;
        }
    }

    private static void putInfoData(Profile currentProfile, Map<String, Object> infos, String mainKey) {
        List multiValues = UserProfileHelper.getMultiValues((Profile)currentProfile, (String)mainKey);
        if (multiValues != null && multiValues.size() > 0) {
            LinkedHashMap mainValue = new LinkedHashMap();
            for (Map map : multiValues) {
                ArrayList<String> values = new ArrayList<String>();
                String key = (String)map.get("key");
                String value = StringEscapeUtils.escapeHtml4((String)((String)map.get("value")));
                if (mainValue.containsKey(key)) {
                    values.addAll((Collection)mainValue.get(key));
                    values.add(value);
                } else {
                    values.add(value);
                }
                mainValue.put(key, values);
            }
            infos.put(mainKey, mainValue);
        }
    }

    public static boolean isExistingEmail(String email) {
        try {
            Query query = new Query();
            query.setEmail(email);
            OrganizationService service = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            return service.getUserHandler().findUsersByQuery(query).getSize() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

