/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.form;

import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.user.form.UIChangeAvatarContainer;
import org.exoplatform.social.user.portlet.UserProfileHelper;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.form.UIFormInputSet;

@ComponentConfig(events={@EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UIChangeAvatarContainer
extends UIFormInputSet {
    public void processRender(WebuiRequestContext context) throws Exception {
        Profile ownerProfile = Utils.getViewerIdentity((boolean)true).getProfile();
        String fullName = StringEscapeUtils.escapeHtml((String)ownerProfile.getFullName());
        String avatarURL = ownerProfile.getAvatarUrl();
        if (StringUtils.isBlank((CharSequence)avatarURL)) {
            avatarURL = "/eXoSkin/skin/images/system/UserAvtDefault.png";
        }
        Writer writer = context.getWriter();
        writer.append("<div class=\"uiRelationshipAction\" id=\"").append(this.getId()).append("\">");
        writer.append("  <div class=\"avatarLarge\">").append("    <img title=\"").append(fullName).append("\" alt=\"").append(fullName).append("\" src=\"").append(avatarURL).append("?").append(String.valueOf(ownerProfile.getAvatarLastUpdated())).append("\"/>").append("  </div>").append("  <div class=\"btn btn-mini changeAvatar\" onclick=\"").append(this.event("ChangeAvatar")).append("\">").append(UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIChangeAvatarContainer.label.ChangeAvatar")).append("  </div>");
        writer.append("</div>");
    }
}

