/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.portlet.UIMembersPortlet;
import org.exoplatform.social.webui.UIUserInvitation;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="war:/groovy/social/portlet/UIMembersPortlet.gtmpl", events={@EventConfig(listeners={ConnectActionListener.class}), @EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={IgnoreActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMoreManagerActionListener.class}), @EventConfig(listeners={LoadMoreMemberActionListener.class})})})
public class UIMembersPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UIMembersPortlet.class);
    private ListAccess<Identity> memberListAccess;
    private ListAccess<Identity> managerListAccess;
    private List<Identity> memberList;
    private List<Identity> managerList;
    private int memberNum;
    private int managerNum;
    private ProfileFilter memberProfileFilter;
    private ProfileFilter managerProfileFilter;
    private final int MEMBER_PER_PAGE = 48;
    private final int MANAGER_PER_PAGE = 12;
    private static final String SPACE_MEMBER = "member_of_space";
    private static final String ALL_FILTER = "All";
    public static final String SEARCH = "Search";
    private static final char EMPTY_CHARACTER = '\u0000';
    private static final String INVITATION_REVOKED_INFO = "UIMembersPortlet.label.RevokedInfo";
    private static final String INVITATION_ESTABLISHED_INFO = "UIMembersPortlet.label.InvitationEstablishedInfo";
    private int currentLoadIndex = 0;
    private int currentLoadManagerIndex = 0;
    private IdentityManager identityManager_ = null;
    private UIProfileUserSearch uiSearchMemberOfSpace = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
    boolean enableLoadNext;
    boolean enableLoadManagerNext;
    private boolean loadAtEnd;
    private String selectedChar = null;
    private String msg;

    public UIMembersPortlet() throws Exception {
        this.uiSearchMemberOfSpace.setTypeOfRelation(SPACE_MEMBER);
        this.uiSearchMemberOfSpace.setSpaceURL(this.getSpace().getUrl());
        this.uiSearchMemberOfSpace.setHasPeopleTab(false);
        this.addChild((UIComponent)this.uiSearchMemberOfSpace);
        this.initMember();
        this.initManager();
        boolean isAdmin = false;
        String currentUser = Utils.getViewerRemoteId();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        Space space = this.getSpace();
        boolean bl = isAdmin = spaceService.isSuperManager(currentUser) || spaceService.isManager(space, currentUser);
        if (isAdmin) {
            this.addChild(UIUserInvitation.class, null, null);
        }
    }

    public void setMemberListAccess(ListAccess<Identity> memberListAccess) {
        this.memberListAccess = memberListAccess;
    }

    public ListAccess<Identity> getMemberListAccess() {
        return this.memberListAccess;
    }

    public void setManagerListAccess(ListAccess<Identity> managerListAccess) {
        this.managerListAccess = managerListAccess;
    }

    public ListAccess<Identity> getManagerListAccess() {
        return this.managerListAccess;
    }

    public int getMemberNum() {
        return this.memberNum;
    }

    public void setMemberNum(int memberNum) {
        this.memberNum = memberNum;
    }

    public int getManagerNum() {
        return this.managerNum;
    }

    public void setManagerNum(int managerNum) {
        this.managerNum = managerNum;
    }

    public final String getSelectedChar() {
        return this.selectedChar;
    }

    public final void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    private List<Identity> loadPeople(int index, int length, SpaceMemberFilterListAccess.Type type) throws Exception {
        Identity[] result = null;
        Space space = this.getSpace();
        if (SpaceMemberFilterListAccess.Type.MEMBER.equals((Object)type)) {
            ProfileFilter filter = this.uiSearchMemberOfSpace.getProfileFilter();
            this.setMemberListAccess(Utils.getIdentityManager().getSpaceIdentityByProfileFilter(space, filter, type, true));
            this.setMemberNum(this.getMemberListAccess().getSize());
            this.uiSearchMemberOfSpace.setPeopleNum(this.getMemberNum());
            result = (Identity[])this.getMemberListAccess().load(index, length);
        } else if (SpaceMemberFilterListAccess.Type.MANAGER.equals((Object)type)) {
            ProfileFilter filter = this.managerProfileFilter;
            this.setManagerListAccess(Utils.getIdentityManager().getSpaceIdentityByProfileFilter(space, filter, type, true));
            this.setManagerNum(this.getManagerListAccess().getSize());
            result = (Identity[])this.getManagerListAccess().load(index, length);
        }
        return Arrays.asList(result);
    }

    public void setIdentityList(ListAccess<Identity> identityList) {
        this.memberListAccess = identityList;
    }

    public void setMemberList(List<Identity> memberList) {
        this.memberList = memberList;
    }

    public List<Identity> getMemberList() throws Exception {
        int elementsToDisplay = this.currentLoadIndex + 48;
        this.setMemberList(this.loadPeople(0, elementsToDisplay, SpaceMemberFilterListAccess.Type.MEMBER));
        this.setEnableLoadNext(elementsToDisplay < this.memberNum);
        return this.memberList;
    }

    public void setManagerList(List<Identity> managerList) {
        this.managerList = managerList;
    }

    public List<Identity> getManagerList() throws Exception {
        int elementsToDisplay = this.currentLoadManagerIndex + 12;
        this.setManagerList(this.loadPeople(0, elementsToDisplay, SpaceMemberFilterListAccess.Type.MANAGER));
        this.setEnableLoadManagerNext(elementsToDisplay < this.managerNum);
        return this.managerList;
    }

    public void initMember() throws Exception {
        try {
            this.setLoadAtEnd(false);
            this.enableLoadNext = false;
            this.currentLoadIndex = 0;
            this.setSelectedChar(ALL_FILTER);
            this.memberProfileFilter = new ProfileFilter();
            this.memberProfileFilter.setViewerIdentity(Utils.getViewerIdentity());
            this.uiSearchMemberOfSpace.setProfileFilter(this.memberProfileFilter);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void initManager() throws Exception {
        this.managerProfileFilter = new ProfileFilter();
        this.currentLoadManagerIndex = 0;
        this.enableLoadManagerNext = false;
    }

    public Space getSpace() throws SpaceException {
        String spaceUrl = Utils.getSpaceUrlByContext();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        return spaceService.getSpaceByUrl(spaceUrl);
    }

    public String getPath() {
        String nodePath = Util.getPortalRequestContext().getNodePath();
        String uriPath = Util.getPortalRequestContext().getRequestURI();
        return uriPath.replaceAll(nodePath, "");
    }

    public String getMemberships(String userName) throws Exception {
        String memberShip = null;
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        MembershipHandler memberShipHandler = orgService.getMembershipHandler();
        Collection memberShips = memberShipHandler.findMembershipsByUserAndGroup(userName, this.getSpace().getGroupId());
        for (Membership aaa : memberShips) {
            if (memberShip == null) {
                memberShip = aaa.getMembershipType();
                continue;
            }
            memberShip = memberShip + "," + aaa.getMembershipType();
        }
        return memberShip;
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setMemberList(this.loadPeople(this.currentLoadIndex, 48, SpaceMemberFilterListAccess.Type.MEMBER));
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager_ == null) {
            PortalContainer pcontainer = PortalContainer.getInstance();
            this.identityManager_ = (IdentityManager)pcontainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager_;
    }

    public void increaseOffset() throws Exception {
        this.currentLoadIndex += 48;
    }

    public void increaseOffsetManager() throws Exception {
        this.currentLoadManagerIndex += 12;
    }

    @Deprecated
    public void loadNextMember() throws Exception {
        this.currentLoadIndex += 48;
        if (this.currentLoadIndex <= this.getMemberNum()) {
            ArrayList<Object> currentPeopleList = new ArrayList<Object>(this.memberList);
            ArrayList<Object> loadedPeople = new ArrayList<Object>(Arrays.asList(this.getMemberListAccess().load(this.currentLoadIndex, 48)));
            currentPeopleList.addAll(loadedPeople);
            this.setMemberList(currentPeopleList);
        }
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public void setEnableLoadManagerNext(boolean enableLoadNext) {
        this.enableLoadManagerNext = enableLoadNext;
    }

    static /* synthetic */ UIProfileUserSearch access$000(UIMembersPortlet x0) {
        return x0.uiSearchMemberOfSpace;
    }

    static /* synthetic */ int access$100(UIMembersPortlet x0) {
        return x0.currentLoadIndex;
    }

    static /* synthetic */ int access$200(UIMembersPortlet x0) {
        return x0.memberNum;
    }

    static /* synthetic */ int access$300(UIMembersPortlet x0) {
        return x0.currentLoadManagerIndex;
    }

    static /* synthetic */ int access$400(UIMembersPortlet x0) {
        return x0.managerNum;
    }
}

