import { spacesConstants } from '../js/spacesConstants.js';

export function getGettingStartedSteps(){
  return fetch(`${spacesConstants.PORTAL_CONTEXT}/${spacesConstants.PORTAL_REST}/getting-started`, {credentials: 'include'}).then(resp => resp.json());
}

export function saveGettingStartedSettings() {
  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/settings/USER,${eXo.env.portal.userName}/APPLICATION,GettingStarted/gettingStartedStatus`, {
    method: 'PUT',
    credentials: 'include',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json',
    },
    body: JSON.stringify({
      value: true,
    }),
  }).then((resp) => {
    if (resp && resp.ok) {
      return resp;
    } else {
      throw new Error('Error setting getting started  settings');
    }
  }).then(resp => {
    return resp;
  });
}
export function getGettingStartedSettings() {
  return fetch(`${eXo.env.portal.context}/${eXo.env.portal.rest}/v1/settings/USER,${eXo.env.portal.userName}/APPLICATION,GettingStarted/gettingStartedStatus`, {
    method: 'GET',
    credentials: 'include',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json',
    },
  }).then((resp) => {
    if (resp && resp.ok) {
      return resp.json();
    } else if (resp && resp.status === 404) {
      return null;
    } else {
      throw new Error('Error getting started settings');
    }
  }).then(resp => {
    return resp;
  });
}